/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.storage;

import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.level.map.CaveBiomeMapWorldWorker;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.WorldWorkerManager;

public class ACWorldData
extends SavedData {
    private static final String IDENTIFIER = "alexscaves_world_data";
    private Map<UUID, Integer> deepOneReputations = new HashMap<UUID, Integer>();
    private boolean primordialBossDefeatedOnce = false;
    private long firstPrimordialBossDefeatTimestamp = -1L;
    private Set<Integer> trackedLuxtructosaurusIds = new ObjectArraySet();
    private CaveBiomeMapWorldWorker lastMapWorker = null;

    private ACWorldData() {
    }

    public static ACWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_7654_().m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            ACWorldData data = (ACWorldData)storage.m_164861_(ACWorldData::load, ACWorldData::new, IDENTIFIER);
            if (data != null) {
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public static ACWorldData load(CompoundTag nbt) {
        ACWorldData data = new ACWorldData();
        if (nbt.m_128441_("DeepOneReputations")) {
            ListTag listtag = nbt.m_128437_("DeepOneReputations", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag innerTag = listtag.m_128728_(i);
                data.deepOneReputations.put(innerTag.m_128342_("UUID"), innerTag.m_128451_("Reputation"));
            }
        }
        data.primordialBossDefeatedOnce = nbt.m_128471_("PrimordialBossDefeatedOnce");
        data.firstPrimordialBossDefeatTimestamp = nbt.m_128454_("FirstPrimordialBossDefeatTimestamp");
        data.trackedLuxtructosaurusIds = Arrays.stream(nbt.m_128465_("TrackedLuxtructosaurusIds")).boxed().collect(Collectors.toSet());
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (!this.deepOneReputations.isEmpty()) {
            ListTag listTag = new ListTag();
            for (Map.Entry<UUID, Integer> reputations : this.deepOneReputations.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("UUID", reputations.getKey());
                tag.m_128405_("Reputation", reputations.getValue().intValue());
                listTag.add((Object)tag);
            }
            compound.m_128365_("DeepOneReputations", (Tag)listTag);
        }
        compound.m_128379_("PrimordialBossDefeatedOnce", this.primordialBossDefeatedOnce);
        compound.m_128356_("FirstPrimordialBossDefeatTimestamp", this.firstPrimordialBossDefeatTimestamp);
        compound.m_128385_("TrackedLuxtructosaurusIds", this.trackedLuxtructosaurusIds.stream().mapToInt(Integer::intValue).toArray());
        return compound;
    }

    public int getDeepOneReputation(@Nullable UUID uuid) {
        return uuid == null ? 0 : this.deepOneReputations.getOrDefault(uuid, 0);
    }

    public void setDeepOneReputation(UUID uuid, int reputation) {
        this.deepOneReputations.put(uuid, Mth.m_14045_((int)reputation, (int)-100, (int)100));
    }

    public boolean isPrimordialBossActive(Level level) {
        for (int i : this.trackedLuxtructosaurusIds) {
            LuxtructosaurusEntity lux;
            Entity entity = level.m_6815_(i);
            if (!(entity instanceof LuxtructosaurusEntity) || !(lux = (LuxtructosaurusEntity)entity).m_6084_() || !lux.isLoadedInWorld()) continue;
            return true;
        }
        return false;
    }

    public void trackPrimordialBoss(int id, boolean add) {
        if (add) {
            this.trackedLuxtructosaurusIds.add(id);
        } else {
            this.trackedLuxtructosaurusIds.remove(id);
        }
    }

    public boolean isPrimordialBossDefeatedOnce() {
        return this.primordialBossDefeatedOnce;
    }

    public void setPrimordialBossDefeatedOnce(boolean defeatedOnce) {
        this.primordialBossDefeatedOnce = defeatedOnce;
    }

    public long getFirstPrimordialBossDefeatTimestamp() {
        return this.firstPrimordialBossDefeatTimestamp;
    }

    public void setFirstPrimordialBossDefeatTimestamp(long time) {
        this.firstPrimordialBossDefeatTimestamp = time;
    }

    public void fillOutCaveMap(UUID uuid, ItemStack map, ServerLevel serverLevel, BlockPos center, Player player) {
        if (this.lastMapWorker != null) {
            this.lastMapWorker.onWorkComplete(this.lastMapWorker.getLastFoundBiome());
        }
        this.lastMapWorker = new CaveBiomeMapWorldWorker(map, serverLevel, center, player, uuid);
        WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this.lastMapWorker);
    }

    public boolean isCaveMapTicking() {
        return this.lastMapWorker != null && this.lastMapWorker.hasWork();
    }
}

