/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.DinosaurSpiritEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.TephraExplosion;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class ExtinctionSpearEntity
extends AbstractArrow {
    private boolean dealtDamage;
    private ItemStack spearItem = new ItemStack((ItemLike)ACItemRegistry.EXTINCTION_SPEAR.get());
    private static final EntityDataAccessor<Boolean> WIGGLING = SynchedEntityData.m_135353_(ExtinctionSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksWiggling = 0;

    public ExtinctionSpearEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public ExtinctionSpearEntity(Level level, LivingEntity shooter, ItemStack itemStack) {
        super((EntityType)ACEntityRegistry.EXTINCTION_SPEAR.get(), shooter, level);
        this.spearItem = itemStack.m_41777_();
    }

    public ExtinctionSpearEntity(Level level, double x, double y, double z) {
        super((EntityType)ACEntityRegistry.EXTINCTION_SPEAR.get(), x, y, z, level);
    }

    public ExtinctionSpearEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.EXTINCTION_SPEAR.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WIGGLING, (Object)false);
    }

    protected ItemStack m_7941_() {
        return this.spearItem;
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.m_6351_(vec3, vec31);
    }

    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if ((this.f_36703_ || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (this.isWiggling()) {
                if (this.ticksWiggling++ > 20) {
                    this.setWiggling(false);
                    this.explode();
                }
            } else {
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                if (!this.m_36797_()) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_36790_(true);
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.3;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
            }
        }
        if (this.m_9236_().f_46443_ && !this.f_36703_) {
            Vec3 center = this.m_20182_().m_82520_(0.0, 0.25, 0.0);
            Vec3 vec3 = this.m_20184_().m_82490_((double)-0.2f);
            this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.TEPHRA_FLAME.get(), true, center.f_82479_, center.f_82480_, center.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
    }

    protected boolean m_142470_(Player player) {
        Entity entity = this.m_19749_();
        if (entity == null || entity.equals((Object)player)) {
            return super.m_142470_(player);
        }
        return false;
    }

    private void explode() {
        TephraExplosion explosion = new TephraExplosion(this.m_9236_(), this.m_19749_(), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1.5f, Explosion.BlockInteraction.KEEP);
        explosion.explode();
        explosion.finalizeExplosion(true);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.setWiggling(true);
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        float f = 10.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = (SoundEvent)ACSoundRegistry.EXTINCTION_SPEAR_HIT.get();
        if (entity.m_6469_(damagesource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            entity.m_20254_(5);
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
            if (entity1 != null) {
                DinosaurSpiritEntity dinosaurSpirit = (DinosaurSpiritEntity)((EntityType)ACEntityRegistry.DINOSAUR_SPIRIT.get()).m_20615_(this.m_9236_());
                dinosaurSpirit.m_6034_(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_());
                dinosaurSpirit.setDinosaurType(DinosaurSpiritEntity.DinosaurType.SUBTERRANODON);
                dinosaurSpirit.setPlayerUUID(entity1.m_20148_());
                dinosaurSpirit.setAttackingEntityId(entity.m_19879_());
                dinosaurSpirit.m_7618_(EntityAnchorArgument.Anchor.EYES, entity1.m_146892_());
                dinosaurSpirit.setEnchantmentLevel(this.spearItem.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.PLUMMETING_FLIGHT.get()));
                this.m_5496_((SoundEvent)ACSoundRegistry.EXTINCTION_SPEAR_SUMMON.get(), 1.0f, 1.0f);
                this.m_9236_().m_7967_((Entity)dinosaurSpirit);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.m_5496_(soundevent, f1, 1.0f);
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)ACSoundRegistry.LIMESTONE_SPEAR_HIT.get();
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean isWiggling() {
        return (Boolean)this.f_19804_.m_135370_(WIGGLING);
    }

    public void setWiggling(boolean wiggling) {
        this.f_19804_.m_135381_(WIGGLING, (Object)wiggling);
    }
}

