/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.fluid;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.AcidFluidType;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ACFluidRegistry {
    public static final DeferredRegister<FluidType> FLUID_TYPE_DEF_REG = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"alexscaves");
    public static final DeferredRegister<Fluid> FLUID_DEF_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"alexscaves");
    public static final RegistryObject<FluidType> ACID_FLUID_TYPE = FLUID_TYPE_DEF_REG.register("acid", () -> new AcidFluidType(FluidType.Properties.create().lightLevel(5).density(1024).viscosity(1024).pathType(BlockPathTypes.LAVA).adjacentPathType(BlockPathTypes.DANGER_OTHER).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)ACSoundRegistry.ACID_UNSUBMERGE.get()).sound(SoundActions.BUCKET_FILL, (SoundEvent)ACSoundRegistry.ACID_SUBMERGE.get())));
    public static final RegistryObject<FlowingFluid> ACID_FLUID_SOURCE = FLUID_DEF_REG.register("acid", () -> new ForgeFlowingFluid.Source(ACFluidRegistry.acidProperties()));
    public static final RegistryObject<FlowingFluid> ACID_FLUID_FLOWING = FLUID_DEF_REG.register("acid_flowing", () -> new ForgeFlowingFluid.Flowing(ACFluidRegistry.acidProperties()));

    private static ForgeFlowingFluid.Properties acidProperties() {
        return new ForgeFlowingFluid.Properties(ACID_FLUID_TYPE, ACID_FLUID_SOURCE, ACID_FLUID_FLOWING).bucket(ACItemRegistry.ACID_BUCKET).block(ACBlockRegistry.ACID);
    }

    public static void postInit() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ACID_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> Blocks.f_220864_.m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ACID_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), fluidState -> ((Block)ACBlockRegistry.RADROCK.get()).m_49966_()));
    }
}

