/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mixin.typing;

import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import org.arbor.extrasounds.misc.SoundManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
public abstract class TextFieldWidgetMixin {
    @Unique
    private int extra_sounds$cursorStart = 0;
    @Unique
    private int extra_sounds$cursorEnd = 0;
    @Shadow
    private int f_94101_;
    @Shadow
    private int f_94102_;
    @Shadow
    private int f_94094_;

    @Shadow
    public abstract String m_94173_();

    @Shadow
    public abstract String m_94155_();

    @Unique
    private void extrasounds$cursorChanged() {
        boolean bSamePos;
        boolean bl = bSamePos = this.extra_sounds$cursorStart == this.f_94101_ && this.extra_sounds$cursorEnd == this.f_94102_;
        if (bSamePos) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.CURSOR);
        this.extra_sounds$cursorStart = this.f_94101_;
        this.extra_sounds$cursorEnd = this.f_94102_;
    }

    @Inject(method={"deleteText"}, at={@At(value="HEAD")})
    private void extrasounds$eraseStrHead(int offset, CallbackInfo ci) {
        boolean bTailDelete;
        boolean bHeadBackspace = offset < 0 && this.f_94101_ <= 0;
        boolean bl = bTailDelete = offset > 0 && this.f_94102_ >= this.m_94155_().length();
        if ((bHeadBackspace || bTailDelete) && this.f_94101_ == this.f_94102_) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.ERASE);
    }

    @Inject(method={"deleteText"}, at={@At(value="RETURN")})
    private void extrasounds$eraseStrReturn(int offset, CallbackInfo ci) {
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.f_94102_;
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getHighlighted()Ljava/lang/String;", shift=At.Shift.AFTER)})
    private void extrasounds$cutAction(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!Screen.m_96628_((int)keyCode) || this.m_94173_().isEmpty()) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.CUT);
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.f_94102_;
    }

    @Inject(method={"charTyped"}, at={@At(value="RETURN")})
    private void extrasounds$appendChar(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() || this.m_94155_().length() >= this.f_94094_) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.INSERT);
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.f_94102_;
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyboardHandler;getClipboard()Ljava/lang/String;", shift=At.Shift.AFTER)})
    private void extrasounds$pasteAction(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!Screen.m_96630_((int)keyCode) || this.m_94155_().length() >= this.f_94094_) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.PASTE);
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.f_94102_;
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getWordPosition(I)I", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursor(I)V", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorToStart()V", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorToEnd()V", shift=At.Shift.AFTER)})
    private void extrasounds$cursorMoveKeyTyped(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        this.extrasounds$cursorChanged();
    }

    @Inject(method={"onClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorTo(I)V", shift=At.Shift.AFTER)})
    private void extrasounds$clickEvent(double mouseX, double mouseY, CallbackInfo ci) {
        this.extrasounds$cursorChanged();
    }
}

