/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mapping;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiscFragmentItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFrameItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.KnowledgeBookItem;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.arbor.extrasounds.ExtraSounds;
import org.arbor.extrasounds.debug.DebugUtils;
import org.arbor.extrasounds.mapping.SoundDefinition;
import org.arbor.extrasounds.mapping.SoundGenerator;
import org.arbor.extrasounds.mixin.BucketFluidAccessor;
import org.arbor.extrasounds.sounds.Categories;
import org.arbor.extrasounds.sounds.Sounds;

public final class AutoGenerator {
    public static List<SoundGenerator> getSoundGenerators() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (IModInfo mod : ModList.get().getMods()) {
            namespaces.add(mod.getModId());
        }
        namespaces.remove("minecraft");
        return SoundGenerator.auto(namespaces, AutoGenerator::autoGenerator);
    }

    public static SoundDefinition autoGenerator(Item item) {
        if (item instanceof RecordItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.MUSIC_DISC));
        }
        if (item instanceof BoatItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.BOAT));
        }
        if (item instanceof TieredItem) {
            TieredItem toolItem = (TieredItem)item;
            Tier tier = toolItem.m_43314_();
            if (tier instanceof Tiers) {
                Tiers mat = (Tiers)tier;
                return switch (mat) {
                    case Tiers.WOOD -> SoundDefinition.of(Sounds.aliased(Categories.Gear.WOOD));
                    case Tiers.STONE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.STONE));
                    case Tiers.IRON -> SoundDefinition.of(Sounds.aliased(Categories.Gear.IRON));
                    case Tiers.GOLD -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GOLDEN));
                    case Tiers.DIAMOND -> SoundDefinition.of(Sounds.aliased(Categories.Gear.DIAMOND));
                    case Tiers.NETHERITE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.NETHERITE));
                    default -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
                };
            }
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            ArmorMaterial armorMaterial = armorItem.m_40401_();
            if (armorMaterial instanceof ArmorMaterials) {
                ArmorMaterials mat = (ArmorMaterials)armorMaterial;
                return switch (mat) {
                    case ArmorMaterials.IRON -> SoundDefinition.of(Sounds.aliased(Categories.Gear.IRON));
                    case ArmorMaterials.GOLD -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GOLDEN));
                    case ArmorMaterials.DIAMOND -> SoundDefinition.of(Sounds.aliased(Categories.Gear.DIAMOND));
                    case ArmorMaterials.NETHERITE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.NETHERITE));
                    case ArmorMaterials.CHAIN -> SoundDefinition.of(Sounds.aliased(Categories.Gear.CHAIN));
                    case ArmorMaterials.TURTLE -> SoundDefinition.of(Sounds.aliased(Categories.Gear.TURTLE));
                    case ArmorMaterials.LEATHER -> SoundDefinition.of(Sounds.aliased(Categories.Gear.LEATHER));
                    default -> SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
                };
            }
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        }
        if (item instanceof ShieldItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.IRON));
        }
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            return AutoGenerator.getBucketItemSound(bucketItem);
        }
        if (item instanceof MinecartItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.MINECART));
        }
        if (item instanceof ItemFrameItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.FRAME));
        }
        if (item instanceof PotionItem || item instanceof ExperienceBottleItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.POTION));
        }
        if (item instanceof ArrowItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.ARROW));
        }
        if (item instanceof DyeItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.DUST));
        }
        if (item instanceof SpawnEggItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.WET_SLIPPERY));
        }
        if (item instanceof BowlFoodItem || item instanceof SuspiciousStewItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.BOWL));
        }
        if (item instanceof InstrumentItem) {
            return SoundDefinition.of(Sounds.single(Categories.LOOSE_METAL.m_11660_(), 0.6f, 0.9f, Sound.Type.SOUND_EVENT));
        }
        if (item instanceof SmithingTemplateItem) {
            return SoundDefinition.of(Sounds.aliased(Categories.LOOSE_METAL));
        }
        if (item instanceof DiscFragmentItem) {
            return SoundDefinition.of(Sounds.single(Categories.METAL_BITS.m_11660_(), 0.7f, 0.85f, Sound.Type.SOUND_EVENT));
        }
        if (AutoGenerator.isBrickItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.BRICK));
        }
        if (AutoGenerator.isGearGoldenItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GOLDEN));
        }
        if (AutoGenerator.isGearLeatherItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.LEATHER));
        }
        if (AutoGenerator.isGearGenericItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.Gear.GENERIC));
        }
        if (AutoGenerator.isPaperItem(item)) {
            return SoundDefinition.of(Sounds.aliased(Categories.PAPER));
        }
        if (item instanceof BlockItem) {
            RotatedPillarBlock pillarBlock;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            ResourceLocation blockSound = AutoGenerator.getSoundType(block).m_56777_().m_11660_();
            if (block instanceof BaseRailBlock) {
                return SoundDefinition.of(Sounds.aliased(Categories.RAIL));
            }
            if (block instanceof BannerBlock) {
                return SoundDefinition.of(Sounds.aliased(Categories.BANNER));
            }
            if (block instanceof SeaPickleBlock) {
                return SoundDefinition.of(Sounds.event(blockSound, 0.4f));
            }
            if (block instanceof LeavesBlock || block instanceof BushBlock || block instanceof SugarCaneBlock) {
                ResourceLocation soundId = AutoGenerator.getSoundType(block).m_56777_().m_11660_();
                if (soundId.m_135815_().equals("block.grass.place")) {
                    return SoundDefinition.of(Sounds.aliased(Categories.LEAVES));
                }
                return SoundDefinition.of(Sounds.event(soundId));
            }
            if (block instanceof RotatedPillarBlock && AutoGenerator.getSoundType((Block)(pillarBlock = (RotatedPillarBlock)block)).equals(SoundType.f_222465_)) {
                return SoundDefinition.of(Sounds.event(blockSound, 0.3f));
            }
            return SoundDefinition.of(Sounds.event(blockSound));
        }
        return SoundDefinition.of(Sounds.aliased(Sounds.ITEM_PICK));
    }

    private static boolean isGearGoldenItem(Item item) {
        return item instanceof HorseArmorItem || item instanceof CompassItem || item instanceof SpyglassItem || item instanceof ShearsItem;
    }

    private static boolean isGearLeatherItem(Item item) {
        return item instanceof LeadItem || item instanceof ElytraItem || item instanceof SaddleItem;
    }

    private static boolean isGearGenericItem(Item item) {
        return item instanceof BowItem || item instanceof CrossbowItem || item instanceof FishingRodItem || item instanceof FoodOnAStickItem;
    }

    private static boolean isPaperItem(Item item) {
        return item instanceof BannerPatternItem || item instanceof BookItem || item instanceof WritableBookItem || item instanceof WrittenBookItem || item instanceof EnchantedBookItem || item instanceof EmptyMapItem || item instanceof MapItem || item instanceof NameTagItem || item instanceof KnowledgeBookItem;
    }

    private static boolean isBrickItem(Item item) {
        return item == Items.f_42460_ || AutoGenerator.getDescriptionId(item).endsWith("pottery_sherd");
    }

    private static String getDescriptionId(Item item) {
        String id = "";
        try {
            id = item.m_5524_();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return id;
    }

    private static SoundDefinition getBucketItemSound(BucketItem bucketItem) {
        SoundEventRegistration soundEntry;
        try {
            Fluid fluid = ((BucketFluidAccessor)bucketItem).getContent();
            soundEntry = fluid.m_142520_().map(sound -> Sounds.event(sound.m_11660_(), 0.4f)).orElse(Sounds.aliased(Categories.METAL));
        }
        catch (NullPointerException ignored) {
            soundEntry = Sounds.aliased(Categories.METAL);
        }
        return SoundDefinition.of(soundEntry);
    }

    public static SoundType getSoundType(Block block) {
        try {
            return block.m_49962_(block.m_49966_());
        }
        catch (Throwable e) {
            if (DebugUtils.DEBUG) {
                ExtraSounds.LOGGER.error("Failed to get sound type for block " + block, e);
            }
            return SoundType.f_56742_;
        }
    }
}

