/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.items.pearls;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.BasePetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.ThrownAncientPearl;

public class AncientPearlItem
extends EnderpearlItem {
    public static final int HEAL_TICK_RATE = 2500;

    public AncientPearlItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11857_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        player.m_36335_().m_41524_((Item)this, 20);
        if (!level.m_5776_()) {
            ThrownAncientPearl pearl;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("PetEntity")) {
                BasePetEnderman pet = ThrownAncientPearl.createPet(level, player, switch (tag.m_128461_("PetType")) {
                    case "hammerhead_pet_enderman" -> 1;
                    case "axolotl_pet_enderman" -> 2;
                    default -> 0;
                });
                pet.m_20258_(tag.m_128469_("PetEntity"));
                pearl = new ThrownAncientPearl(level, (LivingEntity)player, (Entity)pet);
            } else {
                pearl = new ThrownAncientPearl(level, (LivingEntity)player);
            }
            pearl.m_37446_(stack);
            pearl.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_((Entity)pearl);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(ConstantComponents.ANCIENT_PEARL_TOOLTIP);
        if (level == null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("PetEntity")) {
            CompoundTag petTag = tag.m_128469_("PetEntity");
            int health = petTag.m_128451_("Health");
            tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.endermanoverhaul.ancient_pet", (Object[])new Object[]{health}).m_130940_(ChatFormatting.GREEN));
        }
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (level.m_5776_()) {
            return;
        }
        if (entity.f_19797_ % 2500 != 0) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("PetEntity")) {
            CompoundTag petTag = tag.m_128469_("PetEntity");
            petTag.m_128405_("Health", Math.min(petTag.m_128451_("Health") + 1, 30));
            tag.m_128365_("PetEntity", (Tag)petTag);
            stack.m_41751_(tag);
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_("PetEntity");
    }
}

