/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.reg;

import com.google.common.base.Stopwatch;
import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.dispenser_interactions.MineomiteBehavior;
import com.ordana.spelunkery.blocks.dispenser_interactions.PebbleBehavior;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModTags;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModSetup {
    private static int setupStage = 0;
    private static final List<Runnable> MOD_SETUP_WORK = List.of(ModSetup::registerFabricFlammable, ModSetup::registerDispenserBehvaiors);

    public static void setup() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Stopwatch watch = Stopwatch.createStarted();
            for (int i = 0; i < MOD_SETUP_WORK.size(); ++i) {
                setupStage = i;
                MOD_SETUP_WORK.get(i).run();
                list.add(watch.elapsed().toMillis());
                watch.reset();
                watch.start();
            }
            Spelunkery.LOGGER.info("Finished mod setup in: {} ms", list);
        }
        catch (Exception e) {
            Spelunkery.LOGGER.error((Object)e);
            ModSetup.terminateWhenSetupFails();
        }
    }

    private static void terminateWhenSetupFails() {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors");
    }

    private static void registerFabricFlammable() {
        RegHelper.registerBlockFlammability((Block)ModBlocks.WOODEN_CHANNEL.get(), (int)5, (int)20);
        RegHelper.registerBlockFlammability((Block)ModBlocks.WOODEN_SLUICE.get(), (int)5, (int)20);
    }

    private static void registerDispenserBehvaiors() {
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new MineomiteBehavior(ModItems.MINEOMITE.get()));
        BuiltInRegistries.f_257033_.m_206058_(ModTags.PEBBLES).iterator().forEachRemaining(h -> DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new PebbleBehavior((Item)h.m_203334_())));
        BuiltInRegistries.f_257033_.m_206058_(ModTags.GLOWSTICKS).iterator().forEachRemaining(h -> DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new PebbleBehavior((Item)h.m_203334_())));
    }
}

