/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.forge;

import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModSoundEvents;
import com.ordana.spelunkery.reg.ModTags;
import com.ordana.spelunkery.utils.LevelHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.FlowingFluid;

public class PortalFluidBlock
extends LiquidBlock {
    private int tickCounter = 0;

    public PortalFluidBlock(Supplier<FlowingFluid> flowingFluid, BlockBehaviour.Properties properties) {
        super(flowingFluid, properties);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.setTickCounter(0);
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        Optional registry = level.m_9598_().m_6632_(Registries.f_256787_);
        if (registry.isPresent() && level.m_6042_() == ((Registry)registry.get()).m_6246_(BuiltinDimensionTypes.f_223540_) && level.m_141937_() == pos.m_123342_() && !CommonConfigs.END_OCEAN_BUCKETABLE.get().booleanValue()) {
            return ItemStack.f_41583_;
        }
        return super.m_142598_(level, pos, state);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ServerPlayer player;
        if (entity.m_6095_().m_204039_(ModTags.PORTAL_FLUID_IMMUNE) || !entity.isInFluidType() || entity.m_20159_() || entity.m_20160_() || !entity.m_6072_() || pos.equals((Object)level.m_220360_())) {
            return;
        }
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_36341_()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < 1) {
            entity.m_5496_((SoundEvent)ModSoundEvents.PORTAL_FLUID_SUBMERGE.get(), 1.0f, 1.0f);
        }
        level.m_186460_(pos, (Block)this, 120);
        if (this.tickCounter >= 100) {
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                LevelHelper.teleportToSpawnPosition(player);
            } else {
                LevelHelper.teleportToWorldspawn(level, entity);
            }
            entity.m_5496_((SoundEvent)ModSoundEvents.PORTAL_FLUID_TELEPORT.get(), 1.0f, 1.0f);
            this.setTickCounter(0);
        }
    }
}

