/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.entities.DustBunnyModel;
import com.ordana.spelunkery.entities.DustBunnyRenderer;
import com.ordana.spelunkery.entities.PrimedMineomiteEntityRenderer;
import com.ordana.spelunkery.items.AmethystTuningForkItem;
import com.ordana.spelunkery.items.HandheldCompactorItem;
import com.ordana.spelunkery.items.MagneticCompassItem;
import com.ordana.spelunkery.items.magnetic_compass.MagneticCompassItemPropertyFunction;
import com.ordana.spelunkery.particles.PortalFluidFlameParticle;
import com.ordana.spelunkery.particles.SulfurParticle;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import com.ordana.spelunkery.reg.ModFluids;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModParticles;
import net.mehvahdjukaar.moonlight.api.client.renderer.FallingBlockRendererGeneric;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.ExplodeParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class SpelunkeryClient {
    public static final ModelLayerLocation DUST_BUNNY = SpelunkeryClient.loc("dust_bunny");
    public static final ResourceLocation PARACHUTE_3D_MODEL = Spelunkery.res("entity/parachute");
    private static boolean finishedSetup = false;

    public static void init() {
        ClientHelper.addClientSetup(SpelunkeryClient::setup);
        ClientHelper.addModelLayerRegistration(SpelunkeryClient::registerLayers);
        ClientHelper.addEntityRenderersRegistration(SpelunkeryClient::registerEntityRenderers);
        ClientHelper.addSpecialModelRegistration(SpelunkeryClient::registerSpecialModels);
        ClientHelper.addParticleRegistration(SpelunkeryClient::registerParticles);
    }

    public static void setup() {
        ClientHelper.registerFluidRenderType((Fluid)((Fluid)ModFluids.FLOWING_PORTAL_FLUID.get()), (RenderType)RenderType.m_110466_());
        ClientHelper.registerFluidRenderType((Fluid)((Fluid)ModFluids.PORTAL_FLUID.get()), (RenderType)RenderType.m_110466_());
        ClientHelper.registerFluidRenderType((Fluid)((Fluid)ModFluids.FLOWING_SPRING_WATER.get()), (RenderType)RenderType.m_110466_());
        ClientHelper.registerFluidRenderType((Fluid)((Fluid)ModFluids.SPRING_WATER.get()), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.POLISHED_QUARTZ_BLOCK.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)((Block)ModBlocks.PORTAL_FLUID.get()), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.PORTAL_CAULDRON.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)((Block)ModBlocks.SPRING_WATER.get()), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.WOODEN_SLUICE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.STONE_SLUICE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.MINEOMITE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.SALT_LAMP.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.SALT.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WOODEN_RAIL.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.ROPE_LADDER.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.TANGLE_ROOTS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.TANGLE_ROOTS_PLANT.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.SPOROPHYTE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.TALL_SPOROPHYTE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.CONK_FUNGUS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WHITE_INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.PHOSPHOR_FUNGUS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.MUSHGLOOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.MILLY_BUBCAP.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.PORTABELLA.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.CRIMINI.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.BUTTON_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_WHITE_INKCAP_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_PHOSPHOR_FUNGUS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_MUSHGLOOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_MILLY_BUBCAP.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_PORTABELLA.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_CRIMINI.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_BUTTON_MUSHROOM.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.POTTED_SPOROPHYTE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.NEPHRITE_FOUNTAIN.get(), (RenderType)RenderType.m_110463_());
        ItemProperties.m_174570_((Item)ModItems.DEPTH_GAUGE.get(), (ResourceLocation)Spelunkery.res("depth"), (stack, world, entity, seed) -> entity != null ? ((float)entity.m_146904_() + 64.0f) / 384.0f : 0.0f);
        ItemProperties.m_174570_((Item)ModItems.NEPHRITE_CHARM.get(), (ResourceLocation)Spelunkery.res("charge"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)stack.m_41783_().m_128451_("xp") / 1395.0f : 0.0f);
        ItemProperties.m_174570_((Item)ModItems.ITEM_MAGNET.get(), (ResourceLocation)Spelunkery.res("active"), (stack, world, entity, seed) -> stack.m_41783_() != null && stack.m_41783_().m_128471_("active") ? 0.5f : 0.0f);
        ItemProperties.m_174570_((Item)ModItems.HANDHELD_COMPACTOR.get(), (ResourceLocation)Spelunkery.res("mode"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)HandheldCompactorItem.getMode(stack).ordinal() / 4.0f : 0.0f);
        ItemProperties.m_174570_((Item)ModItems.MAGNETIC_COMPASS.get(), (ResourceLocation)Spelunkery.res("angle"), (ClampedItemPropertyFunction)new MagneticCompassItemPropertyFunction((clientLevel, itemStack, entity) -> MagneticCompassItem.isMagnetiteNearby(itemStack) ? MagneticCompassItem.getMagnetitePos(itemStack.m_41784_()) : MagneticCompassItem.getNorthPosition((Level)clientLevel)));
        ItemProperties.m_174570_((Item)ModItems.TUNING_FORK.get(), (ResourceLocation)Spelunkery.res("angle"), (ClampedItemPropertyFunction)new MagneticCompassItemPropertyFunction((clientLevel, itemStack, entity) -> AmethystTuningForkItem.getAmethystPos(itemStack.m_41784_())));
        ItemProperties.m_174570_((Item)ModItems.SALT_BUCKET.get(), (ResourceLocation)Spelunkery.res("salt"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)stack.m_41783_().m_128451_("salt") / 8.0f : 0.0f);
        ItemProperties.m_174570_((Item)ModItems.PARACHUTE.get(), (ResourceLocation)Spelunkery.res("active"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (stack.m_41783_().m_128471_("active") ? 0.5f : 0.0f) : 0.0f);
        ItemProperties.m_174570_((Item)ModItems.PARACHUTE.get(), (ResourceLocation)Spelunkery.res("used"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (stack.m_41783_().m_128471_("used") ? 0.5f : 0.0f) : 0.0f);
        ItemProperties.m_174570_((Item)ModBlocks.DIAMOND_GRINDSTONE.get().m_5456_(), (ResourceLocation)Spelunkery.res("depletion"), (stack, world, entity, seed) -> stack.m_41783_() != null ? (float)stack.m_41783_().m_128451_("depletion") / 8.0f : 0.0f);
        finishedSetup = true;
    }

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(Spelunkery.res(name), name);
    }

    private static void registerLayers(ClientHelper.ModelLayerEvent event) {
        event.register(DUST_BUNNY, DustBunnyModel::createBodyLayer);
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        event.register(PARACHUTE_3D_MODEL);
    }

    public static void checkIfFailed() {
        if (!finishedSetup) {
            throw new RuntimeException("Failed to run client setup. This is likely due to the mod integration code being outdated, crashing with other mods new versions. Terminating");
        }
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModEntities.FALLING_LAYER.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.DUST_BUNNY.get(), DustBunnyRenderer::new);
        event.register(ModEntities.GLOWSTICK.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.MINEOMITE.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.THROWN_PRIMED_MINEOMITE.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.PRIMED_MINEOMITE.get(), PrimedMineomiteEntityRenderer::new);
        event.register(ModEntities.PEBBLE.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
        event.register(ModEntities.EGGPLANT.get(), context -> new ThrownItemRenderer(context, 1.0f, false));
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)ModParticles.SULFUR.get(), SulfurParticle.Provider::new);
        event.register((ParticleType)ModParticles.SULFUR_DUSTING.get(), SulfurParticle.Provider::new);
        event.register((ParticleType)ModParticles.PORTAL_FLAME.get(), PortalFluidFlameParticle.Provider::new);
        event.register((ParticleType)ModParticles.DUST_POOF.get(), ExplodeParticle.Provider::new);
    }
}

