/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.client.SledSoundInstance;
import net.mehvahdjukaar.snowyspirit.common.entity.ContainerHolderEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.GroundStatus;
import net.mehvahdjukaar.snowyspirit.common.network.NetworkHandler;
import net.mehvahdjukaar.snowyspirit.common.network.ServerBoundUpdateSledState;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SledEntity
extends Entity
implements IControllableVehicle,
IExtraClientSpawnData {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURT_DIR = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> DATA_ID_TYPE = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATA_SEAT_TYPE = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_WOLF_INDEX = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> DATA_ADDITIONAL_Y = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_SYNCED_DX = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_SYNCED_DY = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_SYNCED_DZ = SynchedEntityData.m_135353_(SledEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private float landFriction;
    private GroundStatus groundStatus;
    @Nullable
    private Animal sledPuller = null;
    @Nullable
    private ContainerHolderEntity chest = null;
    public float cachedAdditionalY = 0.0f;
    public double prevAdditionalY = 0.0;
    public Vec3 projectedPos = Vec3.f_82478_;
    public Vec3 prevProjectedPos = Vec3.f_82478_;
    public Vec3 prevDeltaMovement = Vec3.f_82478_;
    public boolean boost = false;
    public double misalignedFrictionFactor = 1.0;
    public Vec3 pullerPos = Vec3.f_82478_;
    public Vec3 prevPullerPos = Vec3.f_82478_;
    public AABB pullerAABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final EntityDimensions pullerDimensions = new EntityDimensions(0.8f, 2.1f, false);
    private final WalkAnimationState internalPullerAnimation = new WalkAnimationState();

    public SledEntity(EntityType<? extends SledEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
        this.m_274367_(1.0f);
    }

    public SledEntity(Level level, double x, double y, double z) {
        this(ModRegistry.SLED.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getWoodType().toString());
        if (this.getSeatType() != null) {
            tag.m_128405_("Seat", this.getSeatType().m_41060_());
        }
        if (this.sledPuller != null) {
            tag.m_128344_("PullerIndex", (byte)this.getPullerIndex());
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setWoodType(WoodTypeRegistry.fromNBT((String)tag.m_128461_("Type")));
        }
        if (tag.m_128425_("Seat", 99)) {
            this.setSeatType(DyeColor.m_41053_((int)tag.m_128451_("Seat")));
        }
        if (tag.m_128441_("PullerIndex")) {
            this.setPullerIndex(tag.m_128445_("PullerIndex"));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.getWoodType().toString());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        if (this.m_9236_().f_46443_) {
            SledSoundInstance.playAt(this);
        }
        this.setWoodType(WoodTypeRegistry.fromNBT((String)additionalData.m_130277_()));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)WoodTypeRegistry.OAK_TYPE.toString());
        this.f_19804_.m_135372_(DATA_SEAT_TYPE, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURT_DIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_WOLF_INDEX, (Object)-1);
        this.f_19804_.m_135372_(DATA_ADDITIONAL_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SYNCED_DX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SYNCED_DY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_SYNCED_DZ, (Object)Float.valueOf(0.0f));
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_7337_(Entity entity) {
        return Boat.m_38323_((Entity)this, (Entity)entity);
    }

    protected Vec3 m_7643_(Direction.Axis axis, BlockUtil.FoundRectangle rectangle) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(axis, rectangle));
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float amount) {
        block7: {
            if (this.m_6673_(source)) {
                return false;
            }
            level = this.m_9236_();
            if (level.f_46443_ || this.m_213877_()) break block7;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            var6_4 = source.m_7639_();
            if (!(var6_4 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var6_4;
            if (player.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = isCreative = false;
            }
            if (isCreative || this.getDamage() > 40.0f) {
                if (!isCreative && level.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19998_((ItemLike)this.getSledItem());
                    seat = this.getSeatType();
                    if (seat != null && (carpet = BlocksColorAPI.getColoredItem((String)"carpet", (DyeColor)seat)) != null) {
                        this.m_19998_((ItemLike)carpet);
                    }
                    if (this.hasPuller()) {
                        this.m_19998_((ItemLike)Items.f_42655_);
                    }
                }
                this.m_146870_();
            }
        }
        return true;
    }

    public void m_6053_(float hitYaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void m_7334_(Entity pEntity) {
        if (pEntity instanceof Boat) {
            if (pEntity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(pEntity);
            }
        } else if (pEntity.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(pEntity);
        }
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 5;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    public float getAdditionalY() {
        return ((Float)this.f_19804_.m_135370_(DATA_ADDITIONAL_Y)).floatValue();
    }

    @Nullable
    public void setDataAdditionalY(float additionalY) {
        this.f_19804_.m_135381_(DATA_ADDITIONAL_Y, (Object)Float.valueOf(additionalY));
    }

    public Vec3 getSyncedMovement() {
        return new Vec3((double)((Float)this.f_19804_.m_135370_(DATA_SYNCED_DX)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_SYNCED_DY)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_SYNCED_DZ)).floatValue());
    }

    public void setSyncedMovement(Vec3 deltaMovement) {
        this.setSyncedMovement((float)deltaMovement.f_82479_, (float)deltaMovement.f_82480_, (float)deltaMovement.f_82481_);
    }

    public void setSyncedMovement(float dx, float dy, float dz) {
        this.f_19804_.m_135381_(DATA_SYNCED_DX, (Object)Float.valueOf(dx));
        this.f_19804_.m_135381_(DATA_SYNCED_DY, (Object)Float.valueOf(dy));
        this.f_19804_.m_135381_(DATA_SYNCED_DZ, (Object)Float.valueOf(dz));
    }

    private AABB resetPullerAABB() {
        return this.pullerDimensions.m_20393_(this.m_20182_());
    }

    public void m_6478_(MoverType pType, Vec3 wantedPosIncrement) {
        boolean isMoving = wantedPosIncrement != Vec3.f_82478_;
        this.prevProjectedPos = this.projectedPos;
        this.projectedPos = Vec3.f_82478_;
        if (!this.m_20096_() && isMoving) {
            float belowCheck = -1.25f;
            Vec3 blockBelow = this.calculateSlopePosition(new Vec3(0.0, (double)belowCheck, 0.0), this.m_20191_(), this::m_142242_, -1.0f);
            if (blockBelow.f_82480_ > (double)belowCheck + 0.01) {
                this.m_6853_(true);
            }
        }
        if (this.m_20096_()) {
            this.projectedPos = !isMoving ? Vec3.f_82478_ : this.calculateSlopePosition(this.m_20184_().m_82490_(6.0), this.m_20191_(), this::m_142242_, -1.0f);
            double y = Mth.m_14008_((double)this.projectedPos.f_82480_, (double)-1.0, (double)1.0);
            if (y == 0.0) {
                this.m_146926_(this.m_146909_() + -this.m_146909_() * 0.3f);
            } else if (y > 0.0) {
                this.m_146926_((float)Math.max((double)(this.m_146909_() - 6.0f), -30.0 * y));
            } else {
                this.m_146926_((float)Math.min((double)(this.m_146909_() + 3.0f), -30.0 * y));
            }
        }
        float localAdditionalY = this.getAdditionalY();
        this.prevAdditionalY = localAdditionalY;
        if (this.projectedPos.f_82480_ > 0.0) {
            double slopeIncrement = (this.projectedPos.f_82480_ + 0.01) / 2.5;
            localAdditionalY = (float)Math.min(this.projectedPos.f_82480_, (double)localAdditionalY + slopeIncrement);
        } else {
            localAdditionalY = 0.0f;
        }
        float snowLayerHeight = 0.0625f;
        if (this.groundStatus == GroundStatus.ON_SNOW_LAYER && (double)localAdditionalY < 0.0625) {
            localAdditionalY += 0.0625f;
        }
        this.setDataAdditionalY(localAdditionalY);
        this.cachedAdditionalY = localAdditionalY;
        Vec3 oldPos = this.m_20182_();
        super.m_6478_(pType, wantedPosIncrement);
        if (this.cachedAdditionalY > 0.0f && oldPos.f_82480_ < this.m_20186_()) {
            float newHeight = this.groundStatus == GroundStatus.ON_SNOW_LAYER ? 0.0625f : 0.0f;
            this.setDataAdditionalY(newHeight);
            this.cachedAdditionalY = newHeight;
            this.m_20011_(this.m_142242_());
        }
        this.prevPullerPos = this.pullerPos;
        if (this.hasPuller()) {
            this.pullerAABB = this.pullerDimensions.m_20393_(this.m_20182_().m_82520_(0.0, 0.0, 0.0));
            Vec3 wantedPullerPos = this.calculateSlopePosition(wantedPosIncrement.m_82549_(this.m_20154_().m_82490_(2.0)), this.pullerAABB, this::resetPullerAABB, -1.25f);
            double pxInc = Mth.m_14008_((double)(wantedPullerPos.f_82479_ - this.prevPullerPos.f_82479_), (double)-0.75, (double)0.75);
            double pyInc = wantedPullerPos.f_82480_ < 0.0 && wantedPullerPos.f_82480_ < this.prevPullerPos.f_82480_ ? Mth.m_14008_((double)(wantedPullerPos.f_82480_ - this.prevPullerPos.f_82480_), (double)-0.15, (double)1.0) : wantedPullerPos.f_82480_ - this.prevPullerPos.f_82480_;
            double pzInc = Mth.m_14008_((double)(wantedPullerPos.f_82481_ - this.prevPullerPos.f_82481_), (double)-0.75, (double)0.75);
            this.pullerPos = this.prevPullerPos.m_82520_(pxInc, pyInc, pzInc);
            this.pullerAABB = this.pullerDimensions.m_20393_(this.m_20182_().m_82549_(this.pullerPos));
        }
    }

    public void m_8119_() {
        boolean controlledByLocalInstance;
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.boost && this.getSyncedMovement().m_82556_() > 0.09) {
            for (Entity p : this.m_20197_()) {
                if (!(p instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)p;
                SnowySpirit.giveAdvancement(sp, "adventure/ride_sled_fast");
            }
        }
        if (this.chest != null && this.chest.m_213877_()) {
            this.chest = null;
        }
        this.updatePuller();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        Pair<GroundStatus, Float> newStatus = GroundStatus.computeFriction(this);
        this.groundStatus = (GroundStatus)((Object)newStatus.getFirst());
        this.landFriction = ((Float)newStatus.getSecond()).floatValue();
        this.prevDeltaMovement = this.m_20184_();
        super.m_8119_();
        this.tickLerp();
        Vec3 movement = this.m_20184_();
        this.boost = false;
        if (this.projectedPos.f_82480_ != 0.0 && this.m_20096_()) {
            double k = Mth.m_14008_((double)this.projectedPos.f_82480_, (double)-1.0, (double)1.0);
            if (k > 0.0) {
                if (!this.hasPuller()) {
                    this.m_20256_(movement.m_82490_(1.0 + -0.06 * k));
                }
            } else {
                this.boost = true;
                this.m_20256_(movement.m_82549_(movement.m_82541_().m_82490_(k * (double)-0.01f)).m_82520_(0.0, -0.2, 0.0));
            }
        }
        if (controlledByLocalInstance = this.m_6109_()) {
            this.applyFriction();
            if (level.f_46443_) {
                this.controlSled();
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20101_();
        List list = level.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.15f, (double)0.01f, (double)0.15f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean notLocalPlayerControlled = !level.f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                if (notLocalPlayerControlled && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player) && (this.hasPuller() && this.m_7310_(entity) || this.m_20197_().size() < 2)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
        if (level.f_46443_) {
            if (controlledByLocalInstance) {
                movement = this.m_20184_();
                double horizontalSpeed = movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_;
                if (horizontalSpeed > 0.001) {
                    this.setSyncedMovement(movement);
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundUpdateSledState(movement));
                    this.spawnTrailParticles(movement, horizontalSpeed);
                }
            } else {
                movement = this.getSyncedMovement();
                double horizontalSpeed = movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_;
                if (horizontalSpeed > 0.001) {
                    this.spawnTrailParticles(movement, horizontalSpeed);
                }
            }
        } else if (!controlledByLocalInstance && this.getSyncedMovement() != Vec3.f_82478_) {
            this.setSyncedMovement(Vec3.f_82478_);
        }
    }

    protected void m_20101_() {
        AABB aabb = this.m_20191_();
        BlockPos blockpos = BlockPos.m_274561_((double)(aabb.f_82288_ + 0.001), (double)(aabb.f_82289_ + 0.001), (double)(aabb.f_82290_ + 0.001));
        BlockPos blockpos1 = BlockPos.m_274561_((double)(aabb.f_82291_ - 0.001), (double)(aabb.f_82292_ - 0.001), (double)(aabb.f_82293_ - 0.001));
        Level level = this.m_9236_();
        if (level.m_46832_(blockpos, blockpos1)) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
                for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                    for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                        blockPos.m_122178_(i, j, k);
                        BlockState blockstate = level.m_8055_((BlockPos)blockPos);
                        if (blockstate.m_60734_() instanceof PowderSnowBlock) continue;
                        try {
                            blockstate.m_60682_(level, (BlockPos)blockPos, (Entity)this);
                            this.m_6763_(blockstate);
                            continue;
                        }
                        catch (Exception throwable) {
                            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being collided with");
                            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)blockPos, (BlockState)blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    private void spawnTrailParticles(Vec3 movement, double horizontalSpeed) {
        if (this.groundStatus.onSnow() && this.m_20096_()) {
            float xRot = this.m_146909_();
            float yRot = this.m_146908_();
            Vec3 left = null;
            Vec3 right = null;
            Level level = this.m_9236_();
            if ((double)(this.f_19796_.m_188501_() * 0.16f) < horizontalSpeed) {
                float up = (float)Math.min(horizontalSpeed * 0.6, 0.3);
                Vec3 a = this.m_20171_(xRot, yRot + 24.0f);
                Vec3 b = this.m_20171_(xRot, yRot - 24.0f);
                left = a.m_82490_(-1.0).m_82549_(this.m_20182_());
                right = b.m_82490_(-1.0).m_82549_(this.m_20182_());
                this.spawnSnowFlakeParticle(level, left, (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083, 0.015 + (double)(this.f_19796_.m_188501_() * 0.1f) + (double)up, (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083);
                this.spawnSnowFlakeParticle(level, right, (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083, 0.015 + (double)(this.f_19796_.m_188501_() * 0.1f) + (double)up, (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083);
            }
            if ((double)Math.abs(xRot) < 0.01) {
                Vec3 v = new Vec3(0.0, 0.0, 1.0);
                v = v.m_82524_((float)((double)(-yRot / 180.0f) * Math.PI));
                double cross = v.m_82537_((Vec3)new Vec3((double)movement.f_82479_, (double)0.0, (double)movement.f_82481_).m_82541_()).f_82480_;
                for (int j = 0; j < 2; ++j) {
                    Vec3 p;
                    if (!((double)this.f_19796_.m_188501_() < cross * cross - 0.1)) continue;
                    Vec3 forward = this.m_20171_(xRot, yRot);
                    float up = (float)Math.min(horizontalSpeed * 0.6, 0.3);
                    if (cross > 0.0) {
                        if (left != null) continue;
                        Vec3 a = this.m_20171_(xRot, yRot + 24.0f);
                        left = a.m_82490_(-1.0).m_82549_(this.m_20182_());
                        p = left.m_82549_(forward.m_82490_((double)(this.f_19796_.m_188501_() * 1.85f)));
                        this.spawnSnowFlakeParticle(level, p, movement.f_82479_ * 0.75 + forward.f_82479_ * 0.25, movement.f_82480_ + 0.017 + (double)up, movement.f_82481_ * 0.75 + forward.f_82481_ * 0.25);
                        continue;
                    }
                    if (right != null) continue;
                    Vec3 b = this.m_20171_(xRot, yRot - 24.0f);
                    right = b.m_82490_(-1.0).m_82549_(this.m_20182_());
                    p = right.m_82549_(forward.m_82490_((double)(this.f_19796_.m_188501_() * 1.85f)));
                    this.spawnSnowFlakeParticle(level, p, movement.f_82479_ * 0.75 + forward.f_82479_ * 0.25, movement.f_82480_ + 0.017 + (double)up, movement.f_82481_ * 0.75 + forward.f_82481_ * 0.25);
                }
            }
        }
    }

    public void spawnSnowFlakeParticle(Level level, Vec3 pos, double dx, double dy, double dz) {
        RandomSource random = level.f_46441_;
        level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, pos.f_82479_ + (double)Mth.m_216283_((RandomSource)random, (float)-0.125f, (float)0.125f), pos.f_82480_ + 0.2, pos.f_82481_ + (double)Mth.m_216283_((RandomSource)random, (float)-0.125f, (float)0.125f), dx, dy, dz);
    }

    public boolean m_5843_() {
        return !this.groundStatus.onSnow() && super.m_5843_();
    }

    @NotNull
    protected AABB m_142242_() {
        float additionalY = this.getAdditionalY();
        if (additionalY > 0.0f) {
            return super.m_142242_().m_82363_(0.0, (double)additionalY, 0.0);
        }
        return super.m_142242_();
    }

    public Vec3 m_20272_(Vec3 pVec) {
        double lengthSqr;
        Vec3 vec3;
        Level level;
        ArrayList<VoxelShape> list;
        AABB aabb = this.m_20191_();
        Vec3 vec31 = this.maybeClimbUp(pVec, aabb, list = new ArrayList<VoxelShape>((level = this.m_9236_()).m_183134_((Entity)this, aabb.m_82369_(pVec))), vec3 = (lengthSqr = pVec.m_82556_()) == 0.0 ? pVec : SledEntity.m_198894_((Entity)this, (Vec3)pVec, (AABB)aabb, (Level)level, list));
        if (vec31 != null) {
            return vec31;
        }
        return vec3;
    }

    @Nullable
    private Vec3 maybeClimbUp(Vec3 originalMot, AABB aabb, List<VoxelShape> voxelShapes, Vec3 horizonalMot) {
        boolean restrictedX = originalMot.f_82479_ != horizonalMot.f_82479_;
        boolean restrictedY = originalMot.f_82480_ != horizonalMot.f_82480_;
        boolean restrictedZ = originalMot.f_82481_ != horizonalMot.f_82481_;
        boolean onGround = this.m_20096_() || restrictedY && originalMot.f_82480_ < 0.0;
        float maxUpStep = this.m_274421_();
        if (maxUpStep > 0.0f && onGround && (restrictedX || restrictedZ)) {
            Vec3 vec33;
            Level level = this.m_9236_();
            Vec3 vec31 = SledEntity.m_198894_((Entity)this, (Vec3)new Vec3(originalMot.f_82479_, (double)maxUpStep, originalMot.f_82481_), (AABB)aabb, (Level)level, voxelShapes);
            Vec3 vec32 = SledEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)maxUpStep, 0.0), (AABB)aabb.m_82363_(originalMot.f_82479_, 0.0, originalMot.f_82481_), (Level)level, voxelShapes);
            if (vec32.f_82480_ < (double)maxUpStep && (vec33 = SledEntity.m_198894_((Entity)this, (Vec3)new Vec3(originalMot.f_82479_, 0.0, originalMot.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)level, voxelShapes).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > horizonalMot.m_165925_()) {
                return vec31.m_82549_(SledEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec31.f_82480_ + originalMot.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)level, voxelShapes));
            }
        }
        return null;
    }

    private Vec3 calculateSlopePosition(Vec3 pVec, AABB aabb, Supplier<AABB> aabbResetter, float maxDownStep) {
        Vec3 vec3;
        Level level = this.m_9236_();
        List list = level.m_183134_((Entity)this, aabb.m_82369_(pVec));
        Vec3 vec31 = this.maybeClimbUp(pVec, aabb, list, vec3 = pVec.m_82556_() == 0.0 ? pVec : SledEntity.m_198894_((Entity)this, (Vec3)pVec, (AABB)aabb, (Level)level, (List)list));
        if (vec31 != null) {
            return vec31;
        }
        Vec3 cached = this.m_20182_();
        Vec3 newPos = cached.m_82549_(vec3);
        this.m_20343_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        AABB aa = aabbResetter.get();
        this.m_20011_(aa);
        Vec3 down = SledEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)maxDownStep, 0.0), (AABB)aa, (Level)level, (List)list);
        this.m_146884_(cached);
        return vec3.m_82549_(down);
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public GroundStatus getCurrentStatus() {
        return this.groundStatus;
    }

    private void applyFriction() {
        double gravity = this.m_20068_() ? 0.0 : (double)-0.04f;
        float invFriction = 0.05f;
        switch (this.groundStatus) {
            case IN_AIR: {
                invFriction = 0.9f;
                break;
            }
            case IN_WATER: {
                invFriction = 0.45f;
                break;
            }
            case ON_SNOW: 
            case ON_SNOW_LAYER: 
            case ON_LAND: {
                invFriction = this.landFriction;
                if (!(this.m_6688_() instanceof Player)) break;
                this.landFriction /= 2.0f;
            }
        }
        Vec3 movement = this.m_20184_();
        if (this.groundStatus.touchingGround()) {
            double inc = 0.825;
            if (this.inputUp || this.inputDown || movement.m_82556_() > 0.001) {
                Vec3 v = new Vec3(0.0, 0.0, 1.0);
                v = v.m_82524_((float)((double)(-this.m_146908_() / 180.0f) * Math.PI));
                double dot = v.m_82526_(new Vec3(movement.f_82479_, 0.0, movement.f_82481_).m_82541_());
                inc = Mth.m_14008_((double)((dot + 3.0) / 4.0 + 0.005), (double)inc, (double)1.0);
            }
            this.misalignedFrictionFactor = inc * 4.0 - 3.0;
            invFriction = (float)((double)invFriction * inc);
        }
        this.m_20334_(movement.f_82479_ * (double)invFriction, movement.f_82480_ + gravity, movement.f_82481_ * (double)invFriction);
        this.deltaRotation = (float)((double)this.deltaRotation * Math.min((double)invFriction, this.inputUp ? CommonConfigs.ROTATION_FRICTION_ON_W.get() : CommonConfigs.ROTATION_FRICTION.get()));
    }

    private void controlSled() {
        if (this.m_20160_()) {
            double dot;
            Vec3 v;
            float powah = 0.0f;
            Vec3 movement = this.m_20184_();
            boolean canSteer = (!this.inputRight || !this.inputLeft) && this.inputUp;
            boolean hasWolf = this.hasPuller();
            double steerFactor = hasWolf ? CommonConfigs.STEER_FACTOR_WOLF.get() : CommonConfigs.STEER_FACTOR.get();
            if (this.inputLeft) {
                this.deltaRotation -= 1.0f;
                if (this.groundStatus.touchingGround() && canSteer) {
                    v = new Vec3(0.0, 0.0, 1.0);
                    dot = (v = v.m_82524_((float)((double)(-this.m_146908_() / 180.0f) * Math.PI))).m_82526_(movement.m_82541_());
                    if (dot > 0.0) {
                        this.m_20256_(movement.m_82524_((float)(dot * steerFactor)));
                    }
                }
            }
            if (this.inputRight) {
                this.deltaRotation += 1.0f;
                if (this.groundStatus.touchingGround() && canSteer) {
                    v = new Vec3(0.0, 0.0, 1.0);
                    dot = (v = v.m_82524_((float)((double)(-this.m_146908_() / 180.0f) * Math.PI))).m_82526_(movement.m_82541_());
                    if (dot > 0.8) {
                        this.m_20256_(movement.m_82524_((float)(-dot * steerFactor)));
                    }
                }
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                powah = (float)((double)powah + CommonConfigs.SIDE_ACCELERATION.get());
            }
            this.m_146922_(this.m_146908_() + this.deltaRotation);
            if (this.inputUp) {
                if (this.groundStatus.onSnow()) {
                    double acceleration = hasWolf ? CommonConfigs.FORWARD_ACCELERATION_WOLF.get() : CommonConfigs.FORWARD_ACCELERATION.get();
                    powah = (float)((double)powah + acceleration);
                } else {
                    powah = (float)((double)powah + CommonConfigs.FORWARD_ACCELERATION_WHEN_NOT_ON_SNOW.get());
                }
            }
            if (this.inputDown) {
                powah = (float)((double)powah - CommonConfigs.BACKWARDS_ACCELERATION.get());
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * powah), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * powah)));
        }
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        Level level = this.m_9236_();
        if (level.f_46443_ && (double)this.f_19789_ > 0.5 && this.m_20096_() && this.groundStatus.onSnow()) {
            float p = Mth.m_14036_((float)(this.f_19789_ * 4.0f), (float)5.0f, (float)20.0f);
            Vec3 front = this.m_20182_().m_82549_(this.m_20154_().m_82490_((double)0.8f));
            Vec3 mov = this.m_20184_().m_82490_(1.1);
            float ySpeed = (float)(mov.m_82556_() * 0.06 + (double)(this.f_19789_ * 0.005f));
            int i = 0;
            while ((float)i < p) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, front.f_82479_ + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.6f, (float)0.6f), front.f_82480_ + 0.2 + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.1f, (float)0.2f), front.f_82481_ + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.6f, (float)0.6f), mov.f_82479_ + (double)(Mth.m_216283_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083333336f), 0.1 + (double)(this.f_19796_.m_188501_() * ySpeed), mov.f_82481_ + (double)(Mth.m_216283_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.083333336f));
                ++i;
            }
        }
        if (pOnGround) {
            if (this.f_19789_ > 0.0f) {
                // empty if block
            }
            this.m_183634_();
        } else if (pY < 0.0) {
            this.f_19789_ = (float)((double)this.f_19789_ - pY);
        }
    }

    public void setDamage(float v) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(v));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setPullerIndex(int i) {
        this.f_19804_.m_135381_(DATA_WOLF_INDEX, (Object)((byte)i));
    }

    public int getPullerIndex() {
        return ((Byte)this.f_19804_.m_135370_(DATA_WOLF_INDEX)).byteValue();
    }

    public void setHurtDir(int i) {
        this.f_19804_.m_135381_(DATA_ID_HURT_DIR, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT_DIR);
    }

    public void setWoodType(WoodType type) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)type.toString());
    }

    public WoodType getWoodType() {
        return WoodTypeRegistry.fromNBT((String)((String)this.f_19804_.m_135370_(DATA_ID_TYPE)));
    }

    @Nullable
    public DyeColor getSeatType() {
        int d = (Integer)this.f_19804_.m_135370_(DATA_SEAT_TYPE);
        if (d == 0) {
            return null;
        }
        return DyeColor.m_41053_((int)(d - 1));
    }

    @Nullable
    public void setSeatType(@Nullable DyeColor seatColor) {
        this.f_19804_.m_135381_(DATA_SEAT_TYPE, (Object)(seatColor == null ? 0 : seatColor.m_41060_() + 1));
    }

    public double m_6048_() {
        return 0.2 + (double)this.getAdditionalY() + (this.getSeatType() != null ? 0.0615 : 0.0);
    }

    @Nullable
    public ContainerHolderEntity tryAddingChest(ItemStack stack) {
        if (ContainerHolderEntity.isValidContainer(stack) && this.canAddChest()) {
            Level level = this.m_9236_();
            stack = stack.m_41620_(1);
            ContainerHolderEntity container = new ContainerHolderEntity(level, this, stack);
            level.m_7967_((Entity)container);
            Block b = ((BlockItem)stack.m_41720_()).m_40614_();
            this.m_216990_(b.m_49962_(b.m_49966_()).m_56777_());
            return container;
        }
        return null;
    }

    public InteractionResult m_6096_(Player player, InteractionHand pHand) {
        if (!player.m_36341_()) {
            ItemStack stack = player.m_21120_(pHand);
            Level level = player.m_9236_();
            if (stack.m_204117_(ItemTags.f_215867_) && this.getSeatType() == null) {
                DyeColor col = BlocksColorAPI.getColor((Item)stack.m_41720_());
                if (col != null) {
                    this.m_5496_(SoundEvents.f_11678_, 0.5f, 1.0f);
                    this.setSeatType(col);
                    stack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (this.tryAddingChest(stack) != null) {
                if (this.sledPuller != null && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    SnowySpirit.giveAdvancement(sp, "adventure/sled_with_wolf");
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!this.hasPuller()) {
                double radius = 7.0;
                double x = player.m_20185_();
                double y = player.m_20186_();
                double z = player.m_20189_();
                Mob found = null;
                for (Mob mob : level.m_45976_(Mob.class, new AABB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius))) {
                    if (mob.m_21524_() != player) continue;
                    found = mob;
                    break;
                }
                if (found != null) {
                    Fox fox;
                    TamableAnimal ta;
                    boolean owned;
                    boolean bl = owned = found instanceof TamableAnimal && (ta = (TamableAnimal)found).m_269323_() == player || found instanceof Fox && (fox = (Fox)found).m_28529_(player.m_20148_());
                    if (owned && this.tryConnectingPuller((Entity)found)) {
                        this.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
                        if (this.chest != null && player instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)player;
                            SnowySpirit.giveAdvancement(sp, "adventure/sled_with_wolf");
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    return InteractionResult.FAIL;
                }
            }
            if (!level.f_46443_) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean m_7310_(Entity entity) {
        if (this.m_204029_(FluidTags.f_13131_)) {
            return false;
        }
        int maxAllowed = this.getMaxPassengersSize();
        if (this.m_20197_().size() >= maxAllowed) {
            return false;
        }
        return !this.hasChest() || !(entity instanceof ContainerHolderEntity);
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity le;
        Entity v = this.m_146895_();
        return v instanceof LivingEntity ? (le = (LivingEntity)v) : null;
    }

    public void onInputUpdate(boolean left, boolean right, boolean up, boolean down, boolean sprint, boolean jumping) {
        this.inputLeft = left;
        this.inputRight = right;
        this.inputUp = up;
        this.inputDown = down;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
        this.updatePullerIndex();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        int ind;
        super.m_7350_(key);
        if (this.m_9236_().f_46443_ && DATA_WOLF_INDEX.equals(key) && (ind = this.getPullerIndex()) != -1 && this.m_20197_().size() > ind) {
            Entity wolf = (Entity)this.m_20197_().get(ind);
            this.tryConnectingPuller(wolf);
        }
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction setPos) {
        if (this.m_20363_(passenger)) {
            if (this.chest == null && passenger instanceof ContainerHolderEntity) {
                ContainerHolderEntity container;
                this.chest = container = (ContainerHolderEntity)passenger;
            }
            if (this.isMyPuller(passenger)) {
                Animal animal = (Animal)passenger;
                passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
                this.clampRotation(passenger);
                passenger.m_5618_(animal.f_20883_ + this.deltaRotation * 10.0f);
                passenger.m_5616_(animal.f_20883_);
                setPos.m_20372_(passenger, this.m_20185_() + this.pullerPos.f_82479_, this.m_20186_() + this.pullerPos.f_82480_, this.m_20189_() + this.pullerPos.f_82481_);
                this.updatePullerAnimations();
            } else {
                float zPos = 0.0f;
                float yPos = (float)((this.m_213877_() ? 0.01 : this.m_6048_()) + passenger.m_6049_());
                boolean isMoreThanOneOnBoard = false;
                if (this.isChestEntity(passenger)) {
                    passenger.f_19860_ = this.f_19860_;
                    passenger.m_146926_(this.m_146909_());
                    passenger.f_19859_ = this.f_19859_;
                    passenger.m_146922_(this.m_146908_());
                    zPos = -0.4f;
                    yPos = (float)((double)yPos + 0.3);
                    float cos = Mth.m_14031_((float)((float)((double)this.m_146909_() * Math.PI / 180.0)));
                    yPos -= cos * zPos;
                } else {
                    boolean bl = isMoreThanOneOnBoard = this.m_20197_().size() > this.getMaxPassengersSize() - 1;
                    if (isMoreThanOneOnBoard) {
                        Entity p;
                        int i = 0;
                        Iterator iterator = this.m_20197_().iterator();
                        while (iterator.hasNext() && (p = (Entity)iterator.next()) != passenger) {
                            if (this.isMyPuller(p) || this.isChestEntity(p)) continue;
                            ++i;
                        }
                        float cos = Mth.m_14031_((float)((float)((double)this.m_146909_() * Math.PI / 180.0)));
                        zPos = i == 0 ? 0.1f : -0.8f;
                        yPos -= cos * zPos;
                    }
                    if (passenger instanceof Animal) {
                        if (isMoreThanOneOnBoard) {
                            zPos = (float)((double)zPos + 0.2);
                        }
                        yPos = (float)((double)yPos + 0.125);
                    }
                    passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
                    passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
                    this.clampRotation(passenger);
                }
                Vec3 vec3 = new Vec3((double)zPos, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
                setPos.m_20372_(passenger, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)yPos, this.m_20189_() + vec3.f_82481_);
                if (passenger instanceof Animal) {
                    Animal animal = (Animal)passenger;
                    if (isMoreThanOneOnBoard) {
                        int yRot = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                        passenger.m_5618_(animal.f_20883_ + (float)yRot);
                        passenger.m_5616_(passenger.m_6080_() + (float)yRot);
                    }
                }
            }
        }
    }

    public void m_142098_(double pX, double pY, double pZ) {
        this.setDataAdditionalY(0.0f);
        this.projectedPos = Vec3.f_82478_;
        super.m_142098_(pX, pY, pZ);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        Vec3 vec3 = SledEntity.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)entity.m_20205_(), (float)entity.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)this.m_20191_().f_82292_, (double)d1);
        BlockPos below = blockpos.m_7495_();
        Level level = this.m_9236_();
        if (!level.m_46801_(below)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = level.m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = level.m_45573_(below)))) {
                list.add(new Vec3(d0, (double)below.m_123342_() + d3, d1));
            }
            for (Pose pose : entity.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)level, (Vec3)vec31, (LivingEntity)entity, (Pose)pose)) continue;
                    entity.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(entity);
    }

    public void m_20153_() {
        if (this.sledPuller != null) {
            this.disconnectPuller();
        }
        this.chest = null;
        super.m_20153_();
    }

    protected void m_20351_(Entity pPassenger) {
        if (this.sledPuller == pPassenger) {
            this.disconnectPuller();
        }
        if (this.chest == pPassenger) {
            this.chest = null;
        }
        super.m_20351_(pPassenger);
        this.updatePullerIndex();
    }

    public void m_7340_(Entity entity) {
        this.clampRotation(entity);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getSledItem());
    }

    public Item getSledItem() {
        return (Item)ModRegistry.SLED_ITEMS.get(this.getWoodType());
    }

    public boolean isComfy() {
        return true;
    }

    public boolean isChestEntity(Entity entity) {
        return entity == this.chest;
    }

    public boolean hasChest() {
        return this.chest != null;
    }

    public boolean hasPuller() {
        return this.sledPuller != null;
    }

    public boolean isMyPuller(Entity entity) {
        return entity == this.sledPuller;
    }

    @Nullable
    public Animal getSledPuller() {
        return this.sledPuller;
    }

    public boolean tryConnectingPuller(Entity entity) {
        if (entity instanceof Animal) {
            Animal wolf = (Animal)entity;
            if (entity.m_9236_().f_46443_) {
                this.sledPuller = wolf;
                return true;
            }
            if (entity.m_6095_().m_204039_(ModTags.WOLVES) && (double)entity.m_20205_() < CommonConfigs.MAX_SLED_PULLER_SIZE.get()) {
                wolf.m_21455_(true, false);
                if (wolf.m_20329_((Entity)this) && this.m_20363_((Entity)wolf)) {
                    this.setPullerIndex((byte)this.m_20197_().indexOf(wolf));
                    this.sledPuller = wolf;
                    return true;
                }
                wolf.m_19998_((ItemLike)Items.f_42655_);
                return false;
            }
        }
        return false;
    }

    public void updatePuller() {
        Entity wolf;
        int ind = this.getPullerIndex();
        if (this.sledPuller != null) {
            Entity wolf2;
            if (this.sledPuller.m_213877_()) {
                this.sledPuller = null;
                this.setPullerIndex(-1);
                return;
            }
            if (ind == -1) {
                this.sledPuller = null;
                return;
            }
            this.sledPuller.m_20331_(true);
            if (this.m_20197_().size() > ind && (wolf2 = (Entity)this.m_20197_().get(ind)) != this.sledPuller) {
                this.sledPuller = null;
                this.setPullerIndex(-1);
            }
        } else if (ind >= 0 && this.m_20197_().size() > ind && (wolf = (Entity)this.m_20197_().get(ind)) instanceof Animal) {
            Animal a;
            this.sledPuller = a = (Animal)wolf;
        }
    }

    public void disconnectPuller() {
        if (this.sledPuller != null && !this.m_9236_().f_46443_) {
            this.setPullerIndex(-1);
            Animal animal = this.sledPuller;
            if (animal instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)animal;
                tamableAnimal.m_21837_(false);
            } else {
                animal = this.sledPuller;
                if (animal instanceof Fox) {
                    Fox fox = (Fox)animal;
                    fox.m_28610_(false);
                }
            }
            this.sledPuller.m_20331_(false);
            this.sledPuller = null;
        }
    }

    protected void updatePullerIndex() {
        for (Entity p : this.m_20197_()) {
            if (p != this.sledPuller) continue;
            this.setPullerIndex(this.m_20197_().indexOf(p));
        }
    }

    protected void updatePullerAnimations() {
        if (this.sledPuller != null) {
            double travelZ;
            double travelY;
            double travelX = this.sledPuller.m_20185_() - this.sledPuller.f_19854_;
            float speed = (float)Mth.m_184648_((double)travelX, (double)(travelY = 0.0), (double)(travelZ = this.sledPuller.m_20189_() - this.sledPuller.f_19856_)) * 4.0f;
            if (speed > 1.0f) {
                speed = 1.0f;
            }
            this.internalPullerAnimation.m_267566_(speed, 0.4f);
            this.sledPuller.f_267362_.m_267771_(this.internalPullerAnimation.m_267731_());
            this.sledPuller.f_267362_.f_267358_ = this.internalPullerAnimation.f_267358_;
            this.sledPuller.f_267362_.f_267406_ = this.internalPullerAnimation.f_267406_;
            Vec3 m = this.m_6109_() ? this.m_20184_() : this.getSyncedMovement();
            boolean sit = m.m_82556_() < 1.0E-5;
            Animal animal = this.sledPuller;
            if (animal instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)animal;
                if (tamableAnimal.m_21825_() != sit) {
                    tamableAnimal.m_21837_(sit);
                }
            } else {
                Fox fox;
                animal = this.sledPuller;
                if (animal instanceof Fox && (fox = (Fox)animal).m_28555_() != sit) {
                    fox.m_28610_(sit);
                }
            }
        }
    }

    private boolean canAddChest() {
        return this.m_20197_().size() < this.getMaxPassengersSize() && !this.hasChest();
    }

    private int getMaxPassengersSize() {
        return this.hasPuller() ? 3 : 2;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (pState.m_204336_(ModTags.SLED_SNOW) || pState.m_60734_() instanceof SnowLayerBlock) {
            return;
        }
        super.m_7601_(pState, pMotionMultiplier);
    }
}

