/*
 * Decompiled with CFR 0.152.
 */
package net.xanthian.variantvanillablocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Locale;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.xanthian.variantvanillablocks.block.custom.VariantChestBlock;
import net.xanthian.variantvanillablocks.block.custom.VariantChests;
import net.xanthian.variantvanillablocks.entity.VariantChestBlockEntity;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class VariantChestRenderer<T extends VariantChestBlockEntity>
extends ChestRenderer<T> {
    public static Material[] single = new Material[VariantChests.values().length];
    public static Material[] left = new Material[VariantChests.values().length];
    public static Material[] right = new Material[VariantChests.values().length];
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;

    public VariantChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        ModelPart modelPart = context.m_173582_(ModelLayers.f_171275_);
        this.lid = modelPart.m_171324_("lid");
        this.bottom = modelPart.m_171324_("bottom");
        this.lock = modelPart.m_171324_("lock");
        ModelPart modelPart2 = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftLid = modelPart2.m_171324_("lid");
        this.doubleLeftBottom = modelPart2.m_171324_("bottom");
        this.doubleLeftLock = modelPart2.m_171324_("lock");
        ModelPart modelPart3 = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightLid = modelPart3.m_171324_("lid");
        this.doubleRightBottom = modelPart3.m_171324_("bottom");
        this.doubleRightLock = modelPart3.m_171324_("lock");
    }

    public static Material getChestID(String path) {
        return new Material(Sheets.f_110740_, new ResourceLocation("variantvanillablocks", "entity/chest/" + path)){};
    }

    public static Material chooseMaterial(ChestType type, Material left, Material right, Material single) {
        return switch (type) {
            case ChestType.LEFT -> left;
            case ChestType.RIGHT -> right;
            default -> single;
        };
    }

    private Material getChestTexture(VariantChestBlockEntity tile, ChestType type) {
        return VariantChestRenderer.chooseMaterial(type, left[tile.getChestType().ordinal()], right[tile.getChestType().ordinal()], single[tile.getChestType().ordinal()]);
    }

    public void render(T pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.m_58904_();
        BlockState blockState = level != null ? pBlockEntity.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockState.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockState.m_60734_();
        if (block instanceof VariantChestBlock) {
            boolean bl2 = chestType != ChestType.SINGLE;
            pPoseStack.m_85836_();
            float f = ((Direction)blockState.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            pPoseStack.m_252880_(0.5f, 0.5f, 0.5f);
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            pPoseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = level == null ? DoubleBlockCombiner.Combiner::m_6502_ : ((VariantChestBlock)block).m_5641_(blockState, level, pBlockEntity.m_58899_(), true);
            float g = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_(pBlockEntity))).get(pPartialTick);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(pPackedLight);
            Material material = this.getChestTexture((VariantChestBlockEntity)((Object)pBlockEntity), chestType);
            VertexConsumer vertexconsumer = material.m_119194_(pBuffer, RenderType::m_110452_);
            if (bl2) {
                if (chestType == ChestType.LEFT) {
                    this.m_112369_(pPoseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, g, i, pPackedOverlay);
                } else {
                    this.m_112369_(pPoseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, g, i, pPackedOverlay);
                }
            } else {
                this.m_112369_(pPoseStack, vertexconsumer, this.lid, this.lock, this.bottom, g, i, pPackedOverlay);
            }
            pPoseStack.m_85849_();
        }
    }

    private void m_112369_(PoseStack pPoseStack, VertexConsumer pConsumer, ModelPart pLidPart, ModelPart pLockPart, ModelPart pBottomPart, float pLidAngle, int pPackedLight, int pPackedOverlay) {
        pLockPart.f_104203_ = pLidPart.f_104203_ = -(pLidAngle * 1.5707964f);
        pLidPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pLockPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
        pBottomPart.m_104301_(pPoseStack, pConsumer, pPackedLight, pPackedOverlay);
    }

    static {
        for (VariantChests type : VariantChests.values()) {
            int ordinal = type.ordinal();
            String name = type.name().toLowerCase(Locale.ROOT);
            VariantChestRenderer.single[ordinal] = VariantChestRenderer.getChestID(name + "_chest");
            VariantChestRenderer.left[ordinal] = VariantChestRenderer.getChestID(name + "_chest_left");
            VariantChestRenderer.right[ordinal] = VariantChestRenderer.getChestID(name + "_chest_right");
        }
    }
}

