/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.compat.WailaUtil;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;

@WailaPlugin
public class Jade
implements IWailaPlugin,
IBlockComponentProvider {
    public static final ResourceLocation SHOW_TREE_BLOCKS = new ResourceLocation("treechop", "show_tree_block_counts");
    public static final ResourceLocation SHOW_NUM_CHOPS_REMAINING = new ResourceLocation("treechop", "show_num_chops_remaining");
    private static final ResourceLocation UID = TreeChop.resource("plugin");

    public void registerClient(IWailaClientRegistration registrar) {
        registrar.registerBlockComponent((IBlockComponentProvider)this, Block.class);
        registrar.registerBlockIcon((IBlockComponentProvider)this, ChoppedLogBlock.class);
        registrar.addConfig(SHOW_TREE_BLOCKS, true);
        registrar.addConfig(SHOW_NUM_CHOPS_REMAINING, true);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Jade.changeBlockName(tooltip, accessor);
        Level level = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        boolean showNumBlocks = config.get(SHOW_TREE_BLOCKS);
        boolean showChopsRemaining = config.get(SHOW_NUM_CHOPS_REMAINING);
        if (WailaUtil.playerWantsTreeInfo(level, pos, showNumBlocks, showChopsRemaining)) {
            LinkedList tiles = new LinkedList();
            WailaUtil.addTreeInfo(level, pos, showNumBlocks, showChopsRemaining, arg_0 -> ((ITooltip)tooltip).add(arg_0), stack -> {
                IElement icon = tooltip.getElementHelper().item(stack, 1.0f, Integer.toString(stack.m_41613_()));
                tiles.add(icon.translate(new Vec2(0.0f, -1.5f)));
            });
            tooltip.add(tiles);
        }
    }

    private static void changeBlockName(ITooltip tooltip, BlockAccessor accessor) {
        ResourceLocation OBJECT_NAME_COMPONENT_KEY = new ResourceLocation("jade", "object_name");
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity choppedEntity = (ChoppedLogBlock.MyEntity)blockEntity;
            tooltip.clear();
            MutableComponent newName = WailaUtil.getPrefixedBlockName(choppedEntity);
            IElement newNameElement = tooltip.getElementHelper().text((Component)IThemeHelper.get().title((Object)newName)).tag(OBJECT_NAME_COMPONENT_KEY);
            tooltip.add(newNameElement);
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

