/*
 * Decompiled with CFR 0.152.
 */
package com.ineffa.trulytreasures;

import com.ineffa.trulytreasures.TrulyTreasures;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public enum WandererTreasureEnchantmentFilter {
    DEFAULT(enchantment -> enchantment.m_6594_() && !enchantment.m_6589_()),
    VILLAGER(Enchantment::m_6594_),
    POSITIVE(enchantment -> !enchantment.m_6589_()),
    ALL(enchantment -> true),
    CURSES(Enchantment::m_6589_),
    NONE(enchantment -> false);

    private final Predicate<Enchantment> enchantmentFilter = enchantment -> enchantment.m_6591_() && enchantmentFilter.test((Enchantment)enchantment) && !TrulyTreasures.config.wanderingTraderSettings.enchantmentBlacklist.contains(ForgeRegistries.ENCHANTMENTS.getKey(enchantment).toString());

    private WandererTreasureEnchantmentFilter(Predicate<Enchantment> enchantmentFilter) {
    }

    public List<Enchantment> filterEnchantments(Stream<Enchantment> streamToFilter) {
        return streamToFilter.filter(this.enchantmentFilter).toList();
    }

    public boolean acceptsEnchantment(Enchantment enchantment) {
        return this.enchantmentFilter.test(enchantment);
    }
}

