/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockHardnessHandler {
    public static final Map<Block, Double> TAG_MAP = new HashMap<Block, Double>();
    public static final Map<Block, Double> BLOCK_MAP = new HashMap<Block, Double>();
    public static final Map<TagKey<Block>, Double> TAGS_TO_EVALUATE = new LinkedHashMap<TagKey<Block>, Double>();

    public static void loadTags() {
        TAG_MAP.clear();
        for (Map.Entry<TagKey<Block>, Double> entry : TAGS_TO_EVALUATE.entrySet()) {
            double hardness = entry.getValue();
            for (Holder holder : BuiltInRegistries.f_256975_.m_206058_(entry.getKey())) {
                TAG_MAP.put((Block)holder.m_203334_(), hardness);
            }
        }
        TAGS_TO_EVALUATE.clear();
    }

    public static void cleanUp() {
        TAG_MAP.clear();
        BLOCK_MAP.clear();
        TAGS_TO_EVALUATE.clear();
    }

    public static double getHardness(BlockState state) {
        Block block = state.m_60734_();
        if (BLOCK_MAP.containsKey(block)) {
            return BLOCK_MAP.get(block);
        }
        if (TAG_MAP.containsKey(block)) {
            return TAG_MAP.get(block);
        }
        return block.m_7325_();
    }

    public static class BlockReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final BlockReloadListener INSTANCE = new BlockReloadListener();

        public BlockReloadListener() {
            super(GSON, "block_hardness");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            BlockHardnessHandler.cleanUp();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    double hardness = GsonHelper.m_144784_((JsonObject)el.getAsJsonObject(), (String)"block_hardness");
                    ResourceLocation loc = entry.getKey();
                    if (loc.m_135815_().startsWith("tags/")) {
                        ResourceLocation pruned = new ResourceLocation(loc.m_135827_(), loc.m_135815_().substring(5));
                        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)pruned);
                        TAGS_TO_EVALUATE.put((TagKey<Block>)tag, hardness);
                        continue;
                    }
                    Block block = (Block)BuiltInRegistries.f_256975_.m_6612_(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    BLOCK_MAP.put(block, hardness);
                }
                catch (Exception exception) {}
            }
        }
    }
}

