/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedBigCannonProjectileProperties;
import rbasamoyai.createbigcannons.munitions.config.MunitionPropertiesSerializer;

public class SmokeShellProperties
extends FuzedBigCannonProjectileProperties {
    private final float smokeScale;
    private final int smokeDuration;

    public SmokeShellProperties(float entityDamage, float durabilityMass, boolean rendersInvulnerable, boolean ignoresEntityArmor, double gravity, double drag, float knockback, int addedChargePower, float minimumChargePower, boolean canSquib, float addedRecoil, boolean baseFuze, float smokeScale, int smokeDuration) {
        super(entityDamage, durabilityMass, rendersInvulnerable, ignoresEntityArmor, gravity, drag, knockback, addedChargePower, minimumChargePower, canSquib, addedRecoil, baseFuze);
        this.smokeScale = smokeScale;
        this.smokeDuration = smokeDuration;
    }

    public SmokeShellProperties(String id, JsonObject obj) {
        super(id, obj);
        this.smokeScale = Mth.m_14036_((float)MunitionPropertiesSerializer.getOrWarn(obj, "smoke_scale", id, Float.valueOf(10.0f), JsonElement::getAsFloat).floatValue(), (float)1.0f, (float)20.0f);
        this.smokeDuration = Math.max(1, MunitionPropertiesSerializer.getOrWarn(obj, "smoke_duration", id, 300, JsonElement::getAsInt));
    }

    public SmokeShellProperties(FriendlyByteBuf buf) {
        super(buf);
        this.smokeScale = buf.readFloat();
        this.smokeDuration = buf.m_130242_();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeFloat(this.smokeScale);
        buf.m_130130_(this.smokeDuration);
    }

    public float smokeScale() {
        return this.smokeScale;
    }

    public int smokeDuration() {
        return this.smokeDuration;
    }

    public static class Serializer
    implements MunitionPropertiesSerializer<SmokeShellProperties> {
        @Override
        public SmokeShellProperties fromJson(ResourceLocation loc, JsonObject obj) {
            return new SmokeShellProperties(loc.toString(), obj);
        }

        @Override
        public SmokeShellProperties fromNetwork(ResourceLocation loc, FriendlyByteBuf buf) {
            return new SmokeShellProperties(buf);
        }
    }
}

