/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon.flak;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.autocannon.AbstractAutocannonProjectile;
import rbasamoyai.createbigcannons.munitions.autocannon.flak.FlakAutocannonProjectileProperties;
import rbasamoyai.createbigcannons.munitions.big_cannon.shrapnel.Shrapnel;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class FlakAutocannonProjectile
extends AbstractAutocannonProjectile<FlakAutocannonProjectileProperties> {
    private ItemStack fuze = ItemStack.f_41583_;

    public FlakAutocannonProjectile(EntityType<? extends FlakAutocannonProjectile> type, Level level) {
        super((EntityType<? extends AbstractAutocannonProjectile>)type, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.canDetonate(fz -> fz.onProjectileTick(this.fuze, this))) {
            this.detonate();
        }
    }

    @Override
    protected void expireProjectile() {
        FuzeItem fuzeItem;
        Item item = this.fuze.m_41720_();
        if (item instanceof FuzeItem && (fuzeItem = (FuzeItem)item).onProjectileExpiry(this.fuze, this)) {
            this.detonate();
        }
        super.expireProjectile();
    }

    @Override
    protected void onImpact(HitResult result, boolean stopped) {
        super.onImpact(result, stopped);
        if (this.canDetonate(fz -> fz.onProjectileImpact(this.fuze, this, result, stopped, false))) {
            this.detonate();
        }
    }

    @Override
    protected boolean onClip(ProjectileContext ctx, Vec3 pos) {
        if (super.onClip(ctx, pos)) {
            return true;
        }
        if (this.canDetonate(fz -> fz.onProjectileClip(this.fuze, this, pos, ctx, false))) {
            this.detonate();
            return true;
        }
        return false;
    }

    protected void detonate() {
        Vec3 oldDelta = this.m_20184_();
        this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, ((CBCCfgMunitions.GriefState)((Object)CBCConfigs.SERVER.munitions.damageRestriction.get())).explosiveInteraction());
        this.m_20256_(oldDelta);
        FlakAutocannonProjectileProperties properties = (FlakAutocannonProjectileProperties)this.getProperties();
        if (properties != null) {
            Shrapnel.spawnShrapnelBurst(this.m_9236_(), (EntityType)CBCEntityTypes.SHRAPNEL.get(), this.m_20182_(), this.m_20184_(), properties.shrapnelCount(), properties.shrapnelSpread(), properties.shrapnelDamage());
        }
        this.m_146870_();
    }

    public void setFuze(ItemStack fuze) {
        this.fuze = fuze;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.fuze != null && !this.fuze.m_41619_()) {
            tag.m_128365_("Fuze", (Tag)this.fuze.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fuze = tag.m_128425_("Fuze", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Fuze")) : ItemStack.f_41583_;
    }

    protected final boolean canDetonate(Predicate<FuzeItem> cons) {
        FuzeItem fuzeItem;
        Item item;
        return !this.m_9236_().f_46443_ && this.m_9236_().m_46805_(this.m_20183_()) && (item = this.fuze.m_41720_()) instanceof FuzeItem && cons.test(fuzeItem = (FuzeItem)item);
    }
}

