/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.manualloading;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.cannon_control.contraption.MountedBigCannonContraption;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.manualloading.HandloadingTool;
import rbasamoyai.createbigcannons.munitions.big_cannon.BigCannonMunitionBlock;

public class RamRodItem
extends Item
implements HandloadingTool {
    public static final UUID BASE_ATTACK_KNOCKBACK_UUID = UUID.fromString("bfa4160d-4ef0-4069-9569-3dfd2765f1c6");
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public RamRodItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(BASE_ATTACK_KNOCKBACK_UUID, "Tool modifier", 2.5, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos1;
        BlockState state1;
        int i;
        Player player = context.m_43723_();
        if (player instanceof DeployerFakePlayer && !RamRodItem.deployersCanUse()) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        Direction pushDirection = face.m_122424_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int k = 0;
        if (level.m_7702_(pos) instanceof IBigCannonBlockEntity) {
            BlockState state = level.m_8055_(pos.m_121945_(face));
            if (state.m_280555_()) {
                return InteractionResult.PASS;
            }
            k = -1;
            for (int i2 = 0; i2 < RamRodItem.getReach(); ++i2) {
                IBigCannonBlockEntity cbe;
                StructureTemplate.StructureBlockInfo info;
                BlockPos pos12 = pos.m_5484_(pushDirection, i2);
                BlockState state12 = level.m_8055_(pos12);
                if (state12.m_60795_()) continue;
                if (!RamRodItem.isValidLoadBlock(state12, level, pos12, pushDirection)) {
                    return InteractionResult.FAIL;
                }
                BlockEntity blockEntity = level.m_7702_(pos12);
                if (blockEntity instanceof IBigCannonBlockEntity && ((info = ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)blockEntity).cannonBehavior())).block()).f_74676_() == null || info.f_74676_().m_60795_())) continue;
                k = i2;
                break;
            }
            if (k == -1) {
                return InteractionResult.PASS;
            }
        }
        ArrayList<StructureTemplate.StructureBlockInfo> toPush = new ArrayList<StructureTemplate.StructureBlockInfo>();
        boolean encounteredCannon = false;
        int maxCount = RamRodItem.getPushStrength();
        for (i = 0; i < maxCount + 1 && !(state1 = level.m_8055_(pos1 = pos.m_5484_(pushDirection, i + k))).m_60795_(); ++i) {
            if (!RamRodItem.isValidLoadBlock(state1, level, pos1, pushDirection)) {
                return InteractionResult.FAIL;
            }
            BlockEntity be = level.m_7702_(pos1);
            if (be instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
                encounteredCannon = true;
                StructureTemplate.StructureBlockInfo info = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
                if (info.f_74676_().m_60795_()) break;
                toPush.add(info);
            } else {
                CompoundTag tag = null;
                if (be != null) {
                    tag = be.m_187480_();
                    tag.m_128473_("x");
                    tag.m_128473_("y");
                    tag.m_128473_("z");
                }
                toPush.add(new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, state1, tag));
            }
            if (toPush.size() <= maxCount) continue;
            return InteractionResult.FAIL;
        }
        if (!encounteredCannon || toPush.isEmpty()) {
            return InteractionResult.FAIL;
        }
        for (i = toPush.size() - 1; i >= 0; --i) {
            pos1 = pos.m_5484_(pushDirection, i + k);
            BlockEntity be1 = level.m_7702_(pos1);
            if (be1 instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be1;
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
                be1.m_6596_();
            } else {
                level.m_7471_(pos1, false);
            }
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)toPush.get(i);
            BlockPos pos2 = pos1.m_121945_(pushDirection);
            BlockEntity blockEntity = level.m_7702_(pos2);
            if (blockEntity instanceof IBigCannonBlockEntity) {
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)blockEntity;
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).tryLoadingBlock(info);
                continue;
            }
            level.m_7731_(pos2, info.f_74676_(), 67);
            BlockEntity be2 = level.m_7702_(pos2);
            CompoundTag tag = info.f_74677_();
            if (be2 != null) {
                tag = NBTProcessors.process((BlockEntity)be2, (CompoundTag)tag, (boolean)false);
            }
            if (be2 == null || tag == null) continue;
            tag.m_128405_("x", pos2.m_123341_());
            tag.m_128405_("y", pos2.m_123342_());
            tag.m_128405_("z", pos2.m_123343_());
            be2.m_142466_(tag);
        }
        level.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36399_((float)toPush.size() * CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
        player.m_36335_().m_41524_((Item)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
        return InteractionResult.CONSUME;
    }

    @Override
    public void onUseOnCannon(Player player, Level level, BlockPos startPos, Direction face, MountedBigCannonContraption contraption) {
        if (player instanceof DeployerFakePlayer && !RamRodItem.deployersCanUse()) {
            return;
        }
        Direction pushDirection = face.m_122424_();
        int k = 0;
        if (contraption.presentBlockEntities.get(startPos) instanceof IBigCannonBlockEntity) {
            k = -1;
            for (int i = 0; i < RamRodItem.getReach(); ++i) {
                IBigCannonBlockEntity cbe;
                StructureTemplate.StructureBlockInfo info1;
                BlockPos pos1 = startPos.m_5484_(pushDirection, i);
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos1);
                if (info == null || !RamRodItem.isValidLoadBlock(info.f_74676_(), contraption, pos1, pushDirection)) {
                    return;
                }
                Object v = contraption.presentBlockEntities.get(pos1);
                if (v instanceof IBigCannonBlockEntity && (info1 = ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)v).cannonBehavior())).block()).f_74676_().m_60795_()) continue;
                k = i;
                break;
            }
            if (k == -1) {
                return;
            }
        }
        ArrayList<StructureTemplate.StructureBlockInfo> toPush = new ArrayList<StructureTemplate.StructureBlockInfo>();
        boolean encounteredCannon = false;
        int maxCount = RamRodItem.getPushStrength();
        for (int i = 0; i < maxCount + 1; ++i) {
            BlockPos pos1 = startPos.m_5484_(pushDirection, i + k);
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos1);
            if (info == null || !RamRodItem.isValidLoadBlock(info.f_74676_(), contraption, pos1, pushDirection)) {
                return;
            }
            Object v = contraption.presentBlockEntities.get(pos1);
            if (!(v instanceof IBigCannonBlockEntity)) break;
            IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)v;
            encounteredCannon = true;
            StructureTemplate.StructureBlockInfo info1 = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
            if (info1.f_74676_().m_60795_()) break;
            toPush.add(info1);
            if (toPush.size() <= maxCount) continue;
            return;
        }
        if (!encounteredCannon || toPush.isEmpty()) {
            return;
        }
        if (!level.f_46443_) {
            HashSet<BlockPos> changes = new HashSet<BlockPos>(2);
            for (int i = toPush.size() - 1; i >= 0; --i) {
                BlockPos pos1 = startPos.m_5484_(pushDirection, i + k);
                BlockPos pos2 = pos1.m_121945_(pushDirection);
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)toPush.get(i);
                BlockEntity be1 = (BlockEntity)contraption.presentBlockEntities.get(pos1);
                BlockEntity be2 = (BlockEntity)contraption.presentBlockEntities.get(pos2);
                if (!(be1 instanceof IBigCannonBlockEntity)) break;
                IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be1;
                if (!(be2 instanceof IBigCannonBlockEntity)) break;
                IBigCannonBlockEntity cbe1 = (IBigCannonBlockEntity)be2;
                ((BigCannonBehavior)((Object)cbe.cannonBehavior())).removeBlock();
                ((BigCannonBehavior)((Object)cbe1.cannonBehavior())).tryLoadingBlock(info);
                changes.add(pos2);
                if (i != 0) continue;
                changes.add(pos1);
            }
            BigCannonBlock.writeAndSyncMultipleBlockData(changes, contraption.entity, contraption);
        }
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_12642_, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36399_((float)toPush.size() * CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
        player.m_36335_().m_41524_((Item)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
    }

    public static boolean isValidLoadBlock(BlockState state, Level level, BlockPos pos, Direction dir) {
        Block block = state.m_60734_();
        if (block instanceof BigCannonMunitionBlock) {
            BigCannonMunitionBlock munition = (BigCannonMunitionBlock)block;
            return munition.canBeLoaded(state, dir.m_122434_());
        }
        block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            return cBlock.getOpeningType(level, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).m_122434_() == dir.m_122434_();
        }
        return false;
    }

    public static boolean isValidLoadBlock(BlockState state, MountedBigCannonContraption contraption, BlockPos pos, Direction dir) {
        Block block = state.m_60734_();
        if (block instanceof BigCannonMunitionBlock) {
            BigCannonMunitionBlock munition = (BigCannonMunitionBlock)block;
            return munition.canBeLoaded(state, dir.m_122434_());
        }
        block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            return cBlock.getOpeningType(contraption, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).m_122434_() == dir.m_122434_();
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CBCTooltip.appendRamRodText(stack, level, tooltip, flag);
    }

    public static int getPushStrength() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodStrength.get();
    }

    public static int getReach() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodReach.get();
    }

    public static boolean deployersCanUse() {
        return (Boolean)CBCConfigs.SERVER.cannons.deployersCanUseLoadingTools.get();
    }
}

