/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.values;

import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.datagen.values.CBCDataProvider;

public class BlockHardnessProvider
extends CBCDataProvider {
    private final Map<Block, Double> blocks = new LinkedHashMap<Block, Double>();
    private final Map<TagKey<Block>, Double> tags = new LinkedHashMap<TagKey<Block>, Double>();
    private final Map<ResourceLocation, Double> locs = new LinkedHashMap<ResourceLocation, Double>();

    public BlockHardnessProvider(String modid, PackOutput output) {
        super(modid, output, "block_hardness");
    }

    @Override
    protected final void generateData(BiConsumer<ResourceLocation, JsonObject> cons) {
        this.addEntries();
        for (Map.Entry<Block, Double> entry : this.blocks.entrySet()) {
            cons.accept(BuiltInRegistries.f_256975_.m_7981_((Object)entry.getKey()), BlockHardnessProvider.writeHardness(entry.getValue()));
        }
        for (Map.Entry<Block, Double> entry : this.locs.entrySet()) {
            cons.accept((ResourceLocation)entry.getKey(), BlockHardnessProvider.writeHardness(entry.getValue()));
        }
        for (Map.Entry<Block, Double> entry : this.tags.entrySet()) {
            ResourceLocation srcLoc = ((TagKey)entry.getKey()).f_203868_();
            ResourceLocation tagLoc = new ResourceLocation(srcLoc.m_135827_(), "tags/" + srcLoc.m_135815_());
            cons.accept(tagLoc, BlockHardnessProvider.writeHardness(entry.getValue()));
        }
    }

    protected void addEntries() {
        this.setHardness(CBCTags.CBCBlockTags.OBSIDIAN, 12.0);
        this.setHardness(Blocks.f_50723_, 12.0);
        this.setHardness((TagKey<Block>)BlockTags.f_13033_, 6.0);
        this.setHardness((Block)AllBlocks.ITEM_VAULT.get(), 6.0);
        this.setHardness(CBCTags.CBCBlockTags.SANDSTONE, 4.5);
        this.setHardness(CBCTags.CBCBlockTags.CONCRETE, 4.5);
        this.setHardness(CBCTags.CBCBlockTags.NETHERRACK, 3.0);
        this.setHardness((TagKey<Block>)BlockTags.f_198156_, 4.5);
    }

    protected final void setHardness(Block block, double hardness) {
        this.blocks.put(block, hardness);
    }

    protected final void setHardness(TagKey<Block> tag, double hardness) {
        this.tags.put(tag, hardness);
    }

    protected final void setHardness(ResourceLocation loc, double hardness) {
        this.locs.put(loc, hardness);
    }

    private static JsonObject writeHardness(double v) {
        JsonObject obj = new JsonObject();
        obj.addProperty("block_hardness", (Number)v);
        return obj;
    }

    public String m_6055_() {
        return "Custom block hardness: " + this.modid;
    }
}

