/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.munition_assembly;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.index.CBCRecipeTypes;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.BigCartridgeBlock;

public class BigCartridgeFillingRecipe
extends CustomRecipe {
    public BigCartridgeFillingRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack cartridge = ItemStack.f_41583_;
        int powderCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (CBCBlocks.BIG_CARTRIDGE.is(stack.m_41720_())) {
                if (!cartridge.m_41619_()) {
                    return false;
                }
                cartridge = stack;
                continue;
            }
            if (stack.m_204117_(CBCTags.CBCItemTags.NITROPOWDER)) {
                ++powderCount;
                continue;
            }
            return false;
        }
        return !cartridge.m_41619_() && powderCount > 0;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ItemStack cartridge = ItemStack.f_41583_;
        int powderCount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (CBCBlocks.BIG_CARTRIDGE.is(stack.m_41720_())) {
                if (!cartridge.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                cartridge = stack;
                continue;
            }
            if (stack.m_204117_(CBCTags.CBCItemTags.NITROPOWDER)) {
                ++powderCount;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (cartridge.m_41619_() || powderCount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = cartridge.m_41777_();
        result.m_41764_(1);
        CompoundTag tag = result.m_41784_();
        int oldPower = tag.m_128451_("Power");
        int newPower = Math.min(BigCartridgeBlock.getMaximumPowerLevels(), oldPower + powderCount);
        tag.m_128405_("Power", newPower);
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList result = super.m_7457_((Container)container);
        int sz = container.m_6643_();
        int powderCount = 0;
        ItemStack oldCartridge = ItemStack.f_41583_;
        for (int i = 0; i < sz; ++i) {
            ItemStack stack = container.m_8020_(i);
            if (CBCBlocks.BIG_CARTRIDGE.is(stack.m_41720_())) {
                oldCartridge = stack;
                continue;
            }
            if (!stack.m_204117_(CBCTags.CBCItemTags.NITROPOWDER)) continue;
            ++powderCount;
        }
        if (oldCartridge.m_41619_()) {
            return result;
        }
        int oldPower = oldCartridge.m_41784_().m_128451_("Power");
        int newPower = Math.min(BigCartridgeBlock.getMaximumPowerLevels(), oldPower + powderCount);
        int consumed = newPower - oldPower;
        for (int i = 0; i < sz; ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_204117_(CBCTags.CBCItemTags.NITROPOWDER)) continue;
            if (consumed > 0) {
                --consumed;
                continue;
            }
            stack.m_41769_(1);
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return CBCRecipeTypes.BIG_CARTRIDGE_FILLING.getSerializer();
    }
}

