/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeFinder;
import rbasamoyai.createbigcannons.crafting.WandActionable;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastingRecipe;
import rbasamoyai.createbigcannons.crafting.casting.FinishedCannonCastBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.FluidCastingTimeHandler;
import rbasamoyai.createbigcannons.crafting.casting.InvalidCastingError;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public abstract class AbstractCannonCastBlockEntity
extends SmartBlockEntity
implements WandActionable,
IMultiBlockEntityContainer,
IHaveHoveringInformation {
    private static final Object CASTING_RECIPES_KEY = new Object();
    protected List<CannonCastShape> structure = new ArrayList<CannonCastShape>();
    protected CannonCastShape castShape = null;
    protected BlockPos controllerPos;
    protected BlockPos lastKnownPos;
    protected int height = 1;
    protected boolean forceFluidLevelUpdate = true;
    protected boolean forceCastLevelUpdate = true;
    protected int castingTime;
    protected int startCastingTime = 1;
    protected Map<CannonCastShape, CannonCastingRecipe> recipes = new HashMap<CannonCastShape, CannonCastingRecipe>();
    protected List<BlockState> resultPreview = new ArrayList<BlockState>();
    protected InvalidCastingError invalidCastingError = null;
    protected int castDelay = 0;
    protected boolean updateRecipes = true;
    private static final int SYNC_RATE = 8;
    protected boolean queuedSync;
    protected int syncCooldown;
    protected LerpedFloat fluidLevel;
    protected LerpedFloat castLevel;

    public AbstractCannonCastBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        Registry<CannonCastShape> shapeRegistry = CBCRegistries.cannonCastShapes();
        if (this.canRenderCastModel() && this.castShape != null) {
            tag.m_128359_("Size", shapeRegistry.m_7981_((Object)this.castShape).toString());
        }
        if (this.lastKnownPos != null) {
            tag.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (this.isController()) {
            if (!this.structure.isEmpty()) {
                ListTag structureTag = new ListTag();
                for (CannonCastShape sz : this.structure) {
                    structureTag.add((Object)StringTag.m_129297_((String)shapeRegistry.m_7981_((Object)sz).toString()));
                }
                tag.m_128365_("Structure", (Tag)structureTag);
            }
            tag.m_128405_("Height", this.height);
            tag.m_128405_("CastingTime", this.castingTime);
            this.writeFluidToTag(tag);
            if (this.startCastingTime > 1) {
                tag.m_128405_("StartCastingTime", this.startCastingTime);
            }
            if (this.updateRecipes) {
                tag.m_128379_("UpdateRecipes", true);
            }
            if (!this.recipes.isEmpty() && !this.structure.isEmpty()) {
                ListTag previewList = new ListTag();
                for (CannonCastShape shape : this.structure) {
                    if (this.recipes.containsKey(shape)) {
                        BlockState state = this.recipes.get(shape).getResultBlock().m_49966_();
                        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN);
                        }
                        previewList.add((Object)NbtUtils.m_129202_((BlockState)shape.applyTo(state)));
                        continue;
                    }
                    previewList.add((Object)new CompoundTag());
                }
                tag.m_128365_("Preview", (Tag)previewList);
            }
            InvalidCastingError.write(tag, this.invalidCastingError);
            tag.m_128405_("CastingDelay", this.castDelay);
        } else {
            tag.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        super.write(tag, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            tag.m_128379_("ForceFluidLevel", true);
        }
        if (this.forceCastLevelUpdate) {
            tag.m_128379_("ForceCastLevel", true);
        }
        if (this.queuedSync) {
            tag.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
        this.forceCastLevelUpdate = false;
    }

    protected abstract void writeFluidToTag(CompoundTag var1);

    protected void read(CompoundTag tag, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, clientPacket);
        Registry<CannonCastShape> shapeRegistry = CBCRegistries.cannonCastShapes();
        BlockPos controllerBefore = this.controllerPos;
        int prevHeight = this.getControllerBE() == null ? 0 : this.getControllerBE().height;
        CannonCastShape cannonCastShape = this.castShape = tag.m_128441_("Size") ? (CannonCastShape)shapeRegistry.m_7745_(new ResourceLocation(tag.m_128461_("Size"))) : null;
        if (tag.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LastKnownPos"));
        }
        this.structure.clear();
        if (tag.m_128441_("Structure")) {
            ListTag list = tag.m_128437_("Structure", 8);
            for (int i = 0; i < list.size(); ++i) {
                CannonCastShape shape = (CannonCastShape)shapeRegistry.m_7745_(new ResourceLocation(list.m_128778_(i)));
                this.structure.add(shape == null ? CannonCastShape.VERY_SMALL : shape);
            }
            this.height = tag.m_128451_("Height");
            this.updateFluids(tag);
            this.castingTime = Math.max(tag.m_128451_("CastingTime"), 0);
            this.startCastingTime = Math.max(tag.m_128451_("StartCastingTime"), 1);
            this.updateRecipes = tag.m_128441_("UpdateRecipes");
            this.resultPreview.clear();
            ListTag preview = tag.m_128437_("Preview", 10);
            for (int i = 0; i < preview.size(); ++i) {
                this.resultPreview.add(NbtUtils.m_247651_((HolderGetter)this.blockHolderGetter(), (CompoundTag)preview.m_128728_(i)));
            }
            this.invalidCastingError = InvalidCastingError.read(tag);
            this.castDelay = tag.m_128451_("CastingDelay");
            this.controllerPos = null;
        } else if (tag.m_128441_("Controller")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Controller"));
        }
        if (tag.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        if (tag.m_128441_("ForceCastLevel") || this.castLevel == null) {
            this.castLevel = LerpedFloat.linear().startWithValue((double)this.getCastingState());
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controllerPos);
        if (changeOfController || this.getControllerBE() != null && prevHeight != this.getControllerBE().height) {
            if (this.m_58898_()) {
                this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.updateFluidClient();
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (tag.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
            float castState = this.getCastingState();
            if (tag.m_128441_("ForceCastLevel") || this.castLevel == null) {
                this.castLevel = LerpedFloat.linear().startWithValue((double)castState);
            }
            this.castLevel.chase((double)castState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (tag.m_128441_("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
            this.castLevel.chase((double)this.castLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    protected abstract void updateFluids(CompoundTag var1);

    protected abstract void updateFluidClient();

    public void tick() {
        super.tick();
        this.invalidateRenderBoundingBox();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.f_58858_;
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
        if (this.castLevel != null) {
            this.castLevel.tickChaser();
        }
        if (this.isController()) {
            this.tickCastingBehavior();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void tickCastingBehavior() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.castDelay > 0) {
            --this.castDelay;
            this.notifyUpdate();
        }
        if (this.m_58904_().m_8055_(this.f_58858_.m_7495_()).m_247087_()) {
            this.leakContents();
        } else if (this.canStartCasting() && this.castDelay <= 0) {
            if (this.updateRecipes) {
                this.invalidCastingError = null;
                this.updateRecipes();
                if (this.invalidCastingError == null) {
                    int oldStartCastingTime = this.startCastingTime;
                    this.startCastingTime = FluidCastingTimeHandler.getCastingTime(this.getFluid());
                    if (this.startCastingTime != oldStartCastingTime) {
                        this.castingTime = this.startCastingTime;
                    }
                    this.updateRecipes = false;
                } else {
                    this.startCastingTime = 1;
                    this.castingTime = 0;
                    this.castDelay = 8;
                    this.recipes.clear();
                    this.notifyUpdate();
                    return;
                }
            }
            --this.castingTime;
            this.notifyUpdate();
            if (this.castingTime <= 0) {
                this.finishCasting();
                return;
            }
        } else {
            this.startCastingTime = 1;
            this.castingTime = 0;
            this.updateRecipes = true;
        }
    }

    protected abstract void leakContents();

    protected abstract boolean canStartCasting();

    protected void updateRecipes() {
        this.recipes.clear();
        List<BlockRecipe> list = BlockRecipeFinder.get(CASTING_RECIPES_KEY, this.m_58904_(), this::matchingRecipeCache);
        list.stream().map(CannonCastingRecipe.class::cast).filter(r -> r.matches(this.m_58904_(), this.f_58858_)).forEach(r -> this.recipes.put(r.shape(), (CannonCastingRecipe)r));
        ListIterator<CannonCastShape> iter = this.structure.listIterator();
        while (iter.hasNext()) {
            int i = iter.nextIndex();
            CannonCastShape shape = iter.next();
            if (this.recipes.containsKey(shape)) continue;
            this.invalidCastingError = new InvalidCastingError(this.f_58858_.m_6630_(i), this.getFluid(), shape);
            return;
        }
    }

    protected boolean matchingRecipeCache(BlockRecipe recipe) {
        return recipe instanceof CannonCastingRecipe;
    }

    protected abstract Fluid getFluid();

    protected void finishCasting() {
        if (!this.isController() || this.structure.isEmpty()) {
            return;
        }
        for (int y = 0; y < this.height; ++y) {
            BlockEntity blockEntity;
            if (this.structure.size() <= y) continue;
            CannonCastingRecipe recipe = this.recipes.get(this.structure.get(y));
            if (recipe == null) break;
            BlockPos pos = this.f_58858_.m_6630_(y);
            BlockEntity blockEntity2 = this.m_58904_().m_7702_(pos);
            if (!(blockEntity2 instanceof AbstractCannonCastBlockEntity)) break;
            AbstractCannonCastBlockEntity cast = (AbstractCannonCastBlockEntity)blockEntity2;
            BlockPos corner = pos.m_7918_(-1, 0, -1);
            if (cast.getRenderedSize().isLarge()) {
                BlockPos.m_121990_((BlockPos)corner, (BlockPos)pos.m_7918_(1, 0, 1)).forEach(pos1 -> {
                    BlockEntity patt12900$temp;
                    if (pos.equals(pos1) || !((patt12900$temp = this.m_58904_().m_7702_(pos1)) instanceof AbstractCannonCastBlockEntity)) {
                        return;
                    }
                    AbstractCannonCastBlockEntity cast1 = (AbstractCannonCastBlockEntity)patt12900$temp;
                    cast1.m_7651_();
                    this.m_58904_().m_7731_(pos1, CBCBlocks.FINISHED_CANNON_CAST.getDefaultState(), 11);
                    BlockEntity patt13127$temp = this.m_58904_().m_7702_(pos1);
                    if (!(patt13127$temp instanceof FinishedCannonCastBlockEntity)) {
                        return;
                    }
                    FinishedCannonCastBlockEntity fCast = (FinishedCannonCastBlockEntity)patt13127$temp;
                    if (pos1.equals((Object)corner)) {
                        fCast.setRenderedShape(cast.castShape);
                        fCast.setHeight(this.height);
                        fCast.setRootBlock(this.f_58858_.m_7918_(-1, 0, -1));
                    } else {
                        fCast.setCentralBlock(corner);
                    }
                });
            }
            recipe.assembleInWorld(this.m_58904_(), pos);
            if (y <= 0 || !((blockEntity = this.m_58904_().m_7702_(pos)) instanceof ICannonBlockEntity)) continue;
            ICannonBlockEntity cbe = (ICannonBlockEntity)blockEntity;
            blockEntity = this.m_58904_().m_7702_(pos.m_7495_());
            if (!(blockEntity instanceof ICannonBlockEntity)) continue;
            ICannonBlockEntity cbe1 = (ICannonBlockEntity)blockEntity;
            ((CannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(Direction.DOWN, true);
            ((CannonBehavior)((Object)cbe1.cannonBehavior())).setConnectedFace(Direction.UP, true);
        }
        SoundEvent sound = AllSoundEvents.STEAM.getMainEvent();
        this.m_58904_().m_5594_(null, this.m_58899_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public InteractionResult onWandUsed(UseOnContext context) {
        AbstractCannonCastBlockEntity controller;
        if (!this.m_58904_().f_46443_ && (controller = this.getControllerBE()) != null) {
            controller.castingTime = 0;
        }
        return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
    }

    public void initializeCastMultiblock(CannonCastShape size) {
        AbstractCannonCastBlockEntity controller;
        Object controller2;
        AbstractCannonCastBlockEntity otherCast;
        this.castShape = size;
        if (this.castShape == null) {
            return;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.f_58858_.m_7495_());
        if (blockEntity instanceof AbstractCannonCastBlockEntity && (otherCast = (AbstractCannonCastBlockEntity)blockEntity).m_58903_() == this.m_58903_() && otherCast.getHeight() < AbstractCannonCastBlockEntity.getMaxHeight()) {
            this.controllerPos = otherCast.getController();
            controller2 = otherCast.getControllerBE();
            if (controller2 != null) {
                this.addStructureCapacityToController((AbstractCannonCastBlockEntity)controller2);
                ++((AbstractCannonCastBlockEntity)controller2).height;
                ((AbstractCannonCastBlockEntity)controller2).structure.add(this.castShape);
                controller2.notifyUpdate();
            }
        } else {
            this.reInitTank();
            this.structure.add(this.castShape);
        }
        controller2 = this.m_58904_().m_7702_(this.f_58858_.m_7494_());
        if (controller2 instanceof AbstractCannonCastBlockEntity && (otherCast = (AbstractCannonCastBlockEntity)controller2).isController() && (controller2 = this.getControllerBE()) != null && ((AbstractCannonCastBlockEntity)controller2).height + otherCast.height <= AbstractCannonCastBlockEntity.getMaxHeight()) {
            ((AbstractCannonCastBlockEntity)controller2).height += otherCast.height;
            ((AbstractCannonCastBlockEntity)controller2).structure.addAll(otherCast.structure);
            otherCast.height = 1;
            otherCast.structure = new ArrayList<CannonCastShape>();
            this.mergeControllerAndOtherFluids((AbstractCannonCastBlockEntity)controller2, otherCast);
            ((AbstractCannonCastBlockEntity)controller2).updatePotentialCastsAbove();
            controller2.notifyUpdate();
        }
        if (size.isLarge()) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, 0, -1), (BlockPos)this.f_58858_.m_7918_(1, 0, 1))) {
                AbstractCannonCastBlockEntity childCast;
                if (pos.equals((Object)this.f_58858_)) continue;
                this.m_58904_().m_7731_(pos, CBCBlocks.CANNON_CAST.getDefaultState(), 11);
                BlockEntity blockEntity2 = this.m_58904_().m_7702_(pos);
                if (!(blockEntity2 instanceof AbstractCannonCastBlockEntity) || (childCast = (AbstractCannonCastBlockEntity)blockEntity2).m_58903_() != this.m_58903_()) continue;
                childCast.controllerPos = this.getController();
                childCast.notifyUpdate();
            }
        }
        if ((controller = this.getControllerBE()) != null) {
            controller.updateRecipes = true;
            controller.forceFluidLevelUpdate = true;
            controller.forceCastLevelUpdate = true;
            controller.notifyUpdate();
        }
        this.notifyUpdate();
    }

    protected abstract void addStructureCapacityToController(AbstractCannonCastBlockEntity var1);

    protected abstract void reInitTank();

    protected abstract void mergeControllerAndOtherFluids(AbstractCannonCastBlockEntity var1, AbstractCannonCastBlockEntity var2);

    public void destroyCastMultiblockAtLayer() {
        if (this.canRenderCastModel() && this.castShape != null) {
            this.onDestroyCenterCast();
        } else {
            BlockEntity blockEntity = this.m_58904_().m_7702_(this.getCenterBlock());
            if (blockEntity instanceof AbstractCannonCastBlockEntity) {
                AbstractCannonCastBlockEntity otherCast = (AbstractCannonCastBlockEntity)blockEntity;
                otherCast.destroyCastMultiblockAtLayer();
            }
        }
    }

    protected abstract void onDestroyCenterCast();

    public static List<CannonCastShape> getStructureFromPoint(Level level, BlockPos pos, int height) {
        BlockEntity blockEntity;
        ArrayList<CannonCastShape> structure = new ArrayList<CannonCastShape>();
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (!(blockEntity2 instanceof AbstractCannonCastBlockEntity)) {
            return structure;
        }
        AbstractCannonCastBlockEntity start = (AbstractCannonCastBlockEntity)blockEntity2;
        pos = start.getCenterBlock();
        for (int i = 0; i < height && (blockEntity = level.m_7702_(pos)) instanceof AbstractCannonCastBlockEntity; ++i) {
            AbstractCannonCastBlockEntity cast = (AbstractCannonCastBlockEntity)blockEntity;
            structure.add(cast.castShape);
        }
        return structure;
    }

    protected void updatePotentialCastsAbove() {
        BlockEntity blockEntity;
        if (!this.isController()) {
            return;
        }
        for (int y = 0; y < this.height && (blockEntity = this.m_58904_().m_7702_(this.f_58858_.m_6630_(y))) instanceof AbstractCannonCastBlockEntity; ++y) {
            AbstractCannonCastBlockEntity cast = (AbstractCannonCastBlockEntity)blockEntity;
            if (y != 0) {
                cast.setController(this.f_58858_);
            }
            if (!cast.getRenderedSize().isLarge()) continue;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockEntity blockEntity2;
                    if (x == 0 && z == 0 || !((blockEntity2 = this.m_58904_().m_7702_(this.f_58858_.m_7918_(x, y, z))) instanceof AbstractCannonCastBlockEntity)) continue;
                    AbstractCannonCastBlockEntity cast1 = (AbstractCannonCastBlockEntity)blockEntity2;
                    cast1.setController(this.f_58858_);
                    cast1.m_6596_();
                }
            }
        }
    }

    public int calculateCapacityFromStructure() {
        return this.structure.stream().map(CannonCastShape::fluidSize).reduce(Integer::sum).orElse(0);
    }

    public BlockPos getCenterBlock() {
        return this.isController() ? this.f_58858_ : new BlockPos(this.controllerPos.m_123341_(), this.f_58858_.m_123342_(), this.controllerPos.m_123343_());
    }

    public boolean canRenderCastModel() {
        return this.isController() || this.controllerPos.m_123341_() == this.f_58858_.m_123341_() && this.controllerPos.m_123343_() == this.f_58858_.m_123343_();
    }

    public abstract float getFillState();

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat level) {
        this.fluidLevel = level;
    }

    public float getCastingState() {
        return this.startCastingTime <= 1 ? 0.0f : 1.0f - (float)this.castingTime / (float)this.startCastingTime;
    }

    public LerpedFloat getCastingLevel() {
        return this.castLevel;
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controllerPos;
    }

    @Nullable
    public AbstractCannonCastBlockEntity getControllerBE() {
        AbstractCannonCastBlockEntity cast;
        BlockEntity blockEntity;
        return this.isController() ? this : ((blockEntity = this.m_58904_().m_7702_(this.controllerPos)) instanceof AbstractCannonCastBlockEntity ? (cast = (AbstractCannonCastBlockEntity)blockEntity) : null);
    }

    public boolean isController() {
        return this.controllerPos == null || this.f_58858_.equals((Object)this.controllerPos);
    }

    protected abstract void refreshCap();

    public void setController(BlockPos pos) {
        if (this.m_58904_().f_46443_) {
            this.invalidateRenderBoundingBox();
        }
        if (this.m_58904_().f_46443_ && !this.isVirtual() || pos.equals((Object)this.controllerPos)) {
            return;
        }
        this.controllerPos = pos;
        this.refreshCap();
        this.notifyUpdate();
    }

    public static int getMaxHeight() {
        return (Integer)CBCConfigs.SERVER.crafting.maxCannonCastHeight.get();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return 3;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82386_(-1.0, 0.0, -1.0).m_82363_(2.0, (double)(this.height - 1), 2.0);
        }
        if (this.canRenderCastModel() && this.getControllerBE() != null) {
            return this.getControllerBE().createRenderBoundingBox();
        }
        return super.createRenderBoundingBox();
    }

    public CannonCastShape getRenderedSize() {
        return this.castShape;
    }

    public void removeController(boolean keepContents) {
        this.refreshCap();
        this.notifyUpdate();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
    }

    public void notifyMultiUpdated() {
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return longAxis == Direction.Axis.Y ? (Integer)CBCConfigs.SERVER.crafting.maxCannonCastHeight.get() : 3;
    }

    public int getMaxWidth() {
        return 3;
    }

    public void setWidth(int width) {
    }

    public boolean matchesRecipe(CannonCastingRecipe recipe) {
        return this.getControllerBE() != null && this.getControllerBE().structure.contains(recipe.shape()) && this.testWithFluid(recipe);
    }

    protected abstract boolean testWithFluid(CannonCastingRecipe var1);

    public abstract boolean tryEmptyItemIntoBE(Level var1, Player var2, InteractionHand var3, ItemStack var4, Direction var5);

    public abstract boolean tryFillItemFromBE(Level var1, Player var2, InteractionHand var3, ItemStack var4, Direction var5);

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        AbstractCannonCastBlockEntity controller = this.getControllerBE();
        if (controller == null || controller.invalidCastingError == null) {
            return false;
        }
        MutableComponent errorMsg = controller.invalidCastingError.getMessage();
        List cutErrorLines = TooltipHelper.cutTextComponent((Component)errorMsg, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
        for (Component cline : cutErrorLines) {
            Lang.builder().add(cline.m_6881_()).forGoggles(tooltip);
        }
        return true;
    }
}

