/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannonloading;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannonloading.CannonLoadingContraption;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;

public class CannonLoaderCollider {
    public static boolean collideBlocks(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (!(contraption instanceof CannonLoadingContraption)) {
            return ContraptionCollider.collideBlocks((AbstractContraptionEntity)contraptionEntity);
        }
        CannonLoadingContraption contraption2 = (CannonLoadingContraption)contraption;
        Level level = contraptionEntity.m_20193_();
        Vec3 motion = contraptionEntity.m_20184_();
        AABB bounds = contraptionEntity.m_20191_();
        Vec3 position = contraptionEntity.m_20182_();
        BlockPos gridPos = BlockPos.m_274446_((Position)position);
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        Direction movementDirection = Direction.m_122366_((double)motion.f_82479_, (double)motion.f_82480_, (double)motion.f_82481_);
        if (movementDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.m_121945_(movementDirection);
        }
        if (CannonLoaderCollider.isCollidingWithWorld(level, contraption2, gridPos, movementDirection)) {
            return true;
        }
        for (ControlledContraptionEntity otherContraptionEntity : level.m_6443_(ControlledContraptionEntity.class, bounds.m_82400_(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.supportsTerrainCollision()) continue;
            Vec3 otherMotion = otherContraptionEntity.m_20184_();
            TranslatingContraption otherContraption = (TranslatingContraption)otherContraptionEntity.getContraption();
            AABB otherBounds = otherContraptionEntity.m_20191_();
            Vec3 otherPosition = otherContraptionEntity.m_20182_();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.m_82383_(motion).m_82381_(otherBounds.m_82383_(otherMotion))) continue;
            for (BlockPos colliderPos : contraption2.getOrCreateColliders(level, movementDirection)) {
                colliderPos = colliderPos.m_121955_((Vec3i)gridPos).m_121996_((Vec3i)BlockPos.m_274446_((Position)otherPosition));
                if (!otherContraption.getBlocks().containsKey(colliderPos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(Level level, CannonLoadingContraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getOrCreateColliders(level, movementDirection)) {
            IBigCannonBlockEntity cbe;
            BlockEntity blockEntity;
            BigCannonBlock cannonBlock;
            BlockPos colliderPos = pos.m_121955_((Vec3i)anchor);
            if (!level.m_46749_(colliderPos)) {
                return true;
            }
            BlockState collidedState = level.m_8055_(colliderPos);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
            boolean emptyCollider = collidedState.m_60812_((BlockGetter)level, pos).m_83281_();
            Block block = collidedState.m_60734_();
            if (block instanceof BigCannonBlock && (cannonBlock = (BigCannonBlock)block).getFacing(collidedState).m_122434_() == movementDirection.m_122434_() && (blockEntity = level.m_7702_(colliderPos)) instanceof IBigCannonBlockEntity && ((BigCannonBehavior)((Object)(cbe = (IBigCannonBlockEntity)blockEntity).cannonBehavior())).canLoadBlock(blockInfo) || collidedState.m_247087_() || emptyCollider) continue;
            return true;
        }
        return false;
    }
}

