/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.pipes.Pipe;
import me.dantaeusb.zetter.painting.tools.ActionListener;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.chat.Component;

public abstract class AbstractTool<T extends AbstractToolParameters> {
    protected final List<Pipe> pipes;
    protected final List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public AbstractTool(List<Pipe> pipes) {
        this.pipes = pipes;
    }

    public boolean hasEffect() {
        return true;
    }

    public boolean shouldAddAction(CanvasData canvasData, T parameters, float newPosX, float newPosY, @Nullable Float lastPosX, @Nullable Float lastPosY) {
        if (newPosX < 0.0f || newPosX > (float)canvasData.getWidth()) {
            return false;
        }
        if (newPosY < 0.0f || newPosY > (float)canvasData.getHeight()) {
            return false;
        }
        if (lastPosX == null || lastPosY == null) {
            return true;
        }
        return Math.floor(lastPosX.floatValue()) != Math.floor(newPosX) || Math.floor(lastPosY.floatValue()) != Math.floor(newPosY);
    }

    public abstract Component getTranslatableComponent();

    public int apply(CanvasData canvas, T params, int color, float posX, float posY) {
        int result = this.useTool(canvas, params, color, posX, posY);
        this.applyListeners(canvas, params, color, posX, posY);
        return result;
    }

    protected abstract int useTool(CanvasData var1, T var2, int var3, float var4, float var5);

    protected void pixelChange(CanvasData canvas, T parameters, int color, int index, float localIntensity) {
        if (!this.hasEffect()) {
            throw new IllegalStateException("Non-publishable tools cannot change pixels!");
        }
        if (index < 0 || index > canvas.getWidth() * canvas.getHeight()) {
            throw new IllegalStateException("Trying to update pixel outside of the canvas!");
        }
        for (Pipe pipe : this.pipes) {
            if (!pipe.shouldUsePipe(this, (AbstractToolParameters)parameters)) continue;
            color = pipe.applyPipe(canvas, (AbstractToolParameters)parameters, color, index, localIntensity);
        }
        canvas.updateCanvasPixel(index, color);
    }

    public abstract ToolShape getShape(T var1);

    private void applyListeners(CanvasData canvas, T params, int color, float posX, float posY) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.useToolCallback(canvas, this, (AbstractToolParameters)params, color, posX, posY);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners.contains(actionListener)) {
            return;
        }
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (!this.actionListeners.contains(actionListener)) {
            return;
        }
        this.actionListeners.remove(actionListener);
    }

    public record ShapeLine(LineDirection direction, int posX, int posY, int length) {

        public static enum LineDirection {
            HORIZONTAL(0, "Horizontal"),
            VERTICAL(1, "Vertical");

            private final int step;
            private final String name;

            private LineDirection(int step, String name) {
                this.step = step;
                this.name = name;
            }
        }
    }

    public static class ToolShape {
        protected final int[][] matrix;
        private ArrayList<ShapeLine> lines;
        private final int size;

        public ToolShape() {
            this(new int[][]{{1}});
        }

        public ToolShape(int[][] shape) {
            this.matrix = shape;
            this.size = Math.min(this.matrix.length, this.matrix[0].length);
            this.createLines();
        }

        private void createLines() {
            this.lines = new ArrayList();
            for (int y = 0; y < this.matrix.length; ++y) {
                int upperLineLength = 0;
                int lowerLineLength = 0;
                for (int x = -1; x <= this.matrix[y].length; ++x) {
                    if (x >= 0 && x < this.matrix[y].length && this.matrix[y][x] == 1) {
                        if (y == 0 || this.matrix[y - 1][x] == 0) {
                            ++upperLineLength;
                        } else if (upperLineLength > 0) {
                            this.commitLine(ShapeLine.LineDirection.HORIZONTAL, x, y, upperLineLength, false);
                            upperLineLength = 0;
                        }
                        if (y == this.matrix.length - 1 || this.matrix[y + 1][x] == 0) {
                            ++lowerLineLength;
                            continue;
                        }
                        if (lowerLineLength <= 0) continue;
                        this.commitLine(ShapeLine.LineDirection.HORIZONTAL, x, y, lowerLineLength, true);
                        lowerLineLength = 0;
                        continue;
                    }
                    if (upperLineLength > 0) {
                        this.commitLine(ShapeLine.LineDirection.HORIZONTAL, x, y, upperLineLength, false);
                        upperLineLength = 0;
                    }
                    if (lowerLineLength <= 0) continue;
                    this.commitLine(ShapeLine.LineDirection.HORIZONTAL, x, y, lowerLineLength, true);
                    lowerLineLength = 0;
                }
            }
            for (int x = 0; x < this.matrix.length; ++x) {
                int leftLineLength = 0;
                int rightLineLength = 0;
                for (int y = -1; y <= this.matrix[x].length; ++y) {
                    if (y >= 0 && y < this.matrix.length && this.matrix[y][x] == 1) {
                        if (x == 0 || this.matrix[y][x - 1] == 0) {
                            ++leftLineLength;
                        } else if (leftLineLength > 0) {
                            this.commitLine(ShapeLine.LineDirection.VERTICAL, x, y, leftLineLength, false);
                            leftLineLength = 0;
                        }
                        if (x == this.matrix[y].length - 1 || this.matrix[y][x + 1] == 0) {
                            ++rightLineLength;
                            continue;
                        }
                        if (rightLineLength <= 0) continue;
                        this.commitLine(ShapeLine.LineDirection.VERTICAL, x, y, rightLineLength, true);
                        rightLineLength = 0;
                        continue;
                    }
                    if (leftLineLength > 0) {
                        this.commitLine(ShapeLine.LineDirection.VERTICAL, x, y, leftLineLength, false);
                        leftLineLength = 0;
                    }
                    if (rightLineLength <= 0) continue;
                    this.commitLine(ShapeLine.LineDirection.VERTICAL, x, y, rightLineLength, true);
                    rightLineLength = 0;
                }
            }
        }

        public int getSize() {
            return this.size;
        }

        public ArrayList<ShapeLine> getLines() {
            return this.lines;
        }

        private void commitLine(ShapeLine.LineDirection direction, int x, int y, int length, boolean offset) {
            int xOffset = 0;
            int yOffset = 0;
            if (length == 0) {
                return;
            }
            if (direction == ShapeLine.LineDirection.HORIZONTAL) {
                if (offset) {
                    ++yOffset;
                }
                xOffset -= length;
            }
            if (direction == ShapeLine.LineDirection.VERTICAL) {
                if (offset) {
                    ++xOffset;
                }
                yOffset -= length;
            }
            this.lines.add(new ShapeLine(direction, x + xOffset, y + yOffset, length));
        }
    }
}

