/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import net.minecraft.network.FriendlyByteBuf;

public class SEaselMenuCreatePacket {
    public final int easelEntityId;
    @Nullable
    public final String canvasCode;

    public SEaselMenuCreatePacket(int easelEntityId, @Nullable String canvasCode) {
        this.easelEntityId = easelEntityId;
        this.canvasCode = canvasCode;
    }

    public static SEaselMenuCreatePacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            int easelEntityId = networkBuffer.readInt();
            boolean hasCanvasCode = networkBuffer.readBoolean();
            String canvasCode = null;
            if (hasCanvasCode) {
                canvasCode = networkBuffer.m_130136_(256);
            }
            return new SEaselMenuCreatePacket(easelEntityId, canvasCode);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Zetter.LOG.warn("Exception while reading SEaselMenuCreatePacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.writeInt(this.easelEntityId);
        if (this.canvasCode != null) {
            networkBuffer.writeBoolean(true);
            networkBuffer.m_130072_(this.canvasCode, 256);
        } else {
            networkBuffer.writeBoolean(false);
        }
    }

    public String toString() {
        return "SEaselMenuCreatePacket[easelId=" + this.easelEntityId + ",canvasCode=" + this.canvasCode + "]";
    }
}

