/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.features;

import com.natamus.collective_common_forge.data.FeatureFlags;
import com.natamus.collective_common_forge.functions.HeadFunctions;
import java.util.HashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerHeadCacheFeature {
    public static HashMap<String, ItemStack> cachedPlayerHeadsMap = new HashMap();

    public static ItemStack cachePlayer(Player player) {
        return PlayerHeadCacheFeature.cachePlayer(player.m_7755_().getString());
    }

    public static ItemStack cachePlayer(String playerName) {
        if (cachedPlayerHeadsMap.containsKey(playerName)) {
            return cachedPlayerHeadsMap.get(playerName).m_41777_();
        }
        ItemStack headStack = HeadFunctions.getPlayerHead(playerName, 1);
        if (headStack == null) {
            return null;
        }
        cachedPlayerHeadsMap.put(playerName, headStack);
        return headStack.m_41777_();
    }

    public static ItemStack getPlayerHeadStackFromCache(Player player) {
        return PlayerHeadCacheFeature.getPlayerHeadStackFromCache(player.m_7755_().getString());
    }

    public static ItemStack getPlayerHeadStackFromCache(String playerName) {
        if (cachedPlayerHeadsMap.containsKey(playerName)) {
            return cachedPlayerHeadsMap.get(playerName).m_41777_();
        }
        return PlayerHeadCacheFeature.cachePlayer(playerName);
    }

    public static boolean isHeadCachingEnabled() {
        return FeatureFlags.shouldCachePlayerHeads;
    }

    public static void enableHeadCaching() {
        FeatureFlags.shouldCachePlayerHeads = true;
    }

    public static boolean resetPlayerHeadCache() {
        cachedPlayerHeadsMap = new HashMap();
        return true;
    }
}

