/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.przemyk.simpleplanes.client.gui.ModifyUpgradesScreen;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.client.gui.PlaneWorkbenchScreen;
import xyz.przemyk.simpleplanes.client.gui.StorageScreen;
import xyz.przemyk.simpleplanes.client.render.PlaneItemColors;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.network.MoveHeliUpPacket;
import xyz.przemyk.simpleplanes.network.OpenInventoryPacket;
import xyz.przemyk.simpleplanes.network.OpenPlaneInventoryPacket;
import xyz.przemyk.simpleplanes.network.PitchPacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.network.YawPacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    public static final ResourceLocation HUD_TEXTURE = new ResourceLocation("simpleplanes", "textures/gui/plane_hud.png");
    public static KeyMapping moveHeliUpKey;
    public static KeyMapping openPlaneInventoryKey;
    public static KeyMapping dropPayloadKey;
    public static KeyMapping throttleUp;
    public static KeyMapping throttleDown;
    public static KeyMapping pitchUp;
    public static KeyMapping pitchDown;
    public static KeyMapping yawRight;
    public static KeyMapping yawLeft;
    private static boolean oldMoveHeliUpState;
    private static boolean oldPitchUpState;
    private static boolean oldPitchDownState;
    private static boolean oldYawRightState;
    private static boolean oldYawLeftState;

    public static void clientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.PLANE_WORKBENCH.get()), PlaneWorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.UPGRADES_REMOVAL.get()), ModifyUpgradesScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.STORAGE.get()), StorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SimplePlanesContainers.PLANE_INVENTORY.get()), PlaneInventoryScreen::new);
    }

    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        moveHeliUpKey = new KeyMapping("key.move_heli_up.desc", 32, "key.simpleplanes.category");
        openPlaneInventoryKey = new KeyMapping("key.plane_inventory_open.desc", 88, "key.simpleplanes.category");
        dropPayloadKey = new KeyMapping("key.plane_drop_payload.desc", 67, "key.simpleplanes.category");
        throttleUp = new KeyMapping("key.plane_throttle_up.desc", 265, "key.simpleplanes.category");
        throttleDown = new KeyMapping("key.plane_throttle_down.desc", 264, "key.simpleplanes.category");
        pitchUp = new KeyMapping("key.plane_pitch_up.desc", 87, "key.simpleplanes.category");
        pitchDown = new KeyMapping("key.plane_pitch_down.desc", 83, "key.simpleplanes.category");
        yawRight = new KeyMapping("key.plane_yaw_right.desc", 262, "key.simpleplanes.category");
        yawLeft = new KeyMapping("key.plane_yaw_left.desc", 263, "key.simpleplanes.category");
        event.register(moveHeliUpKey);
        event.register(openPlaneInventoryKey);
        event.register(dropPayloadKey);
        event.register(throttleUp);
        event.register(throttleDown);
        event.register(pitchUp);
        event.register(pitchDown);
        event.register(yawRight);
        event.register(yawLeft);
    }

    public static void registerHUDOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("plane_hud", (gui, guiGraphics, partialTicks, screenWidth, screenHeight) -> {
            Minecraft mc = Minecraft.m_91087_();
            Gui patt5301$temp = mc.f_91065_;
            if (patt5301$temp instanceof ForgeGui) {
                ForgeGui forgeGui = (ForgeGui)patt5301$temp;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                Entity patt5519$temp = mc.f_91074_.m_20202_();
                if (patt5519$temp instanceof PlaneEntity) {
                    PlaneEntity planeEntity = (PlaneEntity)patt5519$temp;
                    int left_align = scaledWidth / 2 + 91;
                    int health = planeEntity.getHealth();
                    float healthMax = planeEntity.getMaxHealth();
                    int hearts = (int)healthMax;
                    if (hearts > 10) {
                        hearts = 10;
                    }
                    boolean FULL = false;
                    int EMPTY = 16;
                    int GOLD = 32;
                    int max_row_size = 5;
                    int heart = 0;
                    while (hearts > 0) {
                        int top = scaledHeight - forgeGui.rightHeight;
                        int rowCount = Math.min(hearts, max_row_size);
                        hearts -= rowCount;
                        for (int i = 0; i < rowCount; ++i) {
                            int x = left_align - i * 16 - 16;
                            int vOffset = 35;
                            if (i + heart + 10 < health) {
                                guiGraphics.m_280218_(HUD_TEXTURE, x, top, 32, vOffset, 16, 9);
                                continue;
                            }
                            if (i + heart < health) {
                                guiGraphics.m_280218_(HUD_TEXTURE, x, top, 0, vOffset, 16, 9);
                                continue;
                            }
                            guiGraphics.m_280218_(HUD_TEXTURE, x, top, 16, vOffset, 16, 9);
                        }
                        forgeGui.rightHeight += 10;
                        heart += max_row_size;
                    }
                    guiGraphics.m_280218_(HUD_TEXTURE, scaledWidth - 24, scaledHeight - 42, 0, 84, 22, 40);
                    int throttle = planeEntity.getThrottle();
                    if (throttle > 0) {
                        int throttleScaled = throttle * 28 / 10;
                        guiGraphics.m_280218_(HUD_TEXTURE, scaledWidth - 24 + 10, scaledHeight - 42 + 6 + 28 - throttleScaled, 22, 118 - throttleScaled, 2, throttleScaled);
                    }
                    if (planeEntity.engineUpgrade != null) {
                        ItemStack offhandStack = mc.f_91074_.m_21206_();
                        HumanoidArm primaryHand = mc.f_91074_.m_5737_();
                        planeEntity.engineUpgrade.renderPowerHUD(guiGraphics, primaryHand == HumanoidArm.LEFT || offhandStack.m_41619_() ? HumanoidArm.LEFT : HumanoidArm.RIGHT, scaledWidth, scaledHeight, partialTicks);
                    }
                }
            }
        });
    }

    public static void planeColor(RegisterColorHandlersEvent.Item event) {
        SimplePlanesItems.getPlaneItems().forEach(item -> event.register(PlaneItemColors::getColor, new ItemLike[]{item}));
    }

    public static void reloadTextures(TextureStitchEvent.Post event) {
        PlaneItemColors.clearCache();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.m_20201_();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            PoseStack matrixStack = event.getPoseStack();
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.375, 0.0);
            Quaternionf quaternion = MathUtil.lerpQ(event.getPartialTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.set(quaternion.x(), -quaternion.y(), -quaternion.z(), quaternion.w());
            matrixStack.m_252781_(quaternion);
            float rotationYaw = MathUtil.lerpAngle(event.getPartialTick(), entity.f_19859_, entity.m_146908_());
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotationYaw));
            matrixStack.m_85837_(0.0, -0.375, 0.0);
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.f_20885_ = planeEntity.m_146908_() * 2.0f - livingEntity.f_20885_;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.f_20886_ = planeEntity.f_19859_ * 2.0f - livingEntity.f_20886_;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.m_20201_();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            event.getPoseStack().m_85849_();
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.f_20885_ = planeEntity.m_146908_() * 2.0f - event.getEntity().f_20885_;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.f_20886_ = planeEntity.f_19859_ * 2.0f - event.getEntity().f_20886_;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof LocalPlayer) {
            Entity entity = player.m_20202_();
            if (entity instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)entity;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91066_.f_92111_ != CameraType.FIRST_PERSON) {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                if (mc.f_91080_ == null && mc.m_91265_() == null && openPlaneInventoryKey.m_90859_()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new OpenPlaneInventoryPacket());
                } else if (dropPayloadKey.m_90859_()) {
                    for (Upgrade upgrade : planeEntity.upgrades.values()) {
                        if (!upgrade.canBeDroppedAsPayload()) continue;
                        upgrade.dropAsPayload();
                        SimplePlanesNetworking.INSTANCE.sendToServer((Object)new DropPayloadPacket());
                        break;
                    }
                }
                if (throttleUp.m_90859_()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new ChangeThrottlePacket(ChangeThrottlePacket.Type.UP));
                } else if (throttleDown.m_90859_()) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new ChangeThrottlePacket(ChangeThrottlePacket.Type.DOWN));
                }
                boolean isMoveHeliUp = moveHeliUpKey.m_90857_();
                boolean isPitchUp = pitchUp.m_90857_();
                boolean isPitchDown = pitchDown.m_90857_();
                boolean isYawRight = yawRight.m_90857_();
                boolean isYawLeft = yawLeft.m_90857_();
                if (isMoveHeliUp != oldMoveHeliUpState) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new MoveHeliUpPacket(isMoveHeliUp));
                }
                if (isPitchUp != oldPitchUpState || isPitchDown != oldPitchDownState) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new PitchPacket((byte)Boolean.compare(isPitchUp, isPitchDown)));
                }
                if (isYawRight != oldYawRightState || isYawLeft != oldYawLeftState) {
                    SimplePlanesNetworking.INSTANCE.sendToServer((Object)new YawPacket((byte)Boolean.compare(isYawRight, isYawLeft)));
                }
                oldMoveHeliUpState = isMoveHeliUp;
                oldPitchUpState = isPitchUp;
                oldPitchDownState = isPitchDown;
                oldYawRightState = isYawRight;
                oldYawLeftState = isYawLeft;
            } else {
                oldMoveHeliUpState = false;
                oldPitchUpState = false;
                oldPitchDownState = false;
                oldYawRightState = false;
                oldYawLeftState = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Camera camera = event.getCamera();
        Entity player = camera.m_90592_();
        Entity entity = player.m_20202_();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (camera.m_90594_()) {
                camera.m_90568_(-camera.m_90566_(4.0 * (planeEntity.getCameraDistanceMultiplayer() - 1.0)), 0.0, 0.0);
            } else {
                float heightDiff = 0.0f;
                if (planeEntity instanceof LargePlaneEntity) {
                    heightDiff = -0.1f;
                }
                double partialTicks = event.getPartialTick();
                Quaternionf qPrev = planeEntity.getQ_Prev();
                Quaternionf qNow = planeEntity.getQ_Client();
                Vector3f eyePrev = new Vector3f(0.0f, 1.62f + heightDiff, 0.0f);
                Vector3f eyeNow = new Vector3f((Vector3fc)eyePrev);
                eyePrev.rotate((Quaternionfc)qPrev);
                eyeNow.rotate((Quaternionfc)qNow);
                camera.m_90581_(new Vec3(Mth.m_14139_((double)partialTicks, (double)(player.f_19854_ - (double)eyePrev.x()), (double)(player.m_20185_() - (double)eyeNow.x())), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)eyePrev.y()), (double)(player.m_20186_() + (double)eyeNow.y())) + 0.375, Mth.m_14139_((double)partialTicks, (double)(player.f_19856_ + (double)eyePrev.z()), (double)(player.m_20189_() + (double)eyeNow.z()))));
                qPrev.mul((Quaternionfc)Axis.f_252436_.m_252977_(player.f_19859_));
                qPrev.mul((Quaternionfc)Axis.f_252529_.m_252977_(event.getPitch()));
                MathUtil.EulerAngles eulerAnglesPrev = MathUtil.toEulerAngles(qPrev);
                qNow.mul((Quaternionfc)Axis.f_252436_.m_252977_(player.m_146908_()));
                qNow.mul((Quaternionfc)Axis.f_252529_.m_252977_(event.getPitch()));
                MathUtil.EulerAngles eulerAnglesNow = MathUtil.toEulerAngles(qNow);
                event.setPitch(-((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.pitch, eulerAnglesNow.pitch)));
                event.setYaw((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.yaw, eulerAnglesNow.yaw));
                event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.roll, eulerAnglesNow.roll)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void planeInventory(ScreenEvent.Opening event) {
        LargePlaneEntity largePlaneEntity;
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getScreen() instanceof InventoryScreen && (entity = player.m_20202_()) instanceof LargePlaneEntity && (largePlaneEntity = (LargePlaneEntity)entity).hasStorageUpgrade()) {
            event.setCanceled(true);
            SimplePlanesNetworking.INSTANCE.sendToServer((Object)new OpenInventoryPacket());
        }
    }

    static {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ClientEventHandler::planeColor);
        eventBus.addListener(ClientEventHandler::reloadTextures);
        eventBus.addListener(ClientEventHandler::registerKeyBindings);
        eventBus.addListener(ClientEventHandler::registerHUDOverlay);
        oldMoveHeliUpState = false;
        oldPitchUpState = false;
        oldPitchDownState = false;
        oldYawRightState = false;
        oldYawLeftState = false;
    }
}

