/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class EvokerTrapBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty TRIGGERED = BooleanProperty.m_61465_((String)"triggered");
    private static final int fangCooldown = 40;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public EvokerTrapBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos sourcePos, boolean notify) {
        super.m_6861_(blockState, level, blockPos, block, sourcePos, notify);
        boolean powered = level.m_276867_(blockPos) || level.m_276867_(blockPos.m_7494_());
        boolean active = (Boolean)blockState.m_61143_((Property)ACTIVE);
        if (powered && !active) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            this.spawnFangs(blockState, level, blockPos, level.m_213780_());
            level.m_186460_(blockPos, (Block)this, 40);
        } else if (powered || active) {
            // empty if block
        }
    }

    private void spawnFangs(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.m_5776_()) {
            return;
        }
        int maxFangs = 3;
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.m_7967_((Entity)new EvokerFangs(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() - 0.5 - (double)i * 1.5, (float)Math.toRadians(90.0), 0, null));
                }
                break;
            }
            case SOUTH: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.m_7967_((Entity)new EvokerFangs(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 1.5 + (double)i * 1.5, (float)Math.toRadians(90.0), 0, null));
                }
                break;
            }
            case EAST: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.m_7967_((Entity)new EvokerFangs(level, (double)pos.m_123341_() + 1.5 + (double)i * 1.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0, null));
                }
                break;
            }
            case WEST: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.m_7967_((Entity)new EvokerFangs(level, (double)pos.m_123341_() - 0.5 - (double)i * 1.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0, null));
                }
                break;
            }
            default: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.m_7967_((Entity)new EvokerFangs(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() - 0.5 - (double)i * 1.5, 0.0f, 0, null));
                }
            }
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, TRIGGERED, ACTIVE});
    }
}

