/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.world;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.WanderingSkaterEntity;
import com.github.alexthe668.iwannaskate.server.world.IWSWorldData;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;

public class WanderingSkaterSpawner {
    private final Random random = new Random();
    private final ServerLevel world;
    private int timer;
    private int delay;
    private float chance;

    public WanderingSkaterSpawner(ServerLevel level) {
        this.world = level;
        this.timer = 1200;
        IWSWorldData worldinfo = IWSWorldData.get((Level)level);
        this.delay = worldinfo.getSkaterSpawnDelay();
        this.chance = worldinfo.getSkaterSpawnChance();
        if (this.delay == 0 && this.chance == 0.0f) {
            this.delay = (Integer)IWannaSkateMod.COMMON_CONFIG.wanderingSkaterSpawnDelay.get();
            worldinfo.setSkaterSpawnDelay(this.delay);
            this.chance = 3.0f * ((Double)IWannaSkateMod.COMMON_CONFIG.wanderingSkaterSpawnChance.get()).floatValue();
            worldinfo.setSkaterSpawnChance(this.chance);
        }
    }

    public void tick() {
        if (((Boolean)IWannaSkateMod.COMMON_CONFIG.spawnWanderingSkaters.get()).booleanValue() && --this.timer <= 0) {
            this.timer = 1200;
            this.delay -= 1200;
            if (this.delay < 0) {
                this.delay = 0;
            }
            IWSWorldData worldinfo = IWSWorldData.get((Level)this.world);
            worldinfo.setSkaterSpawnDelay(this.delay);
            if (this.delay <= 0) {
                this.delay = (Integer)IWannaSkateMod.COMMON_CONFIG.wanderingSkaterSpawnDelay.get();
                if (this.world.m_46469_().m_46207_(GameRules.f_46134_) && this.world.m_46469_().m_46207_(GameRules.f_46125_)) {
                    float prevChance = this.chance;
                    this.chance = Mth.m_14036_((float)(this.chance + ((Double)IWannaSkateMod.COMMON_CONFIG.wanderingSkaterSpawnChance.get()).floatValue()), (float)0.0f, (float)1.0f);
                    worldinfo.setSkaterSpawnChance(this.chance);
                    if (this.random.nextFloat() <= prevChance && this.attemptSpawnWanderingSkater()) {
                        this.chance = ((Double)IWannaSkateMod.COMMON_CONFIG.wanderingSkaterSpawnChance.get()).floatValue();
                    }
                }
            }
        }
    }

    private boolean attemptSpawnWanderingSkater() {
        IWSWorldData worldinfo = IWSWorldData.get((Level)this.world);
        ServerPlayer playerentity = this.world.m_8890_();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(5) != 0) {
            return false;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)playerentity.m_20182_());
        PoiManager poimanager = this.world.m_8904_();
        Optional optional = poimanager.m_27186_(p_219713_ -> p_219713_.m_203565_(PoiTypes.f_218061_), p_219711_ -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findSpawnLocationNear(blockpos1, 84);
        if (blockpos2 != null && this.func_226559_a_(blockpos2) && blockpos2.m_123331_((Vec3i)blockpos) > 225.0) {
            if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)this.world, blockpos2)) {
                if (this.world.m_204166_(blockpos2).m_203656_(BiomeTags.f_215807_)) {
                    return false;
                }
                WanderingSkaterEntity skater = (WanderingSkaterEntity)((EntityType)IWSEntityRegistry.WANDERING_SKATER.get()).m_262496_(this.world, blockpos2, MobSpawnType.EVENT);
                if (skater != null) {
                    if (worldinfo != null) {
                        worldinfo.setSkaterUUID(skater.m_20148_());
                    }
                    skater.m_35891_(48000);
                    skater.m_35883_(blockpos1);
                    skater.m_21446_(blockpos1, 22);
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findSpawnLocationNear(BlockPos center, int xzDistance) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = center.m_123341_() + this.random.nextInt(xzDistance * 2) - xzDistance;
            BlockPos blockpos1 = new BlockPos(j, l = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = center.m_123343_() + this.random.nextInt(xzDistance * 2) - xzDistance), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.world, (BlockPos)blockpos1, (EntityType)((EntityType)IWSEntityRegistry.WANDERING_SKATER.get()))) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_226559_a_(BlockPos p_226559_1_) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.m_121940_((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.m_7918_(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (this.world.m_8055_(blockpos = (BlockPos)var2.next()).m_60816_((BlockGetter)this.world, blockpos).m_83281_() && this.world.m_6425_(blockpos).m_76178_());
        return false;
    }

    private boolean hasEnoughSpace(BlockGetter level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(1, 2, 1))) {
            if (level.m_8055_(blockpos).m_60812_(level, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

