/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.entity;

public enum SkaterPose {
    NONE(0.0f),
    PEDAL(0.02f),
    STAND_SIDEWAYS(0.04f),
    CROUCH(0.06f),
    OLLIE(0.04f),
    KICKFLIP(0.04f),
    GRIND(0.04f);

    private float speed;

    private SkaterPose(float speed) {
        this.speed = speed;
    }

    public boolean isSideways() {
        return this != NONE && this != PEDAL && this != GRIND;
    }

    public boolean useBoardPitch() {
        return this.allowJumping() && this != KICKFLIP;
    }

    public boolean useBoardRoll() {
        return this != KICKFLIP;
    }

    public boolean allowJumping() {
        return this != PEDAL;
    }

    public boolean canBeOverriden() {
        return true;
    }

    public static SkaterPose get(int i) {
        if (i <= 0) {
            return NONE;
        }
        return SkaterPose.values()[Math.min(SkaterPose.values().length - 1, i)];
    }

    public float getSpeed(float pedalAmount) {
        if (this == PEDAL) {
            return this.speed + 0.015f * pedalAmount;
        }
        return this.speed;
    }
}

