/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.model;

import com.github.alexthe668.iwannaskate.client.model.ModelPartType;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class SkateModelMapping {
    private static final List<String> EMPTY = new ArrayList<String>();
    private EntityType<?> entityType;
    private TagKey<EntityType<?>> entityTypeTag;
    private final List<String> body;
    private final List<String> head;
    private final List<String> leftArm;
    private final List<String> rightArm;
    private final List<String> leftLeg;
    private final List<String> rightLeg;
    private final float strength;
    private final float speed;
    private final boolean faceForwards;

    public SkateModelMapping(@Nullable EntityType<?> entityType, @Nullable TagKey<EntityType<?>> entityTypeTag, List<String> body, List<String> head, List<String> leftArm, List<String> rightArm, List<String> leftLeg, List<String> rightLeg, float strength, float speed, boolean faceForwards) {
        this.entityType = entityType;
        this.entityTypeTag = entityTypeTag;
        this.body = body;
        this.head = head;
        this.leftArm = leftArm;
        this.rightArm = rightArm;
        this.leftLeg = leftLeg;
        this.rightLeg = rightLeg;
        this.speed = speed;
        this.strength = strength;
        this.faceForwards = faceForwards;
    }

    private static List<String> deserializeParts(JsonObject jsonobject, String partIdentifier) {
        ArrayList parts = Lists.newArrayList();
        if (jsonobject.has(partIdentifier)) {
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)jsonobject, (String)partIdentifier)) {
                parts.add(element.getAsString());
            }
        }
        return parts;
    }

    public List<String> getBody() {
        return this.body;
    }

    public List<String> getHead() {
        return this.head;
    }

    public List<String> getLeftArm() {
        return this.leftArm;
    }

    public List<String> getRightArm() {
        return this.rightArm;
    }

    public List<String> getLeftLeg() {
        return this.leftLeg;
    }

    public List<String> getRightLeg() {
        return this.rightLeg;
    }

    public boolean matchesEntityType(EntityType<?> type) {
        if (this.entityTypeTag != null) {
            return type.m_204039_(this.entityTypeTag);
        }
        if (this.entityType != null) {
            return type == this.entityType;
        }
        return false;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean isFaceForwards() {
        return this.faceForwards;
    }

    public List<String> getListForType(ModelPartType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ModelPartType.BODY -> this.getBody();
            case ModelPartType.HEAD -> this.getHead();
            case ModelPartType.LEFT_ARM -> this.getLeftArm();
            case ModelPartType.LEFT_LEG -> this.getLeftLeg();
            case ModelPartType.RIGHT_ARM -> this.getRightArm();
            case ModelPartType.RIGHT_LEG -> this.getRightLeg();
        };
    }

    public static class Deserializer
    implements JsonDeserializer<SkateModelMapping> {
        public SkateModelMapping deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            String entityTypeString = jsonobject.get("entity_type").getAsString();
            EntityType entityType = null;
            TagKey tagkey = null;
            if (entityTypeString.startsWith("#")) {
                ResourceLocation readStr = new ResourceLocation(entityTypeString.substring(1));
                tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)readStr);
            } else {
                ResourceLocation readsStr = new ResourceLocation(entityTypeString);
                if (!ForgeRegistries.ENTITY_TYPES.containsKey(readsStr)) {
                    throw new JsonParseException("missing entity type");
                }
                entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(readsStr);
            }
            List<String> body = SkateModelMapping.deserializeParts(jsonobject, "body");
            List<String> head = SkateModelMapping.deserializeParts(jsonobject, "head");
            List<String> rightArm = SkateModelMapping.deserializeParts(jsonobject, "right_arm");
            List<String> leftArm = SkateModelMapping.deserializeParts(jsonobject, "left_arm");
            List<String> rightLeg = SkateModelMapping.deserializeParts(jsonobject, "right_leg");
            List<String> leftLeg = SkateModelMapping.deserializeParts(jsonobject, "left_leg");
            float speed = jsonobject.get("animation_speed_modifier").getAsFloat();
            float strength = jsonobject.get("animation_strength_modifier").getAsFloat();
            boolean face = jsonobject.get("face_forwards").getAsBoolean();
            return new SkateModelMapping(entityType, tagkey, body, head, rightArm, leftArm, rightLeg, leftLeg, strength, speed, face);
        }
    }
}

