/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.misc;

import com.github.alexthe668.cloudstorage.item.BalloonArrowItem;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSRecipeRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeBalloonArrow
extends CustomRecipe {
    public RecipeBalloonArrow(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack balloon = this.getBalloon(container);
        if (this.isProperBalloon(balloon)) {
            int arrows = 0;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack itemstack = container.m_8020_(i);
                if (itemstack.m_150930_(Items.f_42412_)) {
                    ++arrows;
                }
                if (arrows >= 8) break;
            }
            return arrows == 8;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack balloon = this.getBalloon(container);
        ItemStack balloonArrow = this.getResultItem();
        ((BalloonArrowItem)balloonArrow.m_41720_()).m_41115_(balloonArrow, BalloonItem.getBalloonColor(balloon));
        return balloonArrow;
    }

    private ItemStack getBalloon(CraftingContainer container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            if (!this.isProperBalloon(container.m_8020_(i))) continue;
            return container.m_8020_(i);
        }
        return ItemStack.f_41583_;
    }

    private boolean isProperBalloon(ItemStack stack) {
        return stack.m_150930_((Item)CSItemRegistry.BALLOON.get()) && !BalloonItem.isStatic(stack) && !BalloonItem.isLoot(stack);
    }

    public ItemStack getResultItem() {
        return new ItemStack((ItemLike)CSItemRegistry.BALLOON_ARROW.get(), 8);
    }

    public boolean m_8004_(int x, int y) {
        return x >= 3 && y >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CSRecipeRegistry.BALLOON_ARROW_RECIPE.get();
    }

    public boolean m_5598_() {
        return false;
    }
}

