/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import com.github.alexthe668.cloudstorage.entity.LivingBalloon;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BadloonHandEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(BadloonHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> GESTURE = SynchedEntityData.m_135353_(BadloonHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PREV_GESTURE = SynchedEntityData.m_135353_(BadloonHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float gestureProgress = 1.0f;
    public float prevGestureProgress;
    public GloveGesture prevPrevGuesture;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    public BadloonHandEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public BadloonHandEntity(LivingEntity parent) {
        super((EntityType)CSEntityRegistry.BADLOON_HAND.get(), parent.m_9236_());
        this.setParent((Entity)parent);
    }

    public BadloonHandEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)CSEntityRegistry.BADLOON_HAND.get(), world);
        this.m_20331_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(GESTURE, (Object)0);
        this.f_19804_.m_135372_(PREV_GESTURE, (Object)0);
    }

    public boolean m_6000_(double x, double y, double z) {
        Entity parent = this.getParent();
        return super.m_6000_(x, y, z) || parent != null && parent.m_6000_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_());
    }

    public void m_8119_() {
        this.m_146867_();
        if (this.prevPrevGuesture != this.getPrevGesture()) {
            this.prevPrevGuesture = this.getPrevGesture();
            this.gestureProgress = 0.0f;
        }
        this.prevGestureProgress = this.gestureProgress;
        if (!this.m_9236_().f_46443_) {
            Entity parent = this.getParent();
            if (parent == null || parent instanceof LivingBalloon && !((LivingBalloon)parent).getChildId().equals(this.m_20148_())) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            this.m_20101_();
            if (parent != null) {
                if (parent.m_20159_()) {
                    Entity vehicle = parent.m_20202_();
                    double below = vehicle.m_20186_() + vehicle.m_6048_() - (double)0.2f;
                    this.m_6034_(parent.m_20185_(), below, parent.m_20189_());
                    this.m_20256_(Vec3.f_82478_);
                    this.faceTowardsY(vehicle.m_146908_());
                    this.setGesture(GloveGesture.GRAB);
                } else {
                    Vec3 vector3d = new Vec3(parent.m_20185_() - this.m_20185_(), 0.0, parent.m_20189_() - this.m_20189_());
                    float f = Mth.m_14116_((float)((float)(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)));
                    this.faceTowardsX((float)((double)(f * 1.0f) * 57.2957763671875));
                    this.faceTowardsY(parent.m_146908_());
                    Vec3 newMovement = this.m_20184_().m_82549_(this.moveTowardsParent(0.02f)).m_82490_((double)0.9f);
                    if (this.f_19862_ && this.m_20270_(parent) > 2.0f) {
                        double yUp = parent.m_20186_() - this.m_20186_();
                        newMovement = newMovement.m_82520_(0.0, yUp * (double)0.06f, 0.0);
                    } else if (parent instanceof BalloonBuddyEntity && ((BalloonBuddyEntity)parent).m_21825_() && parent.m_20186_() - 1.0 < this.m_20186_()) {
                        newMovement = newMovement.m_82520_(0.0, (double)-0.05f, 0.0);
                    }
                    if (newMovement.m_82556_() > (double)1.0E-4f) {
                        this.m_20256_(newMovement);
                    }
                }
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else if (this.lSteps > 0) {
            double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
            double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
            double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
            double d2 = Mth.m_14175_((double)(this.lyr - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d2 / (float)this.lSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
            --this.lSteps;
            this.m_6034_(d5, d6, d7);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (this.getPrevGesture() != this.getGesture() && this.gestureProgress < 1.0f) {
            this.gestureProgress += 0.25f;
        }
        if (this.getPrevGesture() == this.getGesture() && this.gestureProgress > 0.0f) {
            this.gestureProgress -= 0.25f;
        }
        if (!this.m_9236_().f_46443_ && this.m_20160_()) {
            this.setGesture(GloveGesture.GRAB);
        }
    }

    protected void m_20101_() {
        Entity parent = this.getParent();
        AABB aabb = this.m_20191_();
        BlockPos blockpos = BlockPos.m_274561_((double)(aabb.f_82288_ + 0.001), (double)(aabb.f_82289_ + 0.001), (double)(aabb.f_82290_ + 0.001));
        BlockPos blockpos1 = BlockPos.m_274561_((double)(aabb.f_82291_ - 0.001), (double)(aabb.f_82292_ - 0.001), (double)(aabb.f_82293_ - 0.001));
        if (this.m_9236_().m_46832_(blockpos, blockpos1)) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
                for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                    for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                        blockpos$mutableblockpos.m_122178_(i, j, k);
                        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                        try {
                            blockstate.m_60682_(this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                            this.m_6763_(blockstate);
                            if (parent == null) continue;
                            blockstate.m_60682_(this.m_9236_(), (BlockPos)blockpos$mutableblockpos, parent);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being collided with");
                            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    private void faceTowardsX(float f) {
        this.m_146926_(BalloonFace.rotlerp(this.m_146909_(), Mth.m_14036_((float)f, (float)-75.0f, (float)75.0f), 25.0f));
    }

    private void faceTowardsY(float f) {
        this.m_146922_(BalloonFace.rotlerp(this.m_146908_(), f, 25.0f));
    }

    private Vec3 moveTowardsParent(float speed) {
        Entity parent = this.getParent();
        if (parent != null) {
            float f = this.getGesture().holdsInFront() ? 0.5f : -0.5f;
            Vec3 gestAdd = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 target = parent.m_20182_().m_82492_(0.0, 2.0, 0.0).m_82549_(gestAdd).m_82546_(this.m_20182_());
            return target.m_82541_().m_82490_((double)speed);
        }
        return Vec3.f_82478_;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        moveFunction.m_20372_(entity, this.m_20185_(), this.m_20186_() + (double)0.4f - (double)entity.m_20206_(), this.m_20189_());
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_20148_());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("ParentUUID")) {
            this.setParentId(tag.m_128342_("ParentUUID"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.getParentId() != null) {
            tag.m_128362_("ParentUUID", this.getParentId());
        }
    }

    private void setGestureInt(int g) {
        this.f_19804_.m_135381_(GESTURE, (Object)g);
    }

    public void setGesture(GloveGesture gesture) {
        if (this.getGesture() != gesture) {
            this.f_19804_.m_135381_(PREV_GESTURE, (Object)this.getGesture().ordinal());
        }
        this.setGestureInt(gesture.ordinal());
    }

    public GloveGesture getGesture() {
        return GloveGesture.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(GESTURE)), (int)0, (int)5)];
    }

    public GloveGesture getPrevGesture() {
        return GloveGesture.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(PREV_GESTURE)), (int)0, (int)5)];
    }

    public void m_6453_(double p_38102_, double p_38103_, double p_38104_, float p_38105_, float p_38106_, int p_38107_, boolean p_38108_) {
        this.lx = p_38102_;
        this.ly = p_38103_;
        this.lz = p_38104_;
        this.lyr = p_38105_;
        this.lxr = p_38106_;
        this.lSteps = p_38107_;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double p_38171_, double p_38172_, double p_38173_) {
        this.lxd = p_38171_;
        this.lyd = p_38172_;
        this.lzd = p_38173_;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }
}

