/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.entity.BadloonHandEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.BalloonFlyer;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import com.github.alexthe668.cloudstorage.entity.LivingBalloon;
import com.github.alexthe668.cloudstorage.entity.ai.BadloonAttackGoal;
import com.github.alexthe668.cloudstorage.entity.ai.BadloonFearCactusGoal;
import com.github.alexthe668.cloudstorage.entity.ai.FlightMoveController;
import com.github.alexthe668.cloudstorage.entity.ai.FlyAroundGoal;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class BadloonEntity
extends Monster
implements LivingBalloon,
BalloonFlyer {
    private static final EntityDataAccessor<Float> ROT_Z = SynchedEntityData.m_135353_(BadloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(BadloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(BadloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FACE = SynchedEntityData.m_135353_(BadloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BALLOON_COLOR = SynchedEntityData.m_135353_(BadloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean dropMusicDisk = false;
    private Vec3 randomMoveOffset = null;
    public float prevRotZ;
    public int fearOfBeingPoppedCooldown = 0;
    private int droppedItems = 0;

    protected BadloonEntity(EntityType type, Level level) {
        super(type, level);
        this.f_21364_ = 3;
        this.f_21342_ = new FlightMoveController((Mob)this, 1.0f, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    protected void m_7562_() {
        if (this.f_19796_.m_188499_()) {
            ++this.f_20891_;
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return this.f_26495_.m_8055_(pos).m_60795_();
            }
        };
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BadloonFearCactusGoal(this, 1.3f));
        this.f_21345_.m_25352_(1, (Goal)new BadloonAttackGoal(this));
        this.f_21345_.m_25352_(2, new FlyAroundGoal<BadloonEntity>(this, 15, 7, 30, 1.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false).m_26146_(300));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_19789_ = 0.0f;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22280_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(FACE, (Object)0);
        this.f_19804_.m_135372_(ROT_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BALLOON_COLOR, (Object)15149353);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ChildUUID")) {
            this.setChildId(compound.m_128342_("ChildUUID"));
        }
        this.setFaceInt(compound.m_128451_("Face"));
        if (compound.m_128441_("BalloonColor")) {
            this.setBalloonColor(compound.m_128451_("BalloonColor"));
        } else {
            this.setBalloonColor(15149353);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getChildId() != null) {
            compound.m_128362_("ChildUUID", this.getChildId());
        }
        compound.m_128405_("Face", this.getFace().ordinal());
        compound.m_128405_("BalloonColor", this.getBalloonColor());
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_((double)0.8f, (double)0.6f, (double)0.8f));
        this.prevRotZ = this.getRotZ();
        if (!this.m_9236_().f_46443_) {
            Entity child = this.getChild();
            if (child == null) {
                BadloonHandEntity hand = new BadloonHandEntity((LivingEntity)this);
                hand.m_146884_(this.m_20182_().m_82520_(0.0, 0.5, 0.0));
                this.m_9236_().m_7967_((Entity)hand);
                this.setChildId(hand.m_20148_());
                this.f_19804_.m_135381_(CHILD_ID, (Object)hand.m_19879_());
            } else {
                this.f_19804_.m_135381_(CHILD_ID, (Object)child.m_19879_());
                if (this.m_20270_(child) > 4.0f) {
                    Vec3 back = child.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    this.m_20256_(this.m_20184_().m_82549_(back.m_82490_((double)0.1f)));
                }
            }
            if (this.randomMoveOffset != null) {
                Vec3 add = this.randomMoveOffset.m_82541_().m_82490_((double)(0.01f + this.f_19796_.m_188501_() * 0.01f));
                this.m_20256_(this.m_20184_().m_82549_(add));
            }
            if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.08, 0.0));
            }
            if (this.fearOfBeingPoppedCooldown > 0) {
                --this.fearOfBeingPoppedCooldown;
            }
        }
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        float f = Mth.m_14116_((float)((float)(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)));
        if (!this.m_9236_().f_46443_) {
            float xRotTarget = (float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * (double)0.05f * 57.2957763671875);
            this.m_146926_(BalloonFace.rotlerp(this.m_146909_(), xRotTarget, 5.0f));
        }
        float threshold = 0.015f;
        if (this.f_19859_ - this.m_146908_() > threshold) {
            this.setRotZ(this.getRotZ() + 1.0f);
        } else if (this.f_19859_ - this.m_146908_() < -threshold) {
            this.setRotZ(this.getRotZ() - 1.0f);
        } else if (this.getRotZ() > 0.0f) {
            this.setRotZ(Math.max(this.getRotZ() - 3.0f, 0.0f));
        } else if (this.getRotZ() < 0.0f) {
            this.setRotZ(Math.min(this.getRotZ() + 3.0f, 0.0f));
        }
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    @Override
    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    @Override
    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getHandForRendering() {
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(CHILD_ID)).intValue());
    }

    private void setFaceInt(int face) {
        this.f_19804_.m_135381_(FACE, (Object)(face % BalloonFace.values().length));
    }

    @Override
    public void setFace(BalloonFace face) {
        this.setFaceInt(face.ordinal());
    }

    @Override
    public BalloonFace getFace() {
        return BalloonFace.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(FACE)), (int)0, (int)(BalloonFace.values().length - 1))];
    }

    public float getRotZ() {
        return Mth.m_14036_((float)((Float)this.f_19804_.m_135370_(ROT_Z)).floatValue(), (float)-20.0f, (float)20.0f);
    }

    public void setRotZ(float rot) {
        this.f_19804_.m_135381_(ROT_Z, (Object)Float.valueOf(rot));
    }

    @Override
    public void setBalloonColor(int color) {
        this.f_19804_.m_135381_(BALLOON_COLOR, (Object)color);
    }

    @Override
    public int getBalloonColor() {
        return (Integer)this.f_19804_.m_135370_(BALLOON_COLOR);
    }

    @Override
    public float getPopProgress(float partialTick) {
        if (this.f_20919_ == 0) {
            return 0.0f;
        }
        return ((float)this.f_20919_ + partialTick - 1.0f) / 3.0f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)CSSoundRegistry.BALLOON_HURT.get();
    }

    protected void m_6153_() {
        int max = 3;
        if (this.f_20919_ == 0 && !this.m_20067_()) {
            this.m_5496_((SoundEvent)CSSoundRegistry.BALLOON_POP.get(), this.m_6121_(), 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
            this.m_146850_(GameEvent.f_223709_);
        }
        ++this.f_20919_;
        if (this.f_20919_ == max && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)67);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 67) {
            int color = this.getBalloonColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            for (int i = 0; i < 5 + this.f_19796_.m_188503_(2) + 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)CSParticleRegistry.BALLOON_SHARD.get(), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)r, (double)g, (double)b);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void setHandGesture(GloveGesture gesture) {
        Entity entity = this.getChild();
        if (entity instanceof BadloonHandEntity) {
            BadloonHandEntity hand = (BadloonHandEntity)entity;
            if (!this.m_20159_()) {
                hand.setGesture(gesture);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float f) {
        if (source.m_276093_(DamageTypes.f_268585_) || source.m_269533_(DamageTypeTags.f_268524_)) {
            f = 100.0f;
        }
        return super.m_6469_(source, f);
    }

    protected void m_6668_(DamageSource source) {
        boolean flag;
        Entity entity = source.m_7639_();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)source);
        this.captureDrops(new ArrayList());
        boolean bl = flag = this.f_20889_ > 0;
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_7625_(source, flag);
            this.m_7472_(source, i, flag);
        }
        if (this.dropMusicDisk) {
            this.dropMusicDisk = false;
            this.m_19998_((ItemLike)CSItemRegistry.MUSIC_DISC_DRIFT.get());
        }
        this.m_5907_();
        this.m_21226_();
        Collection drops = this.captureDrops(null);
        ArrayList<ItemEntity> splitDrops = new ArrayList<ItemEntity>();
        for (ItemEntity drop : drops) {
            for (int stackSize = 0; stackSize < drop.m_32055_().m_41613_(); ++stackSize) {
                ItemStack single = drop.m_32055_().m_41777_();
                single.m_41764_(1);
                ItemEntity split = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20188_(), this.m_20189_(), single);
                split.m_32060_();
                splitDrops.add(split);
            }
        }
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)source, splitDrops, (int)i, (this.f_20889_ > 0 ? 1 : 0) != 0)) {
            splitDrops.forEach(e -> this.popItem((ItemEntity)e, splitDrops.size()));
        }
    }

    private void popItem(ItemEntity e, int count) {
        float radius = 1.0f + this.f_19796_.m_188501_();
        Random seeded = new Random(this.m_19879_());
        float renderYawOffset = this.m_146908_() + (float)seeded.nextInt(360) + (float)this.droppedItems / (float)count * 360.0f;
        float angle = (float)((double)((float)Math.PI / 180 * renderYawOffset) + 3.15);
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        Vec3 vec = new Vec3(extraX, (double)0.8f, extraZ).m_82541_().m_82490_((double)0.2f);
        e.m_20256_(vec);
        ++this.droppedItems;
        this.m_9236_().m_7967_((Entity)e);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setBalloonColor(15149353);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public double m_6049_() {
        return 1.75 + Math.sin((float)this.f_19797_ * 0.05f) * 0.25;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public static boolean canBadloonSpawn(EntityType<BadloonEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || random.m_188501_() < 0.2f && iServerWorld.m_45527_(pos);
    }
}

