/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.command;

import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CloudIndex;
import com.github.alexthe668.cloudstorage.world.CSWorldData;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RetrieveBalloonsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"retrieveballoons").requires(sender -> sender.m_6761_(2))).executes(sender -> RetrieveBalloonsCommand.execute((CommandSourceStack)sender.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)sender.getSource()).m_81374_())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(sender -> RetrieveBalloonsCommand.execute((CommandSourceStack)sender.getSource(), EntityArgument.m_91461_((CommandContext)sender, (String)"targets")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"retrievestaticballoons").requires(sender -> sender.m_6761_(2))).executes(sender -> RetrieveBalloonsCommand.executePublic((CommandSourceStack)sender.getSource())));
    }

    private static int execute(CommandSourceStack command, Collection<? extends Entity> retrieveFor) {
        CSWorldData worldData = CSWorldData.get((Level)command.m_81372_());
        ItemStack balloon = new ItemStack((ItemLike)CSItemRegistry.BALLOON.get());
        int count = 0;
        ServerPlayer lastEntity = command.m_230896_();
        if (worldData != null) {
            for (Entity entity : retrieveFor) {
                for (CloudIndex index : worldData.getAllPrivateCloudsFor(entity.m_20148_())) {
                    RetrieveBalloonsCommand.addBalloon(balloon, index.getBalloonColor(), (Player)command.m_230896_());
                    ++count;
                }
                lastEntity = entity;
            }
        }
        if (count > 0) {
            command.f_81288_.m_213846_((Component)Component.m_237110_((String)"commands.retrieveballoons.success", (Object[])new Object[]{count, lastEntity.m_5446_()}));
        } else {
            command.m_81352_((Component)Component.m_237110_((String)"commands.retrieveballoons.failure", (Object[])new Object[]{count, lastEntity.m_5446_()}));
        }
        return 1;
    }

    private static MutableComponent createMessage(int count, Component displayName) {
        return Component.m_237110_((String)"commands.retrieveballoons.success", (Object[])new Object[]{count, displayName});
    }

    private static int executePublic(CommandSourceStack command) {
        CSWorldData worldData = CSWorldData.get((Level)command.m_81372_());
        ItemStack staticBalloon = new ItemStack((ItemLike)CSItemRegistry.BALLOON.get());
        BalloonItem.setStatic(staticBalloon, true);
        int count = 0;
        if (worldData != null) {
            for (CloudIndex index : worldData.getAllPublicClouds()) {
                RetrieveBalloonsCommand.addBalloon(staticBalloon, index.getBalloonColor(), (Player)command.m_230896_());
                ++count;
            }
        }
        if (count > 0) {
            command.f_81288_.m_213846_((Component)Component.m_237110_((String)"commands.retrievestaticballoons.success", (Object[])new Object[]{count}));
        } else {
            command.m_81352_((Component)Component.m_237110_((String)"commands.retrievestaticballoons.failure", (Object[])new Object[]{count}));
        }
        return 1;
    }

    private static void addBalloon(ItemStack base, int color, Player player) {
        ItemStack balloon = base.m_41777_();
        Item item = balloon.m_41720_();
        if (item instanceof BalloonItem) {
            BalloonItem balloonItem = (BalloonItem)item;
            balloonItem.m_41115_(balloon, color);
        }
        if (!player.m_36356_(balloon)) {
            player.m_36176_(balloon, false);
        }
    }
}

