/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe668.cloudstorage.entity.BloviatorEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class BloviatorModel
extends AdvancedEntityModel<BloviatorEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox left_cheek;
    private final AdvancedModelBox right_cheek;
    private final AdvancedModelBox[] clouds;

    public BloviatorModel(int cloudCount) {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setRotationPoint(0.0f, 24.0f, -6.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, "body");
        this.body.setRotationPoint(0.0f, -10.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(0, 0).addBox(-13.0f, -11.0f, -10.0f, 26.0f, 21.0f, 31.0f, 0.0f, false);
        this.clouds = new AdvancedModelBox[cloudCount];
        for (int i = 0; i < cloudCount; ++i) {
            float f = cloudCount <= 1 ? 0.0f : (float)i / (float)(cloudCount - 1) - 0.5f;
            float f2 = this.clouds.length <= 1 ? 0.25f : Mth.m_14089_((float)((float)((double)f * Math.PI)));
            AdvancedModelBox trail = new AdvancedModelBox((AdvancedEntityModel)this, "cloud_" + i);
            trail.setRotationPoint(f * 48.0f, -2.5f, 19.0f + f2 * 22.0f);
            trail.setTextureOffset(41, 53).addBox(-5.5f, -5.5f, -5.5f, 11.0f, 11.0f, 11.0f, 0.0f, false);
            this.body.addChild((BasicModelPart)trail);
            this.clouds[i] = trail;
        }
        this.left_cheek = new AdvancedModelBox((AdvancedEntityModel)this, "left_cheek");
        this.left_cheek.setRotationPoint(14.5f, -1.0f, 1.5f);
        this.body.addChild((BasicModelPart)this.left_cheek);
        this.left_cheek.setTextureOffset(0, 53).addBox(-1.5f, -7.0f, -7.5f, 5.0f, 14.0f, 15.0f, 0.0f, false);
        this.right_cheek = new AdvancedModelBox((AdvancedEntityModel)this, "right_cheek");
        this.right_cheek.setRotationPoint(-14.5f, -1.0f, 1.5f);
        this.body.addChild((BasicModelPart)this.right_cheek);
        this.right_cheek.setTextureOffset(0, 53).addBox(-3.5f, -7.0f, -7.5f, 5.0f, 14.0f, 15.0f, 0.0f, true);
        this.updateDefaultPose();
    }

    public void setupAnim(BloviatorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float idleSpeed = 0.15f;
        float idleDegree = 1.0f;
        float cheekProgress = entity.getPushProgress(partialTick);
        float cheekS = 1.0f;
        this.progressPositionPrev(this.right_cheek, cheekProgress, -1.0f, 0.0f, -3.0f, 1.0f);
        this.progressPositionPrev(this.left_cheek, cheekProgress, 1.0f, 0.0f, -3.0f, 1.0f);
        this.right_cheek.setScale(1.0f + cheekProgress, 1.0f, 1.0f);
        this.left_cheek.setScale(1.0f + cheekProgress, 1.0f, 1.0f);
        this.bob(this.body, idleSpeed, idleDegree * 0.5f, false, ageInTicks, 1.0f);
        this.right_cheek.rotationPointX = (float)((double)this.right_cheek.rotationPointX + (double)cheekS * ((double)idleDegree + Math.sin(ageInTicks * idleSpeed - 1.0f) * (double)idleDegree));
        this.left_cheek.rotationPointX = (float)((double)this.left_cheek.rotationPointX - (double)cheekS * ((double)idleDegree + Math.sin(ageInTicks * idleSpeed - 1.0f) * (double)idleDegree));
        this.right_cheek.rotationPointY = (float)((double)this.right_cheek.rotationPointY + (double)cheekS * Math.sin(ageInTicks * idleSpeed) * (double)idleDegree);
        this.left_cheek.rotationPointY = (float)((double)this.left_cheek.rotationPointY + (double)cheekS * Math.sin(ageInTicks * idleSpeed + 1.5f) * (double)idleDegree);
        this.right_cheek.rotationPointZ = (float)((double)this.right_cheek.rotationPointZ - (double)cheekS * Math.sin(ageInTicks * idleSpeed + 1.5f) * (double)idleDegree);
        this.left_cheek.rotationPointZ = (float)((double)this.left_cheek.rotationPointZ + (double)cheekS * Math.sin(ageInTicks * idleSpeed + 3.0f) * (double)idleDegree);
        float renderYaw = (float)entity.getLatencyVar(0, 3, partialTick);
        float half = (float)this.clouds.length / 2.0f;
        double d0 = Mth.m_14139_((double)partialTick, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)partialTick, (double)entity.f_19791_, (double)entity.m_20186_());
        double d2 = Mth.m_14139_((double)partialTick, (double)entity.f_19792_, (double)entity.m_20189_());
        float cloudOffset = 10.0f;
        for (int i = 0; i < this.clouds.length; ++i) {
            float f = this.clouds.length <= 1 ? 0.0f : (float)i / (float)(this.clouds.length - 1) - 0.5f;
            int offsetLatency = 5 + (int)(Mth.m_14089_((float)((float)((double)f * Math.PI))) * 15.0f);
            AdvancedModelBox cloud = this.clouds[i];
            Vec3 vec1 = new Vec3(entity.getLatencyVar(offsetLatency, 0, partialTick) - d0, entity.getLatencyVar(offsetLatency, 1, partialTick) - d1, entity.getLatencyVar(offsetLatency, 2, partialTick) - d2).m_82524_(renderYaw * ((float)Math.PI / 180));
            float intensity = 1.0f + (float)vec1.m_82553_() * 0.4f;
            cloud.rotationPointX = (float)((double)cloud.rotationPointX + (Math.sin(ageInTicks * idleSpeed + (float)i * 1.3f - half) * (double)idleDegree * (double)intensity + vec1.f_82479_ * (double)(-cloudOffset)));
            cloud.rotationPointY = (float)((double)cloud.rotationPointY + (Math.sin(ageInTicks * idleSpeed + (float)i * 2.0f - 1.0f) * (double)idleDegree * (double)intensity * 2.0 + vec1.f_82480_ * (double)(-cloudOffset)));
            cloud.rotationPointZ = (float)((double)cloud.rotationPointZ + (Math.cos(ageInTicks * idleSpeed + (float)i * 1.6f - half) * (double)idleDegree * (double)intensity * 2.0 + vec1.f_82481_ * (double)(-cloudOffset)));
            cloud.rotateAngleY = (float)((double)cloud.rotateAngleY + Math.toRadians(entity.getLatencyVar(offsetLatency / 2, 3, partialTick) - (double)renderYaw));
        }
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableSet.builder().add((Object[])new AdvancedModelBox[]{this.root, this.body, this.right_cheek, this.left_cheek}).addAll(Arrays.asList(this.clouds)).build();
    }
}

