/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.block;

import com.github.alexthe668.cloudstorage.block.AbstractCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.block.CSBlockEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.inventory.CloudChestMenu;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CloudIndex;
import com.github.alexthe668.cloudstorage.world.CSWorldData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class CloudChestBlockEntity
extends AbstractCloudChestBlockEntity {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"cloudstorage.container.cloud_chest");
    private Map<UUID, Integer> playerToBalloonColor = new HashMap<UUID, Integer>();
    private int lootBalloonColor = 0;
    private ResourceLocation lootTable;
    protected long lootTableSeed;

    public CloudChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CSBlockEntityRegistry.CLOUD_CHEST.get(), pos, state);
    }

    @Override
    public boolean hasBalloonFor(Player player) {
        return this.playerToBalloonColor.containsKey(player.m_20148_()) || this.hasLootBalloon();
    }

    @Override
    public int getBalloonFor(Player player) {
        if (this.hasLootBalloon()) {
            return this.lootBalloonColor + 1;
        }
        return this.playerToBalloonColor.get(player.m_20148_());
    }

    @Override
    public void setBalloonColorFor(Player player, int color) {
        this.playerToBalloonColor.put(player.m_20148_(), color);
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag list = tag.m_128437_("PlayerBalloons", 10);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compoundtag = list.m_128728_(i);
                UUID uuid = compoundtag.m_128342_("UUID");
                if (uuid == null) continue;
                this.playerToBalloonColor.put(uuid, compoundtag.m_128451_("BalloonColor"));
            }
        }
        this.lootBalloonColor = tag.m_128451_("LootColor");
        this.tryLoadLootTable(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.playerToBalloonColor.entrySet()) {
            CompoundTag balloonData = new CompoundTag();
            balloonData.m_128362_("UUID", entry.getKey());
            balloonData.m_128405_("BalloonColor", entry.getValue().intValue());
            list.add((Object)balloonData);
        }
        tag.m_128365_("PlayerBalloons", (Tag)list);
        tag.m_128405_("LootColor", this.lootBalloonColor);
        this.trySaveLootTable(tag);
    }

    protected boolean tryLoadLootTable(CompoundTag tag) {
        if (tag.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(tag.m_128461_("LootTable"));
            this.lootTableSeed = tag.m_128454_("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(CompoundTag tag) {
        if (this.lootTable == null) {
            return false;
        }
        tag.m_128359_("LootTable", this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            tag.m_128356_("LootTableSeed", this.lootTableSeed);
        }
        return true;
    }

    @Override
    public AbstractContainerMenu getMenu(int i, Inventory playerInventory) {
        CloudIndex cloudIndex;
        CSWorldData data = CSWorldData.get(this.m_58904_());
        Player player = playerInventory.f_35978_;
        if (data != null && this.hasBalloonFor(player) && !this.hasNoInvSpace(player) && (cloudIndex = this.getOrInitializePrivateCloud(data, player)) != null && cloudIndex.getContainerSize() > 0) {
            return new CloudChestMenu(i, playerInventory, (Container)cloudIndex.getContainer());
        }
        return null;
    }

    @Override
    public Component getTitle() {
        return CONTAINER_TITLE;
    }

    @Override
    public boolean hasNoInvSpace(Player player) {
        CSWorldData data = CSWorldData.get(this.m_58904_());
        if (data != null && this.hasBalloonFor(player)) {
            CloudIndex cloudIndex = this.getOrInitializePrivateCloud(data, player);
            return cloudIndex == null || cloudIndex.getContainerSize() == 0;
        }
        return false;
    }

    @Override
    public void releaseBalloons() {
        Vec3 releasePosition = Vec3.m_82539_((Vec3i)this.m_58899_()).m_82520_(0.0, (double)(this.getEmergence(1.0f) * 2.0f), 0.0);
        if (this.hasLootBalloon()) {
            ItemStack stack = new ItemStack((ItemLike)CSItemRegistry.BALLOON.get());
            BalloonItem.setLoot(stack, true);
            ((DyeableLeatherItem)stack.m_41720_()).m_41115_(stack, this.lootBalloonColor + 1);
            ItemEntity dropped = new ItemEntity(this.f_58857_, releasePosition.f_82479_, releasePosition.f_82480_, releasePosition.f_82481_, stack);
            this.f_58857_.m_7967_((Entity)dropped);
        } else {
            for (Map.Entry<UUID, Integer> entry : this.playerToBalloonColor.entrySet()) {
                BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_(this.f_58857_);
                balloon.setBalloonColor(entry.getValue());
                balloon.setCharged(false);
                balloon.setStringLength(1);
                balloon.m_146884_(releasePosition);
                this.f_58857_.m_7967_((Entity)balloon);
            }
        }
    }

    @Override
    public int getContainerSize(Player player) {
        CSWorldData data = CSWorldData.get(this.m_58904_());
        if (data != null && this.hasBalloonFor(player)) {
            CloudIndex cloudIndex = this.getOrInitializePrivateCloud(data, player);
            return cloudIndex != null ? cloudIndex.getContainerSize() : 0;
        }
        return 0;
    }

    @Nullable
    private CloudIndex getOrInitializePrivateCloud(CSWorldData data, Player player) {
        if (this.hasLootBalloon()) {
            CloudIndex indx = data.getLootCloud(player.m_20148_(), this.lootBalloonColor + 1);
            if (indx == null) {
                CloudIndex lootable = new CloudIndex(player.m_20148_(), this.lootBalloonColor + 1, 27);
                this.unpackLootTable(player, (Container)lootable.getContainer());
                data.addLootCloud(lootable);
                return lootable;
            }
            return indx;
        }
        return data.getPrivateCloud(player.m_20148_(), this.getBalloonFor(player));
    }

    @Override
    public void setLootBalloon(int color, ResourceLocation resourceLocation, long seed) {
        this.lootBalloonColor = color - 1;
        this.lootTable = resourceLocation;
        this.lootTableSeed = seed;
    }

    @Override
    public boolean hasLootBalloon() {
        return this.lootBalloonColor != 0;
    }

    public void unpackLootTable(@Nullable Player player, Container toFill) {
        if (this.lootTable != null && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, this.lootTable);
            }
            this.lootTable = null;
            LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                lootparams$builder.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_287188_(toFill, lootparams$builder.m_287235_(LootContextParamSets.f_81411_), this.lootTableSeed);
        }
    }
}

