/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import insane96mcp.progressivebosses.capability.Difficulty;
import insane96mcp.progressivebosses.module.dragon.feature.DifficultyFeature;
import insane96mcp.progressivebosses.module.dragon.feature.LarvaFeature;
import insane96mcp.progressivebosses.module.elderguardian.feature.MinionFeature;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class PBCommand {
    private PBCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"progressivebosses").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"difficulty").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targetPlayer", (ArgumentType)EntityArgument.m_91466_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"wither").executes(context -> PBCommand.getBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "wither")))).then(Commands.m_82127_((String)"dragon").executes(context -> PBCommand.getBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "dragon")))).executes(context -> PBCommand.getBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "")))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"wither").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)insane96mcp.progressivebosses.module.wither.feature.DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.setBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "wither", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"dragon").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.setBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "dragon", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"wither").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)insane96mcp.progressivebosses.module.wither.feature.DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.addBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "wither", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.m_82127_((String)"dragon").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.addBossDifficulty((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targetPlayer"), "dragon", IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"progressivebosses:wither_minion").then(Commands.m_82129_((String)"difficulty", (ArgumentType)IntegerArgumentType.integer((int)0, (int)insane96mcp.progressivebosses.module.wither.feature.DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), "progressivebosses:wither_minion", IntegerArgumentType.getInteger((CommandContext)context, (String)"difficulty"))))).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), "progressivebosses:wither_minion")))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"progressivebosses:dragon_minion").then(Commands.m_82129_((String)"difficulty", (ArgumentType)IntegerArgumentType.integer((int)0, (int)DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), "progressivebosses:dragon_minion", IntegerArgumentType.getInteger((CommandContext)context, (String)"difficulty"))))).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), "progressivebosses:dragon_minion")))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"progressivebosses:dragon_larva").then(Commands.m_82129_((String)"difficulty", (ArgumentType)IntegerArgumentType.integer((int)0, (int)DifficultyFeature.maxDifficulty)).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), "progressivebosses:dragon_larva", IntegerArgumentType.getInteger((CommandContext)context, (String)"difficulty"))))).executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), "progressivebosses:dragon_larva")))).then(Commands.m_82127_((String)"progressivebosses:elder_minion").executes(context -> PBCommand.summon((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), "progressivebosses:elder_minion")))));
    }

    private static int setBossDifficulty(CommandSourceStack source, ServerPlayer targetPlayer, String boss, int amount) {
        if (boss.equals("wither")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> difficulty.setSpawnedWithers(amount));
        }
        if (boss.equals("dragon")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> difficulty.setKilledDragons(amount));
        }
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_set_boss_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), boss, amount}), true);
        return amount;
    }

    private static int addBossDifficulty(CommandSourceStack source, ServerPlayer targetPlayer, String boss, int amount) {
        AtomicInteger difficulty = new AtomicInteger(0);
        if (boss.equals("wither")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> {
                difficultyCap.addSpawnedWithers(amount);
                difficulty.set(difficultyCap.getSpawnedWithers());
            });
        } else if (boss.equals("dragon")) {
            targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> {
                difficultyCap.addKilledDragons(amount);
                difficulty.set(difficultyCap.getKilledDragons());
            });
        }
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_add_boss_difficulty", (Object[])new Object[]{amount, boss, targetPlayer.m_7755_(), difficulty.get()}), true);
        return difficulty.get();
    }

    private static int getBossDifficulty(CommandSourceStack source, ServerPlayer targetPlayer, String boss) {
        AtomicInteger witherDifficulty = new AtomicInteger(0);
        targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> witherDifficulty.set(difficultyCap.getSpawnedWithers()));
        AtomicInteger dragonDifficulty = new AtomicInteger(0);
        targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> dragonDifficulty.set(difficultyCap.getKilledDragons()));
        switch (boss) {
            case "wither": {
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_wither_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), witherDifficulty}), true);
                return witherDifficulty.get();
            }
            case "dragon": {
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_dragon_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), dragonDifficulty}), true);
                return dragonDifficulty.get();
            }
        }
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_wither_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), witherDifficulty}), true);
        source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.player_get_dragon_difficulty", (Object[])new Object[]{targetPlayer.m_7755_(), dragonDifficulty}), true);
        return 1;
    }

    private static int summon(CommandSourceStack source, String entity, int difficulty) {
        switch (entity) {
            case "progressivebosses:wither_minion": {
                insane96mcp.progressivebosses.module.wither.feature.MinionFeature.summonMinion((Level)source.m_81372_(), source.m_81371_(), DifficultyHelper.getScalingDifficulty(difficulty, insane96mcp.progressivebosses.module.wither.feature.DifficultyFeature.maxDifficulty.intValue()), false);
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.summoned_entity", (Object[])new Object[]{Component.m_237115_((String)entity), difficulty}), true);
                return 1;
            }
            case "progressivebosses:dragon_minion": {
                insane96mcp.progressivebosses.module.dragon.feature.MinionFeature.summonMinion((Level)source.m_81372_(), source.m_81371_(), DifficultyHelper.getScalingDifficulty(difficulty, DifficultyFeature.maxDifficulty.intValue()));
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.summoned_entity", (Object[])new Object[]{Component.m_237115_((String)entity), difficulty}), true);
                return 1;
            }
            case "progressivebosses:dragon_larva": {
                LarvaFeature.summonLarva((Level)source.m_81372_(), source.m_81371_(), DifficultyHelper.getScalingDifficulty(difficulty, DifficultyFeature.maxDifficulty.intValue()));
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.summoned_entity", (Object[])new Object[]{Component.m_237115_((String)entity), difficulty}), true);
                return 1;
            }
            case "progressivebosses:elder_minion": {
                MinionFeature.summonMinion((Level)source.m_81372_(), source.m_81371_());
                source.m_288197_(() -> Component.m_237110_((String)"progressivebosses:command.summoned_entity", (Object[])new Object[]{Component.m_237115_((String)entity), difficulty}), true);
                return 1;
            }
        }
        source.m_81352_((Component)Component.m_237110_((String)"progressivebosses:command.summon_entity_invalid", (Object[])new Object[]{entity}));
        return 0;
    }

    private static int summon(CommandSourceStack source, ServerPlayer targetPlayer, String entity) {
        AtomicInteger witherDifficulty = new AtomicInteger(0);
        targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> witherDifficulty.set(difficultyCap.getSpawnedWithers()));
        AtomicInteger dragonDifficulty = new AtomicInteger(0);
        targetPlayer.getCapability(Difficulty.INSTANCE).ifPresent(difficultyCap -> dragonDifficulty.set(difficultyCap.getKilledDragons()));
        if (entity.contains("wither")) {
            return PBCommand.summon(source, entity, witherDifficulty.get());
        }
        if (entity.contains("dragon")) {
            return PBCommand.summon(source, entity, dragonDifficulty.get());
        }
        if (entity.contains("elder")) {
            return PBCommand.summon(source, entity, 0);
        }
        return 0;
    }
}

