/*
 * Decompiled with CFR 0.152.
 */
package com.shutdowner.threading;

import com.shutdowner.Shutdowner;
import com.shutdowner.event.EventHandler;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraftforge.server.ServerLifecycleHooks;

public class WatcherThread
implements Runnable {
    private static final int FIVEMINMILISECONDS = 300000;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private AtomicLong shutDownTime = new AtomicLong(0L);
    private AtomicLong maxShutDownTime = new AtomicLong(0L);
    private AtomicBoolean shutDownDone = new AtomicBoolean(false);
    private AtomicLong lastTick = new AtomicLong(0L);
    private int tickTimer = 0;

    @Override
    public void run() {
        this.init();
        try {
            while (true) {
                if (this.shuttingDown.get() && System.currentTimeMillis() - this.shutDownTime.get() > this.maxShutDownTime.get()) {
                    Shutdowner.LOGGER.warn("Detected server shutdown hanging, killing");
                    try {
                        Executors.newCachedThreadPool().submit(() -> ServerLifecycleHooks.getCurrentServer().m_195514_(true, false, false));
                    }
                    catch (Exception e) {
                        Shutdowner.LOGGER.warn("Error during saving before killing:", (Throwable)e);
                    }
                    Thread.sleep(60000L);
                    this.printThreads();
                    Thread.sleep(10000L);
                    Runtime.getRuntime().halt(0);
                }
                if (this.shutDownDone.get()) {
                    Thread.sleep(5000L);
                    Shutdowner.LOGGER.warn("Server shut down correctly, ending gracefully");
                    Thread.sleep(1000L);
                    Runtime.getRuntime().halt(0);
                }
                if (((Boolean)Shutdowner.getConfig().getCommonConfig().shouldDetectHang.get()).booleanValue() && System.currentTimeMillis() - this.lastTick.get() > 300000L) {
                    Shutdowner.LOGGER.warn("Detected server hanging, shutting down");
                    try {
                        Executors.newCachedThreadPool().submit(() -> ServerLifecycleHooks.getCurrentServer().m_195514_(true, false, false));
                    }
                    catch (Exception e) {
                        Shutdowner.LOGGER.warn("Error during saving before killing:", (Throwable)e);
                    }
                    Thread.sleep(60000L);
                    this.printThreads();
                    Thread.sleep(10000L);
                    Runtime.getRuntime().halt(0);
                }
                Thread.sleep(30000L);
            }
        }
        catch (InterruptedException e) {
            Shutdowner.LOGGER.warn("Shutdowner watcher thread interrupted, shutting down");
            EventHandler.executor.shutdownNow();
            return;
        }
    }

    private void init() {
        this.lastTick.set(System.currentTimeMillis());
    }

    private void printThreads() {
        if (((Boolean)Shutdowner.getConfig().getCommonConfig().printThreads.get()).booleanValue()) {
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                if (entry.getKey() == Thread.currentThread() || entry.getKey().isDaemon()) continue;
                Shutdowner.LOGGER.warn("------------ Thread: " + entry.getKey().getName() + " is still running! stacktrace below");
                for (StackTraceElement element : entry.getValue()) {
                    Shutdowner.LOGGER.warn(element.toString());
                }
            }
        }
    }

    public void notifyShutDownEvent() {
        this.shuttingDown.set(true);
        this.shutDownTime.set(System.currentTimeMillis());
        this.maxShutDownTime.set((Integer)Shutdowner.getConfig().getCommonConfig().maxShutDownTime.get() * 1000);
    }

    public void notifyShutDownDone() {
        this.shutDownDone.set(true);
    }

    public void onServerTick() {
        if (++this.tickTimer == 100) {
            this.tickTimer = 0;
            this.lastTick.set(System.currentTimeMillis());
        }
    }
}

