/*
 * Decompiled with CFR 0.152.
 */
package com.shutdowner.event;

import com.shutdowner.Shutdowner;
import com.shutdowner.handlers.ShutDownHandler;
import com.shutdowner.threading.WatcherThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private static WatcherThread watcherThread;
    public static ExecutorService executor;

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void onServerStopping(ServerStoppingEvent event) {
        watcherThread.notifyShutDownEvent();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void onServerStopping(ServerStoppedEvent event) {
        watcherThread.notifyShutDownDone();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void onServerStarted(ServerStartedEvent event) {
        ShutDownHandler.onServerStart();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        watcherThread.onServerTick();
        ShutDownHandler.onServerTick();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void onWorldLoad(LevelEvent.Load event) {
        if (watcherThread == null && ((Boolean)Shutdowner.getConfig().getCommonConfig().shouldDetectShutDownHang.get()).booleanValue()) {
            watcherThread = new WatcherThread();
            executor.submit(watcherThread);
        }
    }

    static {
        executor = Executors.newFixedThreadPool(1);
    }
}

