/*
 * Decompiled with CFR 0.152.
 */
package com.shutdowner.config;

import com.shutdowner.Shutdowner;
import com.shutdowner.config.CommonConfiguration;
import com.shutdowner.handlers.ShutDownHandler;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    private final CommonConfiguration commonConfig;

    public Configuration() {
        Pair com = new ForgeConfigSpec.Builder().configure(CommonConfiguration::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)com.getRight());
        this.commonConfig = (CommonConfiguration)com.getLeft();
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }

    public void parseConfig() {
        String[] splitData;
        ShutDownHandler.announcements.clear();
        for (String data : (List)this.commonConfig.shutdownMessages.get()) {
            splitData = data.split(";");
            if (splitData.length != 2) {
                Shutdowner.LOGGER.warn("Mistake in config entry: " + data + " wrong format.");
                continue;
            }
            try {
                int time = Integer.parseInt(splitData[0]);
                ShutDownHandler.announcements.add((Tuple<Integer, String>)new Tuple((Object)time, (Object)splitData[1]));
            }
            catch (Exception e) {
                Shutdowner.LOGGER.warn("Mistake in config entry: " + data, (Throwable)e);
            }
        }
        ShutDownHandler.shutdownTimes.clear();
        for (String data : (List)this.commonConfig.shutdownTimes.get()) {
            splitData = data.split(":");
            if (splitData.length != 2) {
                Shutdowner.LOGGER.warn("Mistake in config entry: " + data + " wrong format.");
                continue;
            }
            try {
                int hour = Integer.parseInt(splitData[0]);
                int minutes = Integer.parseInt(splitData[1]);
                ShutDownHandler.shutdownTimes.add((Tuple<Integer, Integer>)new Tuple((Object)hour, (Object)minutes));
            }
            catch (Exception e) {
                Shutdowner.LOGGER.warn("Mistake in config entry: " + data, (Throwable)e);
            }
        }
    }
}

