/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidColorsImpl;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockAndTintGetter;

public class SoftFluidColors
implements ResourceManagerReloadListener {
    public void m_6213_(ResourceManager resourceManager) {
        RenderedTexturesManager.clearCache();
        TextureCache.clear();
        this.refreshParticleColors(resourceManager);
    }

    private void refreshParticleColors(ResourceManager resourceManager) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Set fluids = SoftFluidRegistry.getRegistry(mc.f_91073_.m_9598_()).m_6579_();
        for (Map.Entry entry : fluids) {
            SoftFluid fluid = (SoftFluid)entry.getValue();
            ResourceLocation location = fluid.getStillTexture();
            int averageColor = -1;
            if (location == null) {
                int tint = fluid.getTintMethod().appliesToStill() ? fluid.getTintColor() : -1;
                TextureAtlas textureMap = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
                TextureAtlasSprite sprite = textureMap.m_118316_(location);
                try {
                    averageColor = this.getColorFrom(sprite, tint);
                }
                catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to load particle color for " + sprite + " using current resource pack. might be a broken png.mcmeta");
                }
            }
            fluid.averageTextureTint = averageColor;
        }
    }

    private int getColorFrom(TextureAtlasSprite sprite, int tint) {
        SpriteContents c = sprite.m_245424_();
        if (sprite == null || c.m_245088_() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int total = 0;
        int totalR = 0;
        int totalB = 0;
        int totalG = 0;
        for (int tryFrame = 0; tryFrame < c.m_245088_(); ++tryFrame) {
            try {
                for (int x = 0; x < c.m_246492_(); ++x) {
                    for (int y = 0; y < c.m_245330_(); ++y) {
                        int pixel = ClientHelper.getPixelRGBA(sprite, tryFrame, x, y);
                        int pixelB = pixel >> 16 & 0xFF;
                        int pixelG = pixel >> 8 & 0xFF;
                        int pixelR = pixel & 0xFF;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            }
            catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
                continue;
            }
        }
        if (total <= 0) {
            return -1;
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)(totalR / total * tintR / 255), (int)(totalG / total * tintG / 255), (int)(totalB / total * tintB / 255));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getSpecialColor(SoftFluidStack softFluidStack, BlockAndTintGetter world, BlockPos pos) {
        void var2_2;
        void var1_1;
        return SoftFluidColorsImpl.getSpecialColor(softFluidStack, (BlockAndTintGetter)var1_1, (BlockPos)var2_2);
    }
}

