/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge;

import java.util.List;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.Lazy;

public class DecoBlocksCompatImpl {
    public static final Supplier<Block> CHANDELIER_ROPE = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("rope_chandelier"), () -> new RopeChandelierBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(0.3f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 15), CompatObjects.CHANDELIER, () -> ParticleTypes.f_123744_));
    public static final Supplier<Block> SOUL_CHANDELIER_ROPE = RegHelper.registerBlock((ResourceLocation)Supplementaries.res("rope_soul_chandelier"), () -> new RopeChandelierBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(0.3f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 11), CompatObjects.SOUL_CHANDELIER, () -> ParticleTypes.f_123745_));
    public static final Supplier<Block> ENDER_CHANDELIER_ROPE = CompatHandler.DECO_BLOCKS_ABNORMALS ? RegHelper.registerBlock((ResourceLocation)Supplementaries.res("rope_ender_chandelier"), () -> new RopeChandelierBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.3f).m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 15), CompatObjects.ENDER_CHANDELIER, CompatObjects.ENDER_FLAME)) : null;
    public static final Supplier<Block> GLOW_CHANDELIER_ROPE = CompatHandler.MUCH_MORE_MOD_COMPAT ? RegHelper.registerBlock((ResourceLocation)Supplementaries.res("rope_glow_chandelier"), () -> new RopeChandelierBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.3f).m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 15), CompatObjects.GLOW_CHANDELIER, CompatObjects.GLOW_FLAME)) : null;

    public static boolean isBrazier(Block b) {
        return b instanceof BrazierBlock;
    }

    public static boolean canLightBrazier(BlockState state) {
        return DecoBlocksCompatImpl.isBrazier(state.m_60734_()) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) == false;
    }

    public static boolean isPalisade(BlockState state) {
        return state.m_60734_() instanceof PalisadeBlock;
    }

    public static void tryConvertingRopeChandelier(BlockState facingState, LevelAccessor world, BlockPos facingPos) {
        Block b = facingState.m_60734_();
        if (b == CompatObjects.CHANDELIER.get()) {
            world.m_7731_(facingPos, CHANDELIER_ROPE.get().m_49966_(), 3);
        } else if (b == CompatObjects.SOUL_CHANDELIER.get()) {
            world.m_7731_(facingPos, SOUL_CHANDELIER_ROPE.get().m_49966_(), 3);
        } else if (b == CompatObjects.ENDER_CHANDELIER.get()) {
            world.m_7731_(facingPos, ENDER_CHANDELIER_ROPE.get().m_49966_(), 3);
        } else if (b == CompatObjects.GLOW_CHANDELIER.get()) {
            world.m_7731_(facingPos, GLOW_CHANDELIER_ROPE.get().m_49966_(), 3);
        }
    }

    public static void init() {
    }

    public static void setupClient() {
        if (CHANDELIER_ROPE != null) {
            ClientHelper.registerRenderType((Block)CHANDELIER_ROPE.get(), (RenderType)RenderType.m_110463_());
        }
        if (SOUL_CHANDELIER_ROPE != null) {
            ClientHelper.registerRenderType((Block)SOUL_CHANDELIER_ROPE.get(), (RenderType)RenderType.m_110463_());
        }
        if (CompatHandler.DECO_BLOCKS_ABNORMALS && ENDER_CHANDELIER_ROPE != null) {
            ClientHelper.registerRenderType((Block)ENDER_CHANDELIER_ROPE.get(), (RenderType)RenderType.m_110463_());
        }
        if (CompatHandler.MUCH_MORE_MOD_COMPAT && GLOW_CHANDELIER_ROPE != null) {
            ClientHelper.registerRenderType((Block)GLOW_CHANDELIER_ROPE.get(), (RenderType)RenderType.m_110463_());
        }
    }

    public static class RopeChandelierBlock
    extends ChandelierBlock {
        private final Supplier<Block> mimic;
        private final Lazy<BlockState> defMimic;
        protected final Lazy<SimpleParticleType> particleData;

        public <T extends ParticleType<?>> RopeChandelierBlock(BlockBehaviour.Properties properties, Supplier<Block> chandelier, Supplier<T> particleData) {
            super(properties, false);
            this.mimic = chandelier;
            this.defMimic = Lazy.of(() -> this.mimic.get().m_49966_());
            this.particleData = Lazy.of(() -> {
                SimpleParticleType data = (SimpleParticleType)particleData.get();
                if (data == null) {
                    data = ParticleTypes.f_123744_;
                }
                return data;
            });
        }

        public MutableComponent m_49954_() {
            return this.mimic.get().m_49954_();
        }

        public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
            return this.mimic.get().getCloneItemStack((BlockState)this.defMimic.get(), target, world, pos, player);
        }

        public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
            return this.mimic.get().m_49635_((BlockState)this.defMimic.get(), builder);
        }

        public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
            if (facing == Direction.UP && !(facingState.m_60734_() instanceof RopeBlock)) {
                return (BlockState)this.defMimic.get();
            }
            return stateIn;
        }

        public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.7;
            double d2 = (double)pos.m_123343_() + 0.5;
            double off1 = 0.1875;
            double off2 = 0.3125;
            double off3 = 0.0625;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 - off1, d1, d2 - off2, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 - off2 - off3, d1, d2 + off1 - off3, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + off1 - off3, d1, d2 + off2 + off3, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + off2, d1, d2 - off1, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)this.particleData.get(), d0 - off1, d1, d2 - off2, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)this.particleData.get(), d0 - off2 - off3, d1, d2 + off1 - off3, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)this.particleData.get(), d0 + off1 - off3, d1, d2 + off2 + off3, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)this.particleData.get(), d0 + off2, d1, d2 - off1, 0.0, 0.0, 0.0);
        }
    }
}

