/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BombEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private final boolean hasFuse = CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private BombType type = BombType.NORMAL;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public BombEntity(EntityType<? extends BombEntity> type, Level world) {
        super(type, world);
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public BombEntity(Level worldIn, LivingEntity throwerIn, BombType type) {
        super(ModEntities.BOMB.get(), throwerIn, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public BombEntity(Level worldIn, double x, double y, double z, BombType type) {
        super(ModEntities.BOMB.get(), x, y, z, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Active", this.active);
        compound.m_128405_("Type", this.type.ordinal());
        compound.m_128405_("Timer", this.changeTimer);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.active = compound.m_128471_("Active");
        this.type = BombType.values()[compound.m_128451_("Type")];
        this.changeTimer = compound.m_128451_("Timer");
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.type = (BombType)buffer.m_130066_(BombType.class);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    protected Item m_7881_() {
        return ModRegistry.BOMB_ITEM_ON.get();
    }

    public ItemStack m_7846_() {
        return this.type.getDisplayStack(this.active);
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7822_(byte id) {
        switch (id) {
            default: {
                super.m_7822_(id);
                break;
            }
            case 3: {
                this.spawnBreakParticles();
                this.m_146870_();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                if (MiscUtils.FESTIVITY.isBirthday()) {
                    this.spawnParticleInASphere((ParticleOptions)ModParticles.CONFETTI_PARTICLE.get(), 55, 0.3f);
                } else {
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), this.type.getRadius(), 0.0, 0.0);
                }
                this.type.spawnExtraParticles(this);
                this.m_146870_();
                break;
            }
            case 68: {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                RandomSource random = this.m_9236_().m_213780_();
                for (int i = 0; i < 10; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + 0.25 - (double)(random.m_188501_() * 0.5f), this.m_20186_() + (double)0.45f - (double)(random.m_188501_() * 0.5f), this.m_20189_() + 0.25 - (double)(random.m_188501_() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
            }
        }
    }

    private void spawnParticleInASphere(ParticleOptions type, int amount, float speed) {
        double d = Math.PI * 2 / (double)amount;
        float d22 = 0.0f;
        while ((double)d22 < Math.PI * 2) {
            Vec3 v = new Vec3((double)speed, 0.0, 0.0);
            v = v.m_82524_(d22 + this.f_19796_.m_188501_() * 0.3f);
            v = v.m_82535_((float)((double)this.f_19796_.m_188501_() * Math.PI));
            this.m_9236_().m_7106_(type, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), v.f_82479_, v.f_82480_, v.f_82481_);
            d22 = (float)((double)d22 + d);
        }
    }

    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (this.changeTimer > 0) {
            --this.changeTimer;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.active && this.m_20069_() && this.type != BombType.BLUE) {
            this.turnOff();
        }
        super.m_8119_();
    }

    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
        if (this.active && !this.f_19803_) {
            double x = currentPos.f_82479_;
            double y = currentPos.f_82480_;
            double z = currentPos.f_82481_;
            double dx = newPos.f_82479_ - x;
            double dy = newPos.f_82480_ - y;
            double dz = newPos.f_82481_ - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = (double)i / (double)s;
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0.0, 0.02, 0.0);
            }
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        hit.m_82443_().m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), 1.0f);
        if (hit.m_82443_() instanceof LargeFireball) {
            this.superCharged = true;
            hit.m_82443_().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void turnOff() {
        Level level = this.m_9236_();
        if (!level.m_5776_()) {
            level.m_7605_((Entity)this, (byte)67);
            level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f, 1.5f);
        }
        this.active = false;
    }

    public void m_6123_(Player entityIn) {
        if (!this.m_9236_().f_46443_ && !this.active && entityIn.m_150109_().m_36054_(this.m_7846_())) {
            entityIn.m_7938_((Entity)this, 1);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Vec3 vector3d = hit.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_((double)this.m_7139_());
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Level level = this.m_9236_();
        if (!level.f_46443_ && !this.hasFuse) {
            boolean isInstantlyActivated = this.type.isInstantlyActivated();
            if (!isInstantlyActivated && this.changeTimer == -1) {
                this.changeTimer = 10;
                level.m_7605_((Entity)this, (byte)68);
                level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.5f, 1.3f);
            }
            if (!this.m_213877_() && (isInstantlyActivated || this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void m_37283_() {
    }

    public void reachedEndOfLife() {
        Level level = this.m_9236_();
        level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.5f, 1.5f);
        if (!level.f_46443_) {
            if (this.active) {
                this.createExplosion();
                level.m_7605_((Entity)this, (byte)10);
            } else {
                level.m_7605_((Entity)this, (byte)3);
            }
            this.m_146870_();
        }
    }

    private void createExplosion() {
        Player p;
        Entity entity;
        boolean breaks;
        boolean bl = breaks = this.m_19749_() instanceof Player || PlatHelper.isMobGriefingOn((Level)this.m_9236_(), (Entity)this.m_19749_());
        if (CompatHandler.FLAN && (entity = this.m_19749_()) instanceof Player && !FlanCompat.canBreak(p = (Player)entity, BlockPos.m_274446_((Position)this.m_20182_()))) {
            breaks = false;
        }
        if (this.superCharged) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, breaks, this.m_19749_() instanceof Player ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.MOB);
        }
        BombExplosion explosion = new BombExplosion(this.m_9236_(), (Entity)this, new BombExplosionDamageCalculator(this.type), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), (float)this.type.getRadius(), this.type, breaks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
        explosion.m_46061_();
        explosion.doFinalizeExplosion();
    }

    public static enum BombType {
        NORMAL(ModRegistry.BOMB_ITEM, ModRegistry.BOMB_ITEM_ON),
        BLUE(ModRegistry.BOMB_BLUE_ITEM, ModRegistry.BOMB_BLUE_ITEM_ON),
        SPIKY(ModRegistry.BOMB_SPIKY_ITEM, ModRegistry.BOMB_SPIKY_ITEM_ON);

        public final Supplier<Item> item;
        public final Supplier<Item> itemOn;

        private BombType(Supplier<Item> item, Supplier<Item> itemOn) {
            this.item = item;
            this.itemOn = itemOn;
        }

        public ItemStack getDisplayStack(boolean active) {
            return (active ? this.itemOn : this.item).get().m_7968_();
        }

        public double getRadius() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_RADIUS.get() : CommonConfigs.Tools.BOMB_RADIUS.get();
        }

        public BreakingMode breakMode() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_BREAKS.get() : CommonConfigs.Tools.BOMB_BREAKS.get();
        }

        public float volume() {
            return this == BLUE ? 5.0f : 3.0f;
        }

        public void applyStatusEffects(LivingEntity entity, double distSq) {
            switch (this) {
                case BLUE: {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 600));
                    entity.m_20254_(10);
                    break;
                }
            }
        }

        public boolean isInstantlyActivated() {
            return this != BLUE;
        }

        public void spawnExtraParticles(BombEntity bomb) {
            switch (this) {
                case BLUE: {
                    bomb.spawnParticleInASphere((ParticleOptions)ParticleTypes.f_123744_, 40, 0.6f);
                    break;
                }
                case SPIKY: {
                    ParticleType<?> particle = CompatObjects.SHARPNEL.get();
                    if (particle instanceof ParticleOptions) {
                        ParticleOptions p = (ParticleOptions)particle;
                        for (int i = 0; i < 80; ++i) {
                            float dx = (float)(bomb.f_19796_.m_188583_() * 2.0);
                            float dy = (float)(bomb.f_19796_.m_188583_() * 2.0);
                            float dz = (float)(bomb.f_19796_.m_188583_() * 2.0);
                            bomb.m_9236_().m_7106_(p, bomb.m_20185_(), bomb.m_20186_() + 1.0, bomb.m_20189_(), (double)dx, (double)dy, (double)dz);
                        }
                        break;
                    }
                    bomb.spawnParticleInASphere((ParticleOptions)ParticleTypes.f_123797_, 100, 5.0f);
                }
            }
        }

        public void afterExploded(BombExplosion exp, Level level) {
            if (this == SPIKY) {
                Vec3 pos = exp.m_46077_().m_7270_();
                LivingEntity e = exp.m_252906_();
                if (e == null) {
                    return;
                }
                for (Entity entity : level.m_45933_((Entity)e, new AABB(pos.f_82479_ - 30.0, pos.f_82480_ - 4.0, pos.f_82481_ - 30.0, pos.f_82479_ + 30.0, pos.f_82480_ + 4.0, pos.f_82481_ + 30.0))) {
                    int random = level.f_46441_.m_188502_() * 100;
                    boolean shouldPoison = false;
                    if (entity.m_20280_((Entity)e) <= 16.0) {
                        shouldPoison = true;
                    } else if (entity.m_20280_((Entity)e) <= 64.0) {
                        if (random < 60) {
                            shouldPoison = true;
                        }
                    } else if (entity.m_20280_((Entity)e) <= 225.0) {
                        if (random < 30) {
                            shouldPoison = true;
                        }
                    } else if (entity.m_20280_((Entity)e) <= 900.0 && random < 5) {
                        shouldPoison = true;
                    }
                    if (!shouldPoison || !(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_6469_(level.m_269111_().m_269425_(), 2.0f);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 130));
                    MobEffect effect = CompatObjects.STUNNED_EFFECT.get();
                    if (effect == null) continue;
                    livingEntity.m_7292_(new MobEffectInstance(effect, 400));
                }
            }
        }
    }

    private static class BombExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        private final BombType type;

        public BombExplosionDamageCalculator(BombType type) {
            this.type = type;
        }

        public boolean m_6714_(Explosion explosion, BlockGetter reader, BlockPos pos, BlockState state, float power) {
            return switch (this.type.breakMode()) {
                default -> false;
                case BreakingMode.ALL -> true;
                case BreakingMode.WEAK -> state.m_60722_((Fluid)Fluids.f_76193_) || state.m_204336_(ModTags.BOMB_BREAKABLE) || state.m_60734_() instanceof TntBlock;
            };
        }
    }

    public static enum BreakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

