/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import party.lemons.biomemakeover.init.BMBlocks;

public class FissureFeature
extends Feature<FissureConfig> {
    public FissureFeature(Codec<FissureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FissureConfig> ctx) {
        RandomSource random = ctx.m_225041_();
        WorldGenLevel level = ctx.m_159774_();
        BlockPos origin = ctx.m_159777_();
        FissureConfig cfg = (FissureConfig)ctx.m_159778_();
        ArrayList offsets = Lists.newArrayList();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)origin);
        DirPos originStart = new DirPos(Direction.m_122407_((int)random.m_188503_(4)), pos.m_7949_(), cfg.baseHeight.m_214085_(random));
        offsets.add(originStart);
        this.createOffsets(originStart.movedPosition, cfg.count.m_214085_(random), offsets, originStart, random, cfg.heightOffset);
        this.createOffsets(originStart.movedPosition.m_122424_(), cfg.count.m_214085_(random), offsets, originStart, random, cfg.heightOffset);
        ArrayList spreadOffsets = Lists.newArrayList();
        for (int i = 0; i < cfg.spreadOffset.m_214085_(random); ++i) {
            this.spreadOffset(offsets, spreadOffsets, random);
        }
        offsets.addAll(spreadOffsets);
        if (offsets.isEmpty()) {
            return false;
        }
        boolean generated = false;
        HashSet alternatePositions = Sets.newHashSet();
        for (DirPos genPos : offsets) {
            pos.m_122190_((Vec3i)genPos.pos);
            Optional scan = Column.m_158175_((LevelSimulatedReader)level, (BlockPos)pos, (int)5, b -> b.m_60795_() || b.m_60713_(Blocks.f_49990_), b -> !b.m_60795_() && !b.m_60713_(Blocks.f_49990_));
            if (scan.isEmpty() || ((Column)scan.get()).m_142009_().isEmpty()) continue;
            generated = true;
            pos.m_142448_(((Column)scan.get()).m_142009_().getAsInt());
            int height = genPos.height;
            for (int i = 0; i < height; ++i) {
                BlockState fillState = cfg.fillBlock.m_213972_(random, (BlockPos)pos);
                BlockState currentState = level.m_8055_((BlockPos)pos);
                boolean isSource = currentState.m_60819_().m_76170_();
                if (isSource && fillState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    fillState = (BlockState)fillState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(isSource));
                } else if (isSource && fillState.m_60795_()) {
                    fillState = Blocks.f_49990_.m_49966_();
                }
                level.m_7731_((BlockPos)pos, fillState, 2);
                level.m_186469_((BlockPos)pos, fillState.m_60819_().m_76152_(), 0);
                float chance = 0.1f + (float)i / 5.0f;
                if (chance > 1.0f || random.m_188501_() < chance) {
                    this.setAround(cfg.coreBlock, cfg.depthBlock, cfg.alternateCoreBlock, cfg.alternateChance, alternatePositions, fillState, (BlockPos)pos, level, random);
                }
                pos.m_122173_(Direction.DOWN);
            }
        }
        List<BlockState> innerStates = cfg.innerPlacements;
        block3: for (BlockPos alternatePos : alternatePositions) {
            if (cfg.innerPlacementChance > random.m_188501_() || !cfg.target.test((Object)level, (Object)alternatePos)) continue;
            BlockState placeState = (BlockState)Util.m_214621_(innerStates, (RandomSource)random);
            for (Direction direction2 : Direction.values()) {
                if (placeState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    placeState = (BlockState)placeState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction2);
                }
                BlockPos offsetPos = alternatePos.m_121945_(direction2);
                BlockState currentState = level.m_8055_(offsetPos);
                if (placeState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    placeState = (BlockState)placeState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(currentState.m_60819_().m_76170_()));
                }
                if (!placeState.m_60710_((LevelReader)level, offsetPos) || !BuddingAmethystBlock.m_152734_((BlockState)currentState)) continue;
                level.m_7731_(offsetPos, placeState, 2);
                continue block3;
            }
        }
        return generated;
    }

    public void setAround(BlockStateProvider coreState, BlockStateProvider depthState, BlockStateProvider alternateState, float alternateChance, Set<BlockPos> alternatePositions, BlockState fillState, BlockPos pos, WorldGenLevel level, RandomSource randomSource) {
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            BlockStateProvider stateProvider;
            if (direction == Direction.UP) continue;
            mutPos.m_122159_((Vec3i)pos, direction);
            BlockState existingState = level.m_8055_((BlockPos)mutPos);
            if (existingState.m_60795_() || existingState.m_60713_(fillState.m_60734_())) continue;
            if (randomSource.m_188501_() < alternateChance) {
                stateProvider = alternateState;
                alternatePositions.add(mutPos.m_7949_());
            } else {
                stateProvider = coreState;
            }
            level.m_7731_((BlockPos)mutPos, stateProvider.m_213972_(randomSource, (BlockPos)mutPos), 2);
            mutPos.m_122173_(direction);
            BlockState current = level.m_8055_((BlockPos)mutPos);
            if (current.m_204336_(BMBlocks.FISSURE_NO_REPLACE)) continue;
            level.m_7731_((BlockPos)mutPos, depthState.m_213972_(randomSource, (BlockPos)mutPos), 2);
        }
    }

    private void spreadOffset(List<DirPos> offsets, List<DirPos> spreadOffsets, RandomSource random) {
        List<DirPos> targetList = spreadOffsets.isEmpty() ? offsets : spreadOffsets;
        ArrayList newPostions = Lists.newArrayList();
        for (DirPos pos : targetList) {
            DirPos offset2;
            DirPos offset1 = this.createSpreadOffset(pos, pos.movedPosition.m_122427_(), random);
            if (!(offsets.contains(offset1) || spreadOffsets.contains(offset1) || newPostions.contains(offset1))) {
                newPostions.add(offset1);
            }
            if (offsets.contains(offset2 = this.createSpreadOffset(pos, pos.movedPosition.m_122428_(), random)) || spreadOffsets.contains(offset2) || newPostions.contains(offset2)) continue;
            newPostions.add(offset2);
        }
        spreadOffsets.addAll(newPostions);
    }

    private DirPos createSpreadOffset(DirPos dirPos, Direction direction, RandomSource randomSource) {
        return new DirPos(dirPos.movedPosition, dirPos.pos().m_121945_(direction), Math.max(1, dirPos.height - randomSource.m_216339_(2, 5)));
    }

    private void createOffsets(Direction direction, int count, List<DirPos> offsets, DirPos start, RandomSource random, IntProvider heightOffset) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.m_122190_((Vec3i)start.pos.m_121945_(direction));
        DirPos last = start;
        for (int i = 0; i < count; ++i) {
            DirPos newPos;
            last = newPos = new DirPos(direction, pos.m_7949_(), last.height + heightOffset.m_214085_(random));
            if (!offsets.contains(newPos)) {
                offsets.add(newPos);
            }
            if (random.m_188503_(5) == 0) {
                direction = random.m_188499_() ? direction.m_122428_() : direction.m_122427_();
            }
            pos.m_122173_(direction);
        }
    }

    public record FissureConfig(IntProvider baseHeight, IntProvider heightOffset, IntProvider spreadOffset, IntProvider count, BlockStateProvider coreBlock, BlockStateProvider depthBlock, BlockStateProvider alternateCoreBlock, float alternateChance, List<BlockState> innerPlacements, float innerPlacementChance, BlockStateProvider fillBlock, BlockPredicate target) implements FeatureConfiguration
    {
        public static final Codec<FissureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.f_146531_.fieldOf("height").forGetter(c -> c.baseHeight), (App)IntProvider.f_146531_.fieldOf("height_offset").forGetter(c -> c.heightOffset), (App)IntProvider.f_146531_.fieldOf("spread_offset").forGetter(c -> c.spreadOffset), (App)IntProvider.f_146531_.fieldOf("count").forGetter(c -> c.count), (App)BlockStateProvider.f_68747_.fieldOf("base_block").forGetter(c -> c.coreBlock), (App)BlockStateProvider.f_68747_.fieldOf("depth_block").forGetter(c -> c.depthBlock), (App)BlockStateProvider.f_68747_.fieldOf("alternate_base_block").forGetter(c -> c.alternateCoreBlock), (App)Codec.FLOAT.fieldOf("alternate_chance").forGetter(c -> Float.valueOf(c.alternateChance)), (App)ExtraCodecs.m_144637_((Codec)BlockState.f_61039_.listOf()).fieldOf("inner_placements").forGetter(c -> c.innerPlacements), (App)Codec.FLOAT.fieldOf("inner_placement_chance").forGetter(c -> Float.valueOf(c.innerPlacementChance)), (App)BlockStateProvider.f_68747_.fieldOf("fill_block").forGetter(c -> c.fillBlock), (App)BlockPredicate.f_190392_.fieldOf("inner_target").forGetter(c -> c.target)).apply((Applicative)instance, FissureConfig::new));
    }

    private record DirPos(Direction movedPosition, BlockPos pos, int height) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirPos dirPos = (DirPos)o;
            return this.pos.equals((Object)dirPos.pos);
        }

        @Override
        public int hashCode() {
            return this.pos.hashCode();
        }
    }
}

