/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import party.lemons.biomemakeover.BiomeMakeover;
import party.lemons.biomemakeover.entity.LightningBugEntity;
import party.lemons.biomemakeover.entity.render.LightningBugModel;
import party.lemons.taniwha.util.MathUtils;

public class LightningBugRender
extends MobRenderer<LightningBugEntity, LightningBugModel> {
    public static final ResourceLocation TEXTURE = BiomeMakeover.ID("textures/entity/lightning_bug.png");

    public LightningBugRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new LightningBugModel(context.m_174023_(LightningBugModel.LAYER_LOCATION)), 0.25f);
        this.m_115326_(new LightningBugRenderLayer(this, new LightningBugModel.LightningBugInner(context.m_174023_(LightningBugModel.LAYER_LOCATION_INNER)), true));
        this.m_115326_(new LightningBugRenderLayer(this, new LightningBugModel.LightningBugOuter(context.m_174023_(LightningBugModel.LAYER_LOCATION_OUTER)), false));
    }

    @Nullable
    protected RenderType getRenderType(LightningBugEntity livingEntity, boolean bl, boolean bl2, boolean bl3) {
        return null;
    }

    protected void scale(LightningBugEntity entity, PoseStack poseStack, float amount) {
        super.m_7546_((LivingEntity)entity, poseStack, amount);
        entity.scale += amount / 10.0f;
        if (entity.scale > 99999.0f) {
            entity.scale = 0.0f;
        }
        float sc = 0.9f + (float)Math.sin(entity.scale) / 5.0f;
        this.f_114477_ = sc / 10.0f;
        poseStack.m_85841_(sc, sc, sc);
    }

    protected int getBlockLightLevel(LightningBugEntity entity, BlockPos blockPos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(LightningBugEntity entity) {
        return TEXTURE;
    }

    private static class LightningBugRenderLayer
    extends RenderLayer<LightningBugEntity, LightningBugModel> {
        private final EntityModel<LightningBugEntity> model;
        private final boolean color;

        public LightningBugRenderLayer(LightningBugRender lightningBugRender, EntityModel<LightningBugEntity> model, boolean color) {
            super((RenderLayerParent)lightningBugRender);
            this.model = model;
            this.color = color;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, LightningBugEntity entity, float f, float g, float delta, float j, float k, float l) {
            if (!entity.m_20145_()) {
                Vector3f color = this.color ? this.getColor(entity, delta) : new Vector3f(1.0f, 1.0f, 1.0f);
                VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)entity)));
                this.model.m_7695_(poseStack, vertexConsumer, i, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), color.x(), color.y(), color.z(), 1.0f);
            }
        }

        public Vector3f getColor(LightningBugEntity entity, float delta) {
            BlockPos pos = entity.m_20097_();
            int redHash = pos.hashCode();
            int greenHash = (pos.m_123341_() + pos.m_123342_() * 31) * 31 + pos.m_123343_();
            int blueHash = (pos.m_123343_() + pos.m_123341_() * 31) * 31 + pos.m_123342_();
            float drawRed = 1.0f;
            float drawGreen = 1.0f;
            float drawBlue = 1.0f;
            float rTarget = (float)(redHash % 255) / 255.0f;
            float bTarget = (float)(greenHash % 255) / 255.0f;
            float gTarget = (float)(blueHash % 255) / 255.0f;
            if (entity.prevRed == -1.0f) {
                drawRed = rTarget;
                drawGreen = gTarget;
                drawBlue = bTarget;
            } else {
                drawRed = MathUtils.approachValue((float)entity.prevRed, (float)rTarget, (float)(0.025f * delta));
                drawGreen = MathUtils.approachValue((float)entity.prevGreen, (float)gTarget, (float)(0.025f * delta));
                drawBlue = MathUtils.approachValue((float)entity.prevBlue, (float)bTarget, (float)(0.025f * delta));
            }
            entity.prevRed = drawRed;
            entity.prevGreen = drawGreen;
            entity.prevBlue = drawBlue;
            return new Vector3f(drawRed, Mth.m_14154_((float)drawGreen), drawBlue);
        }
    }
}

