/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.entity.ai;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class MountedCrossbowAttackGoal<T extends Monster & CrossbowAttackMob>
extends Goal {
    public static final UniformInt chargeTime = TimeUtil.m_145020_((int)1, (int)2);
    private final T actor;
    private Stage stage = Stage.UNCHARGED;
    private final float squaredRange;
    private int seeingTargetTicker;
    private int chargedTicksLeft;

    public MountedCrossbowAttackGoal(T actor, float range) {
        this.actor = actor;
        this.squaredRange = range * range;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canStart() {
        return this.hasAliveTarget() && this.isEntityHoldingCrossbow();
    }

    private boolean isEntityHoldingCrossbow() {
        return this.actor.m_21055_(Items.f_42717_);
    }

    public boolean m_8036_() {
        return this.canStart();
    }

    public boolean m_8045_() {
        return this.canStart();
    }

    private boolean hasAliveTarget() {
        return this.actor.m_5448_() != null && this.actor.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.actor.m_21561_(false);
        this.actor.m_6710_(null);
        this.seeingTargetTicker = 0;
        if (this.actor.m_6117_()) {
            this.actor.m_5810_();
            ((CrossbowAttackMob)this.actor).m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.actor.m_21211_(), (boolean)false);
        }
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.actor.m_5448_();
        if (livingEntity != null) {
            boolean tickerTicking;
            boolean canSee = this.actor.m_21574_().m_148306_((Entity)livingEntity);
            boolean bl = tickerTicking = this.seeingTargetTicker > 0;
            if (canSee != tickerTicking) {
                this.seeingTargetTicker = 0;
            }
            this.seeingTargetTicker = canSee ? ++this.seeingTargetTicker : --this.seeingTargetTicker;
            double distance = this.actor.m_20280_((Entity)livingEntity);
            boolean outOfRange = (distance > (double)this.squaredRange || this.seeingTargetTicker < 5) && this.chargedTicksLeft == 0;
            this.actor.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            if (this.stage == Stage.UNCHARGED) {
                if (!outOfRange) {
                    this.actor.m_6672_(ProjectileUtil.m_37297_(this.actor, (Item)Items.f_42717_));
                    this.stage = Stage.CHARGING;
                    ((CrossbowAttackMob)this.actor).m_6136_(true);
                }
            } else if (this.stage == Stage.CHARGING) {
                ItemStack itemStack;
                int changeTime;
                if (!this.actor.m_6117_()) {
                    this.stage = Stage.UNCHARGED;
                }
                if ((changeTime = this.actor.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemStack = this.actor.m_21211_()))) {
                    this.actor.m_5810_();
                    this.stage = Stage.CHARGED;
                    this.chargedTicksLeft = 2 + this.actor.m_217043_().m_188503_(10);
                    ((CrossbowAttackMob)this.actor).m_6136_(false);
                }
            } else if (this.stage == Stage.CHARGED) {
                --this.chargedTicksLeft;
                if (this.chargedTicksLeft == 0) {
                    this.stage = Stage.READY_TO_ATTACK;
                }
            } else if (this.stage == Stage.READY_TO_ATTACK && canSee) {
                ((CrossbowAttackMob)this.actor).m_32336_(this.actor, 1.0f);
                ItemStack cbStack = this.actor.m_21120_(ProjectileUtil.m_37297_(this.actor, (Item)Items.f_42717_));
                CrossbowItem.m_40884_((ItemStack)cbStack, (boolean)false);
                this.stage = Stage.UNCHARGED;
            }
        }
    }

    static enum Stage {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

