/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.api.util.ItemStackHelper;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MessageUpdateBackpack
extends PlayMessage<MessageUpdateBackpack> {
    private int entityId;
    private ItemStack backpack;
    private boolean fullTag;

    public MessageUpdateBackpack() {
    }

    public MessageUpdateBackpack(int entityId, ItemStack backpack) {
        this(entityId, backpack, false);
    }

    public MessageUpdateBackpack(int entityId, ItemStack backpack, boolean fullTag) {
        this.entityId = entityId;
        this.backpack = backpack;
        this.fullTag = fullTag;
    }

    public void encode(MessageUpdateBackpack message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        this.writeBackpack(buffer, message.backpack, message.fullTag);
    }

    public MessageUpdateBackpack decode(FriendlyByteBuf buffer) {
        return new MessageUpdateBackpack(buffer.readInt(), buffer.m_130267_());
    }

    public void handle(MessageUpdateBackpack message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleUpdateBackpack(message));
        context.setHandled(true);
    }

    private void writeBackpack(FriendlyByteBuf buffer, ItemStack stack, boolean fullTag) {
        if (!stack.m_41619_()) {
            buffer.writeBoolean(true);
            buffer.m_130130_(Item.m_41393_((Item)stack.m_41720_()));
            buffer.writeByte(stack.m_41613_());
            buffer.m_130079_(this.getBackpackTag(stack, fullTag));
            return;
        }
        buffer.writeBoolean(false);
    }

    @Nullable
    private CompoundTag getBackpackTag(ItemStack stack, boolean fullTag) {
        Item item = stack.m_41720_();
        if (!ItemStackHelper.isDamageable((ItemStack)stack) && !item.m_41468_()) {
            return null;
        }
        CompoundTag realTag = stack.m_41784_();
        if (fullTag) {
            return realTag;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("BackpackModel", realTag.m_128461_("BackpackModel"));
        for (ModelProperty property : ModelProperty.values()) {
            String tagName = property.getTagName();
            boolean value = realTag.m_128425_(tagName, 1) ? realTag.m_128471_(tagName) : property.getDefaultValue();
            tag.m_128379_(tagName, value);
        }
        tag.m_128365_("Enchantments", (Tag)stack.m_41785_());
        tag.m_128365_("display", (Tag)stack.m_41698_("display"));
        return tag;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }
}

