/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.CrateBlock;
import org.violetmoon.quark.addons.oddities.capability.CrateItemHandler;
import org.violetmoon.quark.addons.oddities.inventory.CrateMenu;
import org.violetmoon.quark.addons.oddities.module.CrateModule;

public class CrateBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private int numPlayersUsing;
    private int[] visibleSlots = new int[0];
    protected final ContainerData crateData = new ContainerData(){

        public int m_6413_(int index) {
            CrateItemHandler handler = CrateBlockEntity.this.itemHandler();
            return index == 0 ? handler.displayTotal : handler.displaySlots;
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super(CrateModule.blockEntityType, pos, state);
    }

    public void spillTheTea() {
        this.itemHandler().spill(this.f_58857_, this.f_58858_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrateBlockEntity be) {
        be.tick();
    }

    public void tick() {
        this.itemHandler().recalculate();
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128391_(this.itemHandler().serializeNBT());
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler().deserializeNBT(nbt);
    }

    public CrateItemHandler itemHandler() {
        Object object;
        LazyOptional handler = this.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (handler.isPresent() && (object = handler.orElse((Object)new EmptyHandler())) instanceof CrateItemHandler) {
            CrateItemHandler crateHandler = (CrateItemHandler)((Object)object);
            return crateHandler;
        }
        return new CrateItemHandler();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.itemHandler().getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.itemHandler().extractItem(slot, 64, true);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.itemHandler().setStackInSlot(slot, stack);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        return this.itemHandler().extractItem(slot, 64, true);
    }

    public int m_6643_() {
        return this.itemHandler().getSlots();
    }

    public void m_6211_() {
        this.itemHandler().clear();
    }

    public boolean m_7983_() {
        return this.itemHandler().isEmpty();
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction dir) {
        return true;
    }

    public boolean m_7155_(int index, @NotNull ItemStack stack, Direction dir) {
        return this.itemHandler().getSlotLimit(index) > 0;
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction dir) {
        int slotCount = this.itemHandler().getSlots();
        if (this.visibleSlots.length != slotCount) {
            this.visibleSlots = new int[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.visibleSlots[i] = i;
            }
        }
        return this.visibleSlots;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)CrateModule.crate.m_7705_());
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return new CrateMenu(id, player, this, this.crateData);
    }

    @NotNull
    protected IItemHandler createUnSidedHandler() {
        return new CrateItemHandler();
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.m_58900_();
            boolean flag = (Boolean)blockstate.m_61143_((Property)CrateBlock.PROPERTY_OPEN);
            if (!flag) {
                this.playSound(blockstate, SoundEvents.f_11725_);
                this.f_58857_.m_142346_((Entity)player, GameEvent.f_157803_, this.f_58858_);
                this.setOpenProperty(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 5);
    }

    public void crateTick() {
        int i = this.f_58858_.m_123341_();
        int j = this.f_58858_.m_123342_();
        int k = this.f_58858_.m_123343_();
        this.numPlayersUsing = CrateBlockEntity.calculatePlayersUsing(this.f_58857_, this, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        }
    }

    public static int calculatePlayersUsing(Level world, BaseContainerBlockEntity container, int x, int y, int z) {
        int i = 0;
        for (Player playerentity : world.m_45976_(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            CrateBlockEntity iinventory;
            if (!(playerentity.f_36096_ instanceof CrateMenu) || (iinventory = ((CrateMenu)playerentity.f_36096_).crate) != container) continue;
            ++i;
        }
        return i;
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
        }
        if (this.numPlayersUsing <= 0) {
            BlockState blockstate = this.m_58900_();
            if (!blockstate.m_60713_(CrateModule.crate)) {
                this.m_7651_();
                return;
            }
            boolean flag = (Boolean)blockstate.m_61143_((Property)CrateBlock.PROPERTY_OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.f_11724_);
                this.f_58857_.m_142346_((Entity)player, GameEvent.f_157803_, this.f_58858_);
                this.setOpenProperty(blockstate, false);
            }
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        BlockPos pos = this.m_58899_();
        BlockState prev = this.f_58857_.m_8055_(pos);
        if (prev.m_60713_(state.m_60734_())) {
            this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)CrateBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState state, SoundEvent sound) {
        double d0 = (double)this.f_58858_.m_123341_() + 0.5;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

