/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ToolHookBlockTile
extends ItemDisplayTile
implements IExtraModelDataProvider {
    public static final ModelDataKey<Boolean> IS_FANCY = ModBlockProperties.FANCY;
    public static final ModelDataKey<ItemStack> ITEM = ModBlockProperties.ITEM;
    private boolean isFancy = false;
    private int extraFancyTicks = 0;

    public ToolHookBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TOOL_HOOK_TILE.get(), pos, state);
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)"tool hook");
    }

    public boolean isNeverFancy() {
        return ClientConfigs.ANIMATED_HOOKS.get() == false;
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(IS_FANCY, (Object)this.isFancy);
        builder.with(ITEM, (Object)this.getDisplayedItem());
    }

    public void onFancyChanged(boolean fancy) {
    }

    public boolean rendersFancy() {
        return this.isFancy;
    }

    public boolean shouldRenderFancy(Vec3 cameraPos) {
        if (this.isNeverFancy()) {
            return false;
        }
        boolean oldStatus = this.isFancy;
        LOD lod = new LOD(cameraPos, this.m_58899_());
        boolean newFancyStatus = lod.isVeryNear();
        if (oldStatus != newFancyStatus) {
            this.isFancy = newFancyStatus;
            this.onFancyChanged(this.isFancy);
            if (this.f_58857_ == Minecraft.m_91087_().f_91073_) {
                this.requestModelReload();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 8);
            }
            if (!this.isFancy) {
                this.extraFancyTicks = 4;
            }
        }
        if (this.extraFancyTicks > 0) {
            --this.extraFancyTicks;
            return true;
        }
        return this.isFancy;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        Item item = stack.m_41720_();
        if (ToolHookBlockTile.isValidTool(item)) {
            return super.m_7013_(index, stack);
        }
        return false;
    }

    public static boolean isValidTool(Item item) {
        return item instanceof DiggerItem || item instanceof SwordItem || item instanceof TridentItem || item.m_204114_().m_203656_(ModTags.GOES_IN_TRIPWIRE_HOOK);
    }

    public void updateTileOnInventoryChanged() {
        super.updateTileOnInventoryChanged();
        if (this.getDisplayedItem().m_41619_() && this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50266_.m_152465_(this.m_58900_()));
        }
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.requestModelReload();
    }
}

