/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.item.ZetaBlockItem;
import org.violetmoon.zeta.registry.IZetaBlockColorProvider;
import org.violetmoon.zeta.registry.IZetaBlockItemProvider;
import org.violetmoon.zeta.registry.IZetaItemColorProvider;
import org.violetmoon.zeta.registry.IZetaItemPropertiesFiller;
import org.violetmoon.zeta.registry.LateBoundHolder;
import org.violetmoon.zeta.util.RegisterDynamicUtil;

public abstract class ZetaRegistry {
    protected final Zeta z;
    private final Multimap<ResourceLocation, Supplier<Object>> defers = ArrayListMultimap.create();
    protected final Map<Object, ResourceLocation> internalNames = new IdentityHashMap<Object, ResourceLocation>();
    private final Map<Block, String> blocksToColorProviderName = new HashMap<Block, String>();
    private final Map<Item, String> itemsToColorProviderName = new HashMap<Item, String>();
    private final Map<ResourceKey<Registry<?>>, List<DynamicEntry<?>>> dynamicDefers = new HashMap();

    public ZetaRegistry(Zeta z) {
        this.z = z;
    }

    public <T> ResourceLocation getRegistryName(T obj, Registry<T> registry) {
        ResourceLocation internal = this.internalNames.get(obj);
        return internal == null ? registry.m_7981_(obj) : internal;
    }

    public ResourceLocation newResourceLocation(String in) {
        if (in.indexOf(58) == -1) {
            return new ResourceLocation(this.z.modid, in);
        }
        return new ResourceLocation(in);
    }

    public <T> void register(T obj, ResourceLocation id, ResourceKey<Registry<T>> registry) {
        IZetaItemColorProvider provider;
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        if (obj instanceof Block) {
            Block block = (Block)obj;
            if (obj instanceof IZetaBlockColorProvider && (provider = (IZetaBlockColorProvider)obj).getBlockColorProviderName() != null) {
                this.blocksToColorProviderName.put(block, provider.getBlockColorProviderName());
            }
        }
        if (obj instanceof Item) {
            Item item = (Item)obj;
            if (obj instanceof IZetaItemColorProvider && (provider = (IZetaItemColorProvider)obj).getItemColorProviderName() != null) {
                this.itemsToColorProviderName.put(item, provider.getItemColorProviderName());
            }
        }
        this.internalNames.put(obj, id);
        this.defers.put((Object)registry.m_135782_(), () -> obj);
    }

    public <T> void register(T obj, String resloc, ResourceKey<Registry<T>> registry) {
        this.register(obj, this.newResourceLocation(resloc), registry);
    }

    public void registerItem(Item item, ResourceLocation id) {
        this.register(item, id, Registries.f_256913_);
    }

    public void registerItem(Item item, String resloc) {
        this.register(item, this.newResourceLocation(resloc), Registries.f_256913_);
    }

    public void registerBlock(Block block, ResourceLocation id, boolean hasBlockItem) {
        this.register(block, id, Registries.f_256747_);
        if (hasBlockItem) {
            this.defers.put((Object)Registries.f_256913_.m_135782_(), () -> this.createItemBlock(block));
        }
    }

    public void registerBlock(Block block, String resloc, boolean hasBlockItem) {
        this.registerBlock(block, this.newResourceLocation(resloc), hasBlockItem);
    }

    public void registerBlock(Block block, ResourceLocation id) {
        this.registerBlock(block, id, true);
    }

    public void registerBlock(Block block, String resloc) {
        this.registerBlock(block, resloc, true);
    }

    private Item createItemBlock(Block block) {
        IZetaItemColorProvider prov;
        Item.Properties props = new Item.Properties();
        ResourceLocation registryName = this.internalNames.get(block);
        if (block instanceof IZetaItemPropertiesFiller) {
            IZetaItemPropertiesFiller filler = (IZetaItemPropertiesFiller)block;
            filler.fillItemProperties(props);
        }
        Object blockitem = block instanceof IZetaBlockItemProvider ? ((IZetaBlockItemProvider)block).provideItemBlock(block, props) : new ZetaBlockItem(block, props);
        if (block instanceof IZetaItemColorProvider && (prov = (IZetaItemColorProvider)block).getItemColorProviderName() != null) {
            this.itemsToColorProviderName.put((Item)blockitem, prov.getItemColorProviderName());
        }
        this.internalNames.put(blockitem, registryName);
        return blockitem;
    }

    public Collection<Supplier<Object>> getDefers(ResourceLocation registryId) {
        return this.defers.get((Object)registryId);
    }

    public void clearDeferCache(ResourceLocation resourceLocation) {
        this.defers.removeAll((Object)resourceLocation);
    }

    public void finalizeBlockColors(BiConsumer<Block, String> consumer) {
        this.blocksToColorProviderName.forEach(consumer);
        this.blocksToColorProviderName.clear();
    }

    public void finalizeItemColors(BiConsumer<Item, String> consumer) {
        this.itemsToColorProviderName.forEach(consumer);
        this.itemsToColorProviderName.clear();
    }

    private <T> ResourceKey<Registry<?>> erase(ResourceKey<? extends Registry<T>> weeeejava) {
        return weeeejava;
    }

    public <T> LateBoundHolder<T> registerDynamicF(Function<RegistryOps.RegistryInfoLookup, T> objCreator, ResourceKey<T> id, ResourceKey<? extends Registry<T>> registry) {
        RegisterDynamicUtil.signup(this.z);
        LateBoundHolder<T> hell = new LateBoundHolder<T>(id);
        this.dynamicDefers.computeIfAbsent(this.erase(registry), __ -> new ArrayList()).add(new DynamicEntry<T>(id, objCreator, hell));
        return hell;
    }

    public <T> LateBoundHolder<T> registerDynamicF(Function<RegistryOps.RegistryInfoLookup, T> objCreator, ResourceLocation id, ResourceKey<? extends Registry<T>> registry) {
        return this.registerDynamicF(objCreator, ResourceKey.m_135785_(registry, (ResourceLocation)id), registry);
    }

    public <T> LateBoundHolder<T> registerDynamicF(Function<RegistryOps.RegistryInfoLookup, T> objCreator, String regname, ResourceKey<? extends Registry<T>> registry) {
        return this.registerDynamicF(objCreator, this.newResourceLocation(regname), registry);
    }

    @Deprecated(forRemoval=true)
    public <T> Holder.Direct<T> registerDynamic(T obj, ResourceKey<T> id, ResourceKey<? extends Registry<T>> registry) {
        RegisterDynamicUtil.signup(this.z);
        this.dynamicDefers.computeIfAbsent(this.erase(registry), __ -> new ArrayList()).add(new DynamicEntry<Object>(id, __ -> obj, null));
        return new Holder.Direct(obj);
    }

    @Deprecated(forRemoval=true)
    public <T> Holder.Direct<T> registerDynamic(T obj, ResourceLocation id, ResourceKey<? extends Registry<T>> registry) {
        return this.registerDynamic(obj, ResourceKey.m_135785_(registry, (ResourceLocation)id), registry);
    }

    public <T> Holder.Direct<T> registerDynamic(T obj, String regname, ResourceKey<? extends Registry<T>> registry) {
        return this.registerDynamic(obj, this.newResourceLocation(regname), registry);
    }

    public <T> void performDynamicRegistration(RegistryOps.RegistryInfoLookup lookup, ResourceKey<? extends Registry<?>> registryKey, WritableRegistry<T> writable) {
        List<DynamicEntry<?>> entries = this.dynamicDefers.get(registryKey);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        this.z.log.info("Dynamically registering {} thing{} into {}", (Object)entries.size(), (Object)(entries.size() > 1 ? "s" : ""), (Object)registryKey.m_135782_());
        List<DynamicEntry<?>> typePun = entries;
        typePun.forEach(entry -> {
            Object thing = entry.creator.apply(lookup);
            writable.m_255290_(entry.id, thing, Lifecycle.stable());
            if (entry.lateBound != null) {
                entry.lateBound.bind(thing, writable);
            }
        });
    }

    private record DynamicEntry<T>(ResourceKey<T> id, Function<RegistryOps.RegistryInfoLookup, T> creator, @Nullable LateBoundHolder<T> lateBound) {
    }
}

