/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Tags", description="Set and use some tags to set some mobs properties. E.g. cause fire explosion for mobs or get if a mob has been spawned from spawner.")
@LoadFeature(module="insanelib:base", canBeDisabled=false)
public class TagsFeature
extends Feature {
    public TagsFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @Override
    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        Entity entity = explosion.getExploder();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        CompoundTag compoundNBT = entity2.getPersistentData();
        if (compoundNBT.m_128471_("insanelib:explosion_causes_fire")) {
            explosion.f_46009_ = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getSpawnType() == MobSpawnType.SPAWNER) {
            event.getEntity().getPersistentData().m_128379_("insanelib:spawned_from_spawner", true);
        }
        if (event.getSpawnType() == MobSpawnType.STRUCTURE) {
            event.getEntity().getPersistentData().m_128379_("insanelib:spawned_from_structure", true);
        }
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        if (event.getEntity().getPersistentData().m_128441_("insanelib:xp_multiplier")) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * event.getEntity().getPersistentData().m_128459_("insanelib:xp_multiplier")));
        }
    }
}

